/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.generation.MacroCharacter;
import com.aspose.barcode.generation.Pdf417CompactionMode;
import com.aspose.barcode.generation.Pdf417ErrorLevel;
import com.aspose.barcode.generation.Pdf417MacroTerminator;
import com.aspose.barcode.generation.bk;
import com.aspose.barcode.generation.bl;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class MwPdf417Parameters
extends MwJavaWrapper<bl> {
    public MwPdf417Parameters(bl nativeObject) throws MwBarcodeException {
        super(nativeObject);
    }

    public int getPdf417CompactionMode() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).a().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417CompactionMode(int value) throws MwBarcodeException {
        try {
            for (Pdf417CompactionMode pdf417CompactionMode : Pdf417CompactionMode.values()) {
                if (pdf417CompactionMode.getValue() != value) continue;
                ((bl)this.getNativeObject()).a(pdf417CompactionMode);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417ErrorLevel() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).c().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417ErrorLevel(int value) throws MwBarcodeException {
        try {
            for (Pdf417ErrorLevel pdf417ErrorLevel : Pdf417ErrorLevel.values()) {
                if (pdf417ErrorLevel.getValue() != value) continue;
                ((bl)this.getNativeObject()).a(pdf417ErrorLevel);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public boolean getPdf417Truncate() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).d();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417Truncate(boolean value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getColumns() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).e();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setColumns(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getRows() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).f();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setRows(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public float getAspectRatio() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).g();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setAspectRatio(float value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroFileID() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).h();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileID(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).c(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroSegmentID() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).i();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentID(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).d(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroSegmentsCount() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).j();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentsCount(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).e(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroFileName() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).k();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileName(String value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroTimeStamp() throws MwBarcodeException {
        try {
            long l2 = ((bl)this.getNativeObject()).l().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() / 1000L;
            return String.valueOf(l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroTimeStamp(String value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).a(LocalDateTime.ofInstant(Instant.ofEpochMilli((long)Double.parseDouble(value) * 1000L), ZoneId.of("UTC")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroSender() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).m();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSender(String value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroAddressee() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).n();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroAddressee(String value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).c(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroFileSize() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).o();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileSize(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).f(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417MacroChecksum() throws MwBarcodeException {
        try {
            return ((bl)this.getNativeObject()).p();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroChecksum(int value) throws MwBarcodeException {
        try {
            ((bl)this.getNativeObject()).g(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getPdf417EncodeMode() {
        return ((bl)this.getNativeObject()).b().b();
    }

    public void setPdf417EncodeMode(int pdf417EncodeMode) {
        ((bl)this.getNativeObject()).a(bk.a(pdf417EncodeMode));
    }

    public int getPdf417ECIEncoding() {
        return ((bl)this.getNativeObject()).q();
    }

    public void setPdf417ECIEncoding(int value) {
        ((bl)this.getNativeObject()).h(value);
    }

    public int getPdf417MacroECIEncoding() {
        return ((bl)this.getNativeObject()).r();
    }

    public void setPdf417MacroECIEncoding(int value) {
        ((bl)this.getNativeObject()).i(value);
    }

    public int getPdf417MacroTerminator() {
        return ((bl)this.getNativeObject()).s().getValue();
    }

    public void setPdf417MacroTerminator(int value) {
        ((bl)this.getNativeObject()).a(Pdf417MacroTerminator.values()[value]);
    }

    public boolean isReaderInitialization() {
        return ((bl)this.getNativeObject()).t();
    }

    public void setReaderInitialization(boolean value) {
        ((bl)this.getNativeObject()).b(value);
    }

    public int getMacroCharacters() {
        return ((bl)this.getNativeObject()).u().getValue();
    }

    public void setMacroCharacters(int value) {
        MacroCharacter macroCharacter = null;
        for (MacroCharacter macroCharacter2 : MacroCharacter.values()) {
            if (macroCharacter2.getValue() != value) continue;
            macroCharacter = macroCharacter2;
            break;
        }
        if (macroCharacter == null) {
            throw new IllegalArgumentException();
        }
        ((bl)this.getNativeObject()).a(macroCharacter);
    }

    public boolean isLinked() {
        return ((bl)this.getNativeObject()).v();
    }

    public void setLinked(boolean value) {
        ((bl)this.getNativeObject()).c(value);
    }

    public boolean isCode128Emulation() {
        return ((bl)this.getNativeObject()).w();
    }

    public void setCode128Emulation(boolean value) {
        ((bl)this.getNativeObject()).d(value);
    }

    public String toString() {
        return ((bl)this.getNativeObject()).toString();
    }

    @Override
    protected void init() {
    }
}

