/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.BarCodeException;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.barcode.generation.EncodeTypes;
import com.aspose.barcode.generation.d;
import com.aspose.barcode.generation.g;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import com.aspose.mw.barcode.util.MwAssist;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwBarcodeGenerator
extends MwJavaWrapper<d> {
    private MwBaseGenerationParameters a;

    private MwBarcodeGenerator(d barcodeGenerator) throws MwBarcodeException {
        super(barcodeGenerator);
    }

    public MwBarcodeGenerator(int encodeType, String codeText) throws MwBarcodeException {
        super(new d(MwBarcodeGenerator.findEncodeTypeByIndex(encodeType)));
        if (codeText != null) {
            ((d)this.getNativeObject()).a(codeText);
        }
    }

    public MwBarcodeGenerator(int encodeType) throws MwBarcodeException {
        this(encodeType, null);
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwBaseGenerationParameters(((d)this.nativeObject).a());
    }

    public MwBaseGenerationParameters getParameters() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public byte[] generateBarCodeImageBytes(int format) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (format < 0 || format > 8) {
                format = BarCodeImageFormat.PNG.getValue();
            }
            ((d)this.getNativeObject()).a(byteArrayOutputStream, BarCodeImageFormat.values()[format]);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public String generateBarCodeBase64Image(int format) throws MwBarcodeException {
        return Base64.getEncoder().encodeToString(this.generateBarCodeImageBytes(format));
    }

    public String getCodeText() throws MwBarcodeException {
        try {
            String string = ((d)this.getNativeObject()).c();
            return string;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeBytes(String value) throws MwBarcodeException {
        try {
            if (MwBarcodeGenerator.a(value)) {
                byte[] byArray = Base64.getDecoder().decode(value);
                ((d)this.getNativeObject()).a(byArray);
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeText(String codeText, String encoding, String insertBOM) throws MwBarcodeException {
        try {
            if (MwAssist.isBlank(encoding) && !MwAssist.isBlank(insertBOM)) {
                throw new IllegalStateException("Encoding is blank, but insert BOM is not blank");
            }
            if (MwAssist.isBlank(encoding)) {
                ((d)this.getNativeObject()).a(codeText);
            } else if (MwAssist.isBlank(insertBOM)) {
                ((d)this.getNativeObject()).a(codeText, Charset.forName(encoding));
            } else {
                ((d)this.getNativeObject()).a(codeText, Charset.forName(encoding), Boolean.parseBoolean(insertBOM));
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static boolean a(String string) {
        if (string == null || string.length() % 4 != 0 || !string.matches("^[A-Za-z0-9+/=]*$")) {
            return false;
        }
        try {
            Base64.getDecoder().decode(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public short getBarcodeType() throws MwBarcodeException {
        try {
            return ((d)this.getNativeObject()).b().a();
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setBarcodeType(int barcodeType) throws MwBarcodeException {
        try {
            g g2 = MwBarcodeGenerator.findEncodeTypeByIndex(barcodeType);
            ((d)this.getNativeObject()).a(g2);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static String a(RenderedImage renderedImage, String string) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (string == null) {
                string = "PNG";
            }
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public static g findEncodeTypeByIndex(int typeIndexString) throws MwBarcodeException {
        try {
            short s2 = (short)typeIndexString;
            for (g g2 : EncodeTypes.getAllEncodeTypes()) {
                if (g2.a() != s2) continue;
                return g2;
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for short type, but got '" + typeIndexString);
        }
        return EncodeTypes.NONE;
    }

    public String exportToXml() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((d)this.getNativeObject()).a(byteArrayOutputStream)) {
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        throw new BarCodeException("Cannot export to XML");
    }

    public static MwBarcodeGenerator importFromXml(String base64Xml) throws MwBarcodeException {
        return new MwBarcodeGenerator(d.a(new ByteArrayInputStream(new String(Base64.getDecoder().decode(base64Xml), StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8))));
    }

    public String toString() {
        return "MwBarcodeGenerator{parameters=" + this.a + '}';
    }
}

