/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.complexbarcode;

import com.aspose.barcode.complexbarcode.c;
import com.aspose.barcode.complexbarcode.p;
import com.aspose.barcode.generation.BarCodeImageFormat;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.complexbarcode.IMwComplexCodetext;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;

public class MwComplexBarcodeGenerator
extends MwJavaWrapper<c> {
    private MwBaseGenerationParameters a;

    public MwBaseGenerationParameters getParameters() {
        return this.a;
    }

    public MwComplexBarcodeGenerator(IMwComplexCodetext<?> complexCodetext) throws MwBarcodeException {
        super(new c((p)complexCodetext.getNativeObject()));
    }

    public String generateBarCodeImage(int format) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (format < 0 || format > 3) {
                format = BarCodeImageFormat.PNG.getValue();
            }
            ((c)this.getNativeObject()).a(byteArrayOutputStream, BarCodeImageFormat.values()[format]);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public void save(String filename, String formatString) throws Exception {
        BarCodeImageFormat barCodeImageFormat = BarCodeImageFormat.PNG;
        try {
            int n2 = Integer.parseInt(formatString);
            for (BarCodeImageFormat barCodeImageFormat2 : BarCodeImageFormat.values()) {
                if (barCodeImageFormat2.getValue() != n2) continue;
                barCodeImageFormat = barCodeImageFormat2;
                break;
            }
            ((c)this.nativeObject).a(filename, barCodeImageFormat);
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for Integer but got " + formatString, exception.getMessage());
        }
    }

    public void save(String filename) throws IOException, MwBarcodeException {
        try {
            ((c)this.nativeObject).a(filename);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwBaseGenerationParameters(((c)this.getNativeObject()).a());
    }
}

