/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.ab;
import com.aspose.barcode.barcoderecognition.ah;
import com.aspose.barcode.barcoderecognition.ak;
import com.aspose.barcode.barcoderecognition.f;
import com.aspose.barcode.barcoderecognition.k;
import com.aspose.barcode.barcoderecognition.p;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.recognition.MwBarCodeResult;
import com.aspose.mw.barcode.recognition.MwBarcodeSettings;
import com.aspose.mw.barcode.recognition.MwDecodeTypeUtils;
import com.aspose.mw.barcode.recognition.MwQualitySettings;
import com.aspose.mw.barcode.recognition.MwRecognitionAbortedException;
import com.aspose.python.barcode.internal.ew.b;
import com.aspose.python.barcode.internal.fd.ag;
import com.aspose.python.barcode.internal.fd.w;
import com.aspose.python.barcode.internal.fd.y;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;

public class MwBarCodeReader
extends MwJavaWrapper<f> {
    private MwQualitySettings a;
    private MwBarcodeSettings b;

    public MwBarCodeReader() throws MwBarcodeException {
        this(new f());
    }

    public MwBarCodeReader(String image, String[] rectangles, Integer[] decodeTypes) throws Exception {
        this(image, rectangles, Arrays.stream(decodeTypes).mapToInt(Integer::intValue).toArray());
    }

    public MwBarCodeReader(String image, String[] rectangles, int[] decodeTypes) throws Exception {
        this(new f());
        try {
            if (image != null && rectangles != null && rectangles.length > 0) {
                this.a(image, rectangles, decodeTypes);
            } else if (image != null && decodeTypes != null && decodeTypes.length > 0) {
                this.a(image, decodeTypes);
            } else if (image != null) {
                this.a(image);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private MwBarCodeReader(f reader) throws MwBarcodeException {
        super(reader);
    }

    void a(String string) throws IOException {
        b b2 = MwBarCodeReader.c(string);
        k.a(this, b2);
    }

    void a(String string, int[] nArray) throws Exception {
        this.a(string);
        p[] pArray = MwDecodeTypeUtils.convertToDecodeType(nArray);
        ((f)this.nativeObject).a(new ab(pArray));
    }

    void a(String string, String[] stringArray, int[] nArray) throws Exception {
        p[] pArray = MwDecodeTypeUtils.convertToDecodeType(nArray);
        ((f)this.nativeObject).a(new ab(pArray));
        b b2 = MwBarCodeReader.c(string);
        k.a(this, b2, MwBarCodeReader.a(stringArray));
    }

    static Rectangle[] a(String[] stringArray) {
        Rectangle[] rectangleArray = new Rectangle[stringArray.length];
        for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
            rectangleArray[i2] = new Rectangle(Integer.parseInt(stringArray[i2].split(",")[0]), Integer.parseInt(stringArray[i2].split(",")[1]), Integer.parseInt(stringArray[i2].split(",")[2]), Integer.parseInt(stringArray[i2].split(",")[3]));
        }
        return rectangleArray;
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwQualitySettings(((f)this.getNativeObject()).g());
        this.b = new MwBarcodeSettings(((f)this.getNativeObject()).h());
    }

    public int getTimeout() throws MwBarcodeException {
        try {
            return ((f)this.getNativeObject()).b();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setTimeout(int value) throws MwBarcodeException {
        try {
            ((f)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void abort() throws MwBarcodeException {
        try {
            ((f)this.getNativeObject()).c();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final MwQualitySettings getQualitySettings() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setQualitySettings(MwQualitySettings value) throws MwBarcodeException {
        try {
            ((f)this.getNativeObject()).a((ah)value.getNativeObject());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public MwBarcodeSettings getBarcodeSettings() {
        return this.b;
    }

    public final void setBarCodeImage(String base64Image, String[] areas) throws MwBarcodeException {
        try {
            b b2 = MwBarCodeReader.c(base64Image);
            if (areas != null && areas.length > 0) {
                Rectangle[] rectangleArray = new Rectangle[areas.length];
                for (int i2 = 0; i2 < rectangleArray.length; ++i2) {
                    rectangleArray[i2] = MwBarCodeReader.b(areas[i2]);
                }
                k.a(this, b2, rectangleArray);
                return;
            }
            k.a(this, b2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static Rectangle b(String string) {
        String[] stringArray = string.split(",");
        return new Rectangle(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
    }

    private static b c(String string) throws IOException {
        ag ag2 = new File(string).exists() ? new w(string, 3) : new y(Base64.getDecoder().decode(string));
        return new b(ag2);
    }

    public void setBarCodeReadType(int[] types) throws Exception {
        try {
            ((f)this.getNativeObject()).a(new ab(MwDecodeTypeUtils.convertToDecodeType(types)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setBarCodeReadType(Integer[] types) throws Exception {
        try {
            this.setBarCodeReadType(Arrays.stream(types).mapToInt(Integer::intValue).toArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public List<Integer> getBarCodeDecodeType() {
        return MwDecodeTypeUtils.convertFromDecodeType(((f)this.getNativeObject()).j());
    }

    public boolean containsAny(int[] decodeTypes) throws Exception {
        p[] pArray = MwDecodeTypeUtils.convertToDecodeType(decodeTypes);
        return ((f)this.getNativeObject()).j().a(pArray);
    }

    public boolean containsAny(Integer[] decodeTypes) throws Exception {
        return this.containsAny(Arrays.stream(decodeTypes).mapToInt(Integer::intValue).toArray());
    }

    public MwBarCodeResult[] getFoundBarCodes() throws MwBarcodeException {
        MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((f)this.getNativeObject()).d().length];
        for (int i2 = 0; i2 < mwBarCodeResultArray.length; ++i2) {
            mwBarCodeResultArray[i2] = new MwBarCodeResult(((f)this.getNativeObject()).d()[i2]);
        }
        return mwBarCodeResultArray;
    }

    public int getFoundCount() {
        return ((f)this.getNativeObject()).e();
    }

    public MwBarCodeResult[] readBarCodes() throws MwBarcodeException {
        try {
            MwBarCodeResult[] mwBarCodeResultArray = new MwBarCodeResult[((f)this.getNativeObject()).f().length];
            for (int i2 = 0; i2 < ((f)this.getNativeObject()).d().length; ++i2) {
                mwBarCodeResultArray[i2] = new MwBarCodeResult(((f)this.getNativeObject()).d()[i2]);
            }
            return mwBarCodeResultArray;
        }
        catch (ak ak2) {
            System.out.println(ak2.getMessage());
            throw new MwRecognitionAbortedException(ak2);
        }
    }

    public String exportToXml() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (((f)this.getNativeObject()).a(byteArrayOutputStream)) {
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))).lines().collect(Collectors.joining("\n"));
        }
        throw new Exception();
    }

    public static MwBarCodeReader importFromXml(String xmlData) throws Exception {
        return new MwBarCodeReader(f.b(new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8))));
    }
}

