/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.generation.MacroCharacter;
import com.aspose.barcode.generation.Pdf417CompactionMode;
import com.aspose.barcode.generation.Pdf417EncodeMode;
import com.aspose.barcode.generation.Pdf417ErrorLevel;
import com.aspose.barcode.generation.Pdf417MacroTerminator;
import com.aspose.barcode.generation.bc;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class MwPdf417Parameters
extends MwJavaWrapper<bc> {
    public MwPdf417Parameters(bc nativeObject) throws MwBarcodeException {
        super(nativeObject);
    }

    public int getPdf417CompactionMode() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).a().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417CompactionMode(int value) throws MwBarcodeException {
        try {
            for (Pdf417CompactionMode pdf417CompactionMode : Pdf417CompactionMode.values()) {
                if (pdf417CompactionMode.getValue() != value) continue;
                ((bc)this.getNativeObject()).a(pdf417CompactionMode);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getErrorLevel() {
        return ((bc)this.getNativeObject()).d().getValue();
    }

    public final void setErrorLevel(int value) {
        ((bc)this.getNativeObject()).a(Pdf417ErrorLevel.values()[value]);
    }

    public int getPdf417ErrorLevel() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).e().getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417ErrorLevel(int value) throws MwBarcodeException {
        try {
            for (Pdf417ErrorLevel pdf417ErrorLevel : Pdf417ErrorLevel.values()) {
                if (pdf417ErrorLevel.getValue() != value) continue;
                ((bc)this.getNativeObject()).b(pdf417ErrorLevel);
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final boolean getTruncate() {
        return ((bc)this.getNativeObject()).f();
    }

    public final void setTruncate(boolean value) {
        ((bc)this.getNativeObject()).a(value);
    }

    public boolean getPdf417Truncate() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).g();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417Truncate(boolean value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getColumns() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).h();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setColumns(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public int getRows() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).i();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setRows(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public float getAspectRatio() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).j();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setAspectRatio(float value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).a(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getMacroPdf417FileID() {
        return ((bc)this.getNativeObject()).k();
    }

    public final void setMacroPdf417FileID(int value) {
        ((bc)this.getNativeObject()).c(value);
    }

    public int getPdf417MacroFileID() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).l();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileID(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).d(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getMacroPdf417SegmentID() {
        return ((bc)this.getNativeObject()).m();
    }

    public final void setMacroPdf417SegmentID(int value) {
        ((bc)this.getNativeObject()).e(value);
    }

    public int getPdf417MacroSegmentID() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).n();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentID(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).f(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getMacroPdf417SegmentsCount() {
        return ((bc)this.getNativeObject()).o();
    }

    public final void setMacroPdf417SegmentsCount(int value) {
        ((bc)this.getNativeObject()).g(value);
    }

    public int getPdf417MacroSegmentsCount() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).p();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSegmentsCount(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).h(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final String getMacroPdf417FileName() {
        return ((bc)this.getNativeObject()).q();
    }

    public final void setMacroPdf417FileName(String value) {
        ((bc)this.getNativeObject()).a(value);
    }

    public String getPdf417MacroFileName() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).r();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileName(String value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).b(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final String getMacroPdf417TimeStamp() throws MwBarcodeException {
        try {
            long l2 = ((bc)this.getNativeObject()).s().atZone(ZoneId.of("UTC")).toInstant().toEpochMilli() / 1000L;
            return String.valueOf(l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final void setMacroPdf417TimeStamp(String value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).a(LocalDateTime.ofInstant(Instant.ofEpochMilli((long)Double.parseDouble(value) * 1000L), ZoneId.of("UTC")));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String getPdf417MacroTimeStamp() throws MwBarcodeException {
        return this.getMacroPdf417TimeStamp();
    }

    public void setPdf417MacroTimeStamp(String value) throws MwBarcodeException {
        this.setMacroPdf417TimeStamp(value);
    }

    public final String getMacroPdf417Sender() {
        return ((bc)this.getNativeObject()).u();
    }

    public final void setMacroPdf417Sender(String value) {
        ((bc)this.getNativeObject()).c(value);
    }

    public String getPdf417MacroSender() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).v();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroSender(String value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).d(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final String getMacroPdf417Addressee() {
        return ((bc)this.getNativeObject()).w();
    }

    public final void setMacroPdf417Addressee(String value) {
        ((bc)this.getNativeObject()).e(value);
    }

    public String getPdf417MacroAddressee() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).x();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroAddressee(String value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).f(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getMacroPdf417FileSize() {
        return ((bc)this.getNativeObject()).y();
    }

    public final void setMacroPdf417FileSize(int value) {
        ((bc)this.getNativeObject()).i(value);
    }

    public int getPdf417MacroFileSize() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).z();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroFileSize(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).j(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getMacroPdf417Checksum() {
        return ((bc)this.getNativeObject()).A();
    }

    public final void setMacroPdf417Checksum(int value) {
        ((bc)this.getNativeObject()).k(value);
    }

    public int getPdf417MacroChecksum() throws MwBarcodeException {
        try {
            return ((bc)this.getNativeObject()).B();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setPdf417MacroChecksum(int value) throws MwBarcodeException {
        try {
            ((bc)this.getNativeObject()).l(value);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public final int getEncodeMode() {
        return ((bc)this.getNativeObject()).b().getValue();
    }

    public final void setEncodeMode(int value) {
        ((bc)this.getNativeObject()).a(Pdf417EncodeMode.values()[value]);
    }

    public int getPdf417EncodeMode() {
        return ((bc)this.getNativeObject()).c().getValue();
    }

    public void setPdf417EncodeMode(int pdf417EncodeMode) {
        ((bc)this.getNativeObject()).b(Pdf417EncodeMode.fromValue(pdf417EncodeMode));
    }

    public final int getECIEncoding() {
        return ((bc)this.getNativeObject()).C();
    }

    public final void setECIEncoding(int value) {
        ((bc)this.getNativeObject()).m(value);
    }

    public int getPdf417ECIEncoding() {
        return ((bc)this.getNativeObject()).D();
    }

    public void setPdf417ECIEncoding(int value) {
        ((bc)this.getNativeObject()).n(value);
    }

    public final int getMacroPdf417ECIEncoding() {
        return ((bc)this.getNativeObject()).E();
    }

    public final void setMacroPdf417ECIEncoding(int value) {
        ((bc)this.getNativeObject()).o(value);
    }

    public int getPdf417MacroECIEncoding() {
        return ((bc)this.getNativeObject()).F();
    }

    public void setPdf417MacroECIEncoding(int value) {
        ((bc)this.getNativeObject()).p(value);
    }

    public final int getMacroPdf417Terminator() {
        return ((bc)this.getNativeObject()).G().getValue();
    }

    public final void setMacroPdf417Terminator(int value) {
        ((bc)this.getNativeObject()).a(Pdf417MacroTerminator.values()[value]);
    }

    public int getPdf417MacroTerminator() {
        return ((bc)this.getNativeObject()).H().getValue();
    }

    public void setPdf417MacroTerminator(int value) {
        ((bc)this.getNativeObject()).b(Pdf417MacroTerminator.values()[value]);
    }

    public boolean isReaderInitialization() {
        return ((bc)this.getNativeObject()).I();
    }

    public void setReaderInitialization(boolean value) {
        ((bc)this.getNativeObject()).c(value);
    }

    public int getMacroCharacters() {
        return ((bc)this.getNativeObject()).J().getValue();
    }

    public void setMacroCharacters(int value) {
        MacroCharacter macroCharacter = null;
        for (MacroCharacter macroCharacter2 : MacroCharacter.values()) {
            if (macroCharacter2.getValue() != value) continue;
            macroCharacter = macroCharacter2;
            break;
        }
        if (macroCharacter == null) {
            throw new IllegalArgumentException();
        }
        ((bc)this.getNativeObject()).a(macroCharacter);
    }

    public boolean isLinked() {
        return ((bc)this.getNativeObject()).K();
    }

    public void setLinked(boolean value) {
        ((bc)this.getNativeObject()).d(value);
    }

    public boolean isCode128Emulation() {
        return ((bc)this.getNativeObject()).L();
    }

    public void setCode128Emulation(boolean value) {
        ((bc)this.getNativeObject()).e(value);
    }

    public String toString() {
        return ((bc)this.getNativeObject()).toString();
    }

    @Override
    protected void init() {
    }
}

