/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.recognition;

import com.aspose.barcode.barcoderecognition.BaseDecodeType;
import com.aspose.barcode.barcoderecognition.DecodeType;
import com.aspose.barcode.barcoderecognition.MultiDecodeType;
import com.aspose.barcode.barcoderecognition.SingleDecodeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MwDecodeTypeUtils {
    public static List<Integer> convertFromDecodeType(BaseDecodeType decodeType) {
        if (decodeType instanceof SingleDecodeType) {
            return Collections.singletonList(Integer.valueOf(((SingleDecodeType)decodeType).getTypeIndex()));
        }
        if (decodeType.equals(DecodeType.ALL_SUPPORTED_TYPES)) {
            return Collections.singletonList(99);
        }
        if (decodeType.equals(DecodeType.TYPES_2D)) {
            return Collections.singletonList(98);
        }
        if (decodeType.equals(DecodeType.TYPES_1D)) {
            return Collections.singletonList(97);
        }
        if (decodeType.equals(DecodeType.MOST_COMMON_TYPES)) {
            return Collections.singletonList(96);
        }
        if (decodeType.equals(DecodeType.POSTAL_TYPES)) {
            return Collections.singletonList(95);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ((MultiDecodeType)decodeType).getSingleTypes().forEach(singleDecodeType -> arrayList.add(Integer.valueOf(singleDecodeType.getTypeIndex())));
        return arrayList;
    }

    public static BaseDecodeType[] convertToDecodeType(int[] stringDecodeTypes) throws Exception {
        try {
            BaseDecodeType[] baseDecodeTypeArray = new BaseDecodeType[stringDecodeTypes.length];
            block2: for (int i2 = 0; i2 < stringDecodeTypes.length; ++i2) {
                for (int i3 = 0; i3 < DecodeType.getAllSupportedTypesArray().length; ++i3) {
                    if (stringDecodeTypes[i2] == DecodeType.getAllSupportedTypesArray()[i3].getTypeIndex()) {
                        baseDecodeTypeArray[i2] = DecodeType.getAllSupportedTypesArray()[i3];
                        continue block2;
                    }
                    if (stringDecodeTypes[i2] == 97) {
                        baseDecodeTypeArray[i2] = DecodeType.TYPES_1D;
                        continue block2;
                    }
                    if (stringDecodeTypes[i2] == 98) {
                        baseDecodeTypeArray[i2] = DecodeType.TYPES_2D;
                        continue block2;
                    }
                    if (stringDecodeTypes[i2] == 95) {
                        baseDecodeTypeArray[i2] = DecodeType.POSTAL_TYPES;
                        continue block2;
                    }
                    if (stringDecodeTypes[i2] == 96) {
                        baseDecodeTypeArray[i2] = DecodeType.MOST_COMMON_TYPES;
                        continue block2;
                    }
                    if (stringDecodeTypes[i2] != 99) continue;
                    baseDecodeTypeArray[i2] = DecodeType.ALL_SUPPORTED_TYPES;
                    continue block2;
                }
            }
            return baseDecodeTypeArray;
        }
        catch (NumberFormatException numberFormatException) {
            String string = "Waiting for Short types array, but got \n";
            for (int i4 = 0; i4 < stringDecodeTypes.length; ++i4) {
                string = string + "i = " + i4 + " - " + stringDecodeTypes[i4] + "\n";
            }
            throw new Exception(string);
        }
    }

    private static BaseDecodeType a(short s2) {
        for (int i2 = 0; i2 < DecodeType.getAllSupportedTypesArray().length; ++i2) {
            if (s2 != DecodeType.getAllSupportedTypesArray()[i2].getTypeIndex()) continue;
            return DecodeType.getAllSupportedTypesArray()[i2];
        }
        return DecodeType.ALL_SUPPORTED_TYPES;
    }

    private static BaseDecodeType[] a(short[] sArray) {
        BaseDecodeType[] baseDecodeTypeArray = new BaseDecodeType[sArray.length];
        for (int i2 = 0; i2 < baseDecodeTypeArray.length; ++i2) {
            baseDecodeTypeArray[i2] = MwDecodeTypeUtils.a(sArray[i2]);
        }
        return baseDecodeTypeArray;
    }

    public static boolean is1D(int symbology) {
        return DecodeType.is1D(MwDecodeTypeUtils.a((short)symbology));
    }

    public static boolean isPostal(int symbology) {
        return DecodeType.isPostal(MwDecodeTypeUtils.a((short)symbology));
    }

    public static boolean is2D(int symbology) {
        return DecodeType.is2D(MwDecodeTypeUtils.a((short)symbology));
    }

    public static boolean containsAny(int decodeType, short[] decodeTypes) {
        return MwDecodeTypeUtils.a((short)decodeType).containsAny(MwDecodeTypeUtils.a(decodeTypes));
    }
}

