# astar_python

using:

    - from astar_python.astar import Astar

build your weight map:

```python
mat = [
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
]
```
Init the Astar object
```python
astar = Astar(mat)
```

Run astar with a start point and a end point like [x, y] (left to right = x, top to bottom = y 
```python
result = astar.run([0, 0], [10, 9])
```
result is an array of point:
```python
print(result)
--
[[0, 0], [1, 1], [2, 2], [3, 3], [4, 4], [5, 5], [6, 6], [7, 7], [8, 8], [9, 9], [10, 9]]

```
If no way to the end, A* return None

give:

```python
[1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0]
[0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0]
[0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1]
```

# Weights
A weight on the matrix is the cost to cross the point.

Cost can be:

* positive: more it is positive, more it's difficult to cross the region
* negative: is like a booster, you can custom your way
* 0: a normal point
* None: not crossable

Exemple: The number '1' is the way taken, others are weights



```python
# A simple barrage
[1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 0, 1, 0, 0, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1]


# It decided to cross barrage
[1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 0, 1, 0, 0, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 1, 0, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 5, 1, 0, 0, 0, 0]
[0, 0, 0, 0, 0, None, 0, 1, 1, 1, 1]

astar_python
[1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
[0, 1, 0, -5, -5, -5, 0, 0, 0, 0, 0]
[0, 0, 1, 0, 0, 5, 1, 0, 0, 0, 0]
[0, 0, 0, 0, 0, 5, 0, 1, 0, 0, 0]
[0, 0, 0, 0, 0, 5, 0, 0, 1, 0, 0]
[0, 0, 0, 0, 0, 5, 0, 0, 0, 1, 0]
[0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 1]
[0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 1]
[0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 1]
[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1]

```



