# coding: utf-8

"""
FixThisApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..client import Client


class Entities(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, client=None):
        config = Configuration()
        if client:
            self.client = client
        else:
            if not config.client:
                config.client = Client()
            self.client = config.client

    def create(self, **kwargs):
        """
        Create anonymous visitor
        Create anonymous visitor

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: AnonymousResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/anonymous'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='AnonymousResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def get(self, anonymous, **kwargs):
        """
        Returns an anonymous visitor, containing any assigned customer ID.
        Returns an anonymous visitor, containing any assigned customer ID.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get(anonymous, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str anonymous: anonymous (required)
        :return: Customer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'anonymous' is set
        if anonymous is None:
            raise ValueError(
                "Missing the required parameter `anonymous` when calling `get`")

        all_params = ['anonymous']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/anonymous/{anonymous}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'anonymous' in params:
            path_params['anonymous'] = params['anonymous']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='Customer',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def update(self, anonymous, request, **kwargs):
        """
        Binds one actor to another.
        Binds one actor to another, allowing activities of those actors to be shared between the two.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update(anonymous, request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str anonymous: anonymous (required)
        :param Customer request: request (required)
        :return: BlacklistUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'anonymous' is set
        if anonymous is None:
            raise ValueError(
                "Missing the required parameter `anonymous` when calling `update`")
        # verify the required parameter 'request' is set
        if request is None:
            raise ValueError(
                "Missing the required parameter `request` when calling `update`")

        all_params = ['anonymous', 'request']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/anonymous/{anonymous}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'anonymous' in params:
            path_params['anonymous'] = params['anonymous']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(
            resource_path,
            method,
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=files,
            response_type='BlacklistUpdateResponse',
            auth_settings=auth_settings,
            callback=params.get('callback'),
            oauth_token=params.get('oauth_token'))
        return response

    def get_rankings(self, params, **kwargs):
        """
        Returns a ranking of the specified entities for the current user.
        Returns a ranking of the specified entities for the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_rankings(params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RankingParams params: params (required)
        :return: RankedEntities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'params' is set
        if params is None:
            raise ValueError(
                "Missing the required parameter `params` when calling `get_rankings`")

        all_params = ['params']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rankings" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/ranking'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='RankedEntities',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def batch_get_rankings(self, batch_request, **kwargs):
        """
        Returns multiple rankings of the specified entities for the current user.
        Returns multiple rankings of the specified entities for the current user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.batch_get_rankings(batch_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BatchRankingRequest batch_request: batchRequest (required)
        :return: BatchRankingResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'batch_request' is set
        if batch_request is None:
            raise ValueError(
                "Missing the required parameter `batch_request` when calling `batch_get_rankings`")

        all_params = ['batch_request']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method batch_get_rankings" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/ranking/many'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'batch_request' in params:
            body_params = params['batch_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='BatchRankingResult',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def blacklist_get_all(self, **kwargs):
        """
        List all blacklist entries for your account.
        List all blacklist entries for your account.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.blacklist_get_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: BlacklistGetResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blacklist_get_all" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/rankings/blacklists'.replace(
            '{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='BlacklistGetResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def blacklist_save(self, **kwargs):
        """
        Save a new blacklist entry.
        Save a new blacklist entry.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.blacklist_save(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BlacklistParams params: params
        :return: BlacklistSaveResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['params']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blacklist_save" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/rankings/blacklists'.replace(
            '{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='BlacklistSaveResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def blacklist_get(self, id, **kwargs):
        """
        Returns the blacklist with the specified ID.
        Returns the blacklist with the specified ID.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.blacklist_get(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: id (required)
        :return: Blacklist
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` when calling `blacklist_get`")

        all_params = ['id']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blacklist_get" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/rankings/blacklists/{id}'.replace(
            '{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(resource_path, method,
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=files,
                                        response_type='Blacklist',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        oauth_token=params.get('oauth_token'))
        return response

    def blacklist_update(self, id, **kwargs):
        """
        Updates a blacklist with the specified ID.
        Updates a blacklist with the specified ID.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.blacklist_update(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: id (required)
        :param BlacklistParams params: params
        :return: BlacklistUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` when calling `blacklist_update`")

        all_params = ['id', 'params']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blacklist_update" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/rankings/blacklists/{id}'.replace(
            '{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'params' in params:
            body_params = params['params']

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(
            resource_path,
            method,
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=files,
            response_type='BlacklistUpdateResponse',
            auth_settings=auth_settings,
            callback=params.get('callback'),
            oauth_token=params.get('oauth_token'))
        return response

    def blacklist_delete(self, id, **kwargs):
        """
        Delete blacklist by id.
        Delete blacklist by id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.blacklist_delete(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: id (required)
        :return: BlacklistDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'id' is set
        if id is None:
            raise ValueError(
                "Missing the required parameter `id` when calling `blacklist_delete`")

        all_params = ['id']
        all_params.append('callback')
        all_params.append('oauth_token')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method blacklist_delete" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/entities/rankings/blacklists/{id}'.replace(
            '{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.client.call_api(
            resource_path,
            method,
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=files,
            response_type='BlacklistDeleteResponse',
            auth_settings=auth_settings,
            callback=params.get('callback'),
            oauth_token=params.get('oauth_token'))
        return response
