# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.action import Action
from ..types.action_secret_request import ActionSecretRequest
from ..types.action_trigger import ActionTrigger
from ..types.action_trigger_type_enum import ActionTriggerTypeEnum
from ..types.action_version_dependency import ActionVersionDependency
from ..types.create_action_response_content import CreateActionResponseContent
from ..types.deploy_action_response_content import DeployActionResponseContent
from ..types.get_action_response_content import GetActionResponseContent
from ..types.list_actions_paginated_response_content import ListActionsPaginatedResponseContent
from ..types.test_action_payload import TestActionPayload
from ..types.test_action_response_content import TestActionResponseContent
from ..types.update_action_response_content import UpdateActionResponseContent
from .raw_client import AsyncRawActionsClient, RawActionsClient

if typing.TYPE_CHECKING:
    from .executions.client import AsyncExecutionsClient, ExecutionsClient
    from .triggers.client import AsyncTriggersClient, TriggersClient
    from .versions.client import AsyncVersionsClient, VersionsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ActionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawActionsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._versions: typing.Optional[VersionsClient] = None
        self._executions: typing.Optional[ExecutionsClient] = None
        self._triggers: typing.Optional[TriggersClient] = None

    @property
    def with_raw_response(self) -> RawActionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawActionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        trigger_id: typing.Optional[ActionTriggerTypeEnum] = None,
        action_name: typing.Optional[str] = None,
        deployed: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        installed: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Action, ListActionsPaginatedResponseContent]:
        """
        Retrieve all actions.

        Parameters
        ----------
        trigger_id : typing.Optional[ActionTriggerTypeEnum]
            An actions extensibility point.

        action_name : typing.Optional[str]
            The name of the action to retrieve.

        deployed : typing.Optional[bool]
            Optional filter to only retrieve actions that are deployed.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned by the server in single response. 20 by default

        installed : typing.Optional[bool]
            Optional. When true, return only installed actions. When false, return only custom actions. Returns all actions by default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Action, ListActionsPaginatedResponseContent]
            The actions were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.actions.list(
            trigger_id="triggerId",
            action_name="actionName",
            deployed=True,
            page=1,
            per_page=1,
            installed=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            trigger_id=trigger_id,
            action_name=action_name,
            deployed=deployed,
            page=page,
            per_page=per_page,
            installed=installed,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str = "my-action",
        supported_triggers: typing.Sequence[ActionTrigger],
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        deploy: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateActionResponseContent:
        """
        Create an action. Once an action is created, it must be deployed, and then bound to a trigger before it will be executed as part of a flow.

        Parameters
        ----------
        name : str
            The name of an action.

        supported_triggers : typing.Sequence[ActionTrigger]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        deploy : typing.Optional[bool]
            True if the action should be deployed after creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateActionResponseContent
            Action successfully created.

        Examples
        --------
        from auth0 import ActionTrigger, Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.create(
            name="name",
            supported_triggers=[
                ActionTrigger(
                    id="id",
                )
            ],
        )
        """
        _response = self._raw_client.create(
            name=name,
            supported_triggers=supported_triggers,
            code=code,
            dependencies=dependencies,
            runtime=runtime,
            secrets=secrets,
            deploy=deploy,
            request_options=request_options,
        )
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetActionResponseContent:
        """
        Retrieve an action by its ID.

        Parameters
        ----------
        id : str
            The ID of the action to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionResponseContent
            The action was retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(
        self, id: str, *, force: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes an action and all of its associated versions. An action must be unbound from all triggers before it can be deleted.

        Parameters
        ----------
        id : str
            The ID of the action to delete.

        force : typing.Optional[bool]
            Force action deletion detaching bindings

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.delete(
            id="id",
            force=True,
        )
        """
        _response = self._raw_client.delete(id, force=force, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-action",
        supported_triggers: typing.Optional[typing.Sequence[ActionTrigger]] = OMIT,
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateActionResponseContent:
        """
        Update an existing action. If this action is currently bound to a trigger, updating it will <strong>not</strong> affect any user flows until the action is deployed.

        Parameters
        ----------
        id : str
            The id of the action to update.

        name : typing.Optional[str]
            The name of an action.

        supported_triggers : typing.Optional[typing.Sequence[ActionTrigger]]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateActionResponseContent
            Action successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            supported_triggers=supported_triggers,
            code=code,
            dependencies=dependencies,
            runtime=runtime,
            secrets=secrets,
            request_options=request_options,
        )
        return _response.data

    def deploy(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeployActionResponseContent:
        """
        Deploy an action. Deploying an action will create a new immutable version of the action. If the action is currently bound to a trigger, then the system will begin executing the newly deployed version of the action immediately. Otherwise, the action will only be executed as a part of a flow once it is bound to that flow.

        Parameters
        ----------
        id : str
            The ID of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployActionResponseContent
            Request to create action version was accepted.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.deploy(
            id="id",
        )
        """
        _response = self._raw_client.deploy(id, request_options=request_options)
        return _response.data

    def test(
        self, id: str, *, payload: TestActionPayload, request_options: typing.Optional[RequestOptions] = None
    ) -> TestActionResponseContent:
        """
        Test an action. After updating an action, it can be tested prior to being deployed to ensure it behaves as expected.

        Parameters
        ----------
        id : str
            The id of the action to test.

        payload : TestActionPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestActionResponseContent
            Test action version successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.test(
            id="id",
            payload={"key": "value"},
        )
        """
        _response = self._raw_client.test(id, payload=payload, request_options=request_options)
        return _response.data

    @property
    def versions(self):
        if self._versions is None:
            from .versions.client import VersionsClient  # noqa: E402

            self._versions = VersionsClient(client_wrapper=self._client_wrapper)
        return self._versions

    @property
    def executions(self):
        if self._executions is None:
            from .executions.client import ExecutionsClient  # noqa: E402

            self._executions = ExecutionsClient(client_wrapper=self._client_wrapper)
        return self._executions

    @property
    def triggers(self):
        if self._triggers is None:
            from .triggers.client import TriggersClient  # noqa: E402

            self._triggers = TriggersClient(client_wrapper=self._client_wrapper)
        return self._triggers


class AsyncActionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawActionsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._versions: typing.Optional[AsyncVersionsClient] = None
        self._executions: typing.Optional[AsyncExecutionsClient] = None
        self._triggers: typing.Optional[AsyncTriggersClient] = None

    @property
    def with_raw_response(self) -> AsyncRawActionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawActionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        trigger_id: typing.Optional[ActionTriggerTypeEnum] = None,
        action_name: typing.Optional[str] = None,
        deployed: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        installed: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Action, ListActionsPaginatedResponseContent]:
        """
        Retrieve all actions.

        Parameters
        ----------
        trigger_id : typing.Optional[ActionTriggerTypeEnum]
            An actions extensibility point.

        action_name : typing.Optional[str]
            The name of the action to retrieve.

        deployed : typing.Optional[bool]
            Optional filter to only retrieve actions that are deployed.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned by the server in single response. 20 by default

        installed : typing.Optional[bool]
            Optional. When true, return only installed actions. When false, return only custom actions. Returns all actions by default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Action, ListActionsPaginatedResponseContent]
            The actions were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.actions.list(
                trigger_id="triggerId",
                action_name="actionName",
                deployed=True,
                page=1,
                per_page=1,
                installed=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            trigger_id=trigger_id,
            action_name=action_name,
            deployed=deployed,
            page=page,
            per_page=per_page,
            installed=installed,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str = "my-action",
        supported_triggers: typing.Sequence[ActionTrigger],
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        deploy: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateActionResponseContent:
        """
        Create an action. Once an action is created, it must be deployed, and then bound to a trigger before it will be executed as part of a flow.

        Parameters
        ----------
        name : str
            The name of an action.

        supported_triggers : typing.Sequence[ActionTrigger]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        deploy : typing.Optional[bool]
            True if the action should be deployed after creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateActionResponseContent
            Action successfully created.

        Examples
        --------
        import asyncio

        from auth0 import ActionTrigger, AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.create(
                name="name",
                supported_triggers=[
                    ActionTrigger(
                        id="id",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            supported_triggers=supported_triggers,
            code=code,
            dependencies=dependencies,
            runtime=runtime,
            secrets=secrets,
            deploy=deploy,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActionResponseContent:
        """
        Retrieve an action by its ID.

        Parameters
        ----------
        id : str
            The ID of the action to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionResponseContent
            The action was retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(
        self, id: str, *, force: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes an action and all of its associated versions. An action must be unbound from all triggers before it can be deleted.

        Parameters
        ----------
        id : str
            The ID of the action to delete.

        force : typing.Optional[bool]
            Force action deletion detaching bindings

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.delete(
                id="id",
                force=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, force=force, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-action",
        supported_triggers: typing.Optional[typing.Sequence[ActionTrigger]] = OMIT,
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateActionResponseContent:
        """
        Update an existing action. If this action is currently bound to a trigger, updating it will <strong>not</strong> affect any user flows until the action is deployed.

        Parameters
        ----------
        id : str
            The id of the action to update.

        name : typing.Optional[str]
            The name of an action.

        supported_triggers : typing.Optional[typing.Sequence[ActionTrigger]]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateActionResponseContent
            Action successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            supported_triggers=supported_triggers,
            code=code,
            dependencies=dependencies,
            runtime=runtime,
            secrets=secrets,
            request_options=request_options,
        )
        return _response.data

    async def deploy(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeployActionResponseContent:
        """
        Deploy an action. Deploying an action will create a new immutable version of the action. If the action is currently bound to a trigger, then the system will begin executing the newly deployed version of the action immediately. Otherwise, the action will only be executed as a part of a flow once it is bound to that flow.

        Parameters
        ----------
        id : str
            The ID of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployActionResponseContent
            Request to create action version was accepted.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.deploy(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deploy(id, request_options=request_options)
        return _response.data

    async def test(
        self, id: str, *, payload: TestActionPayload, request_options: typing.Optional[RequestOptions] = None
    ) -> TestActionResponseContent:
        """
        Test an action. After updating an action, it can be tested prior to being deployed to ensure it behaves as expected.

        Parameters
        ----------
        id : str
            The id of the action to test.

        payload : TestActionPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TestActionResponseContent
            Test action version successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.test(
                id="id",
                payload={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.test(id, payload=payload, request_options=request_options)
        return _response.data

    @property
    def versions(self):
        if self._versions is None:
            from .versions.client import AsyncVersionsClient  # noqa: E402

            self._versions = AsyncVersionsClient(client_wrapper=self._client_wrapper)
        return self._versions

    @property
    def executions(self):
        if self._executions is None:
            from .executions.client import AsyncExecutionsClient  # noqa: E402

            self._executions = AsyncExecutionsClient(client_wrapper=self._client_wrapper)
        return self._executions

    @property
    def triggers(self):
        if self._triggers is None:
            from .triggers.client import AsyncTriggersClient  # noqa: E402

            self._triggers = AsyncTriggersClient(client_wrapper=self._client_wrapper)
        return self._triggers
