# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_action_execution_response_content import GetActionExecutionResponseContent
from .raw_client import AsyncRawExecutionsClient, RawExecutionsClient


class ExecutionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExecutionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExecutionsClient
        """
        return self._raw_client

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActionExecutionResponseContent:
        """
        Retrieve information about a specific execution of a trigger. Relevant execution IDs will be included in tenant logs generated as part of that authentication flow. Executions will only be stored for 10 days after their creation.

        Parameters
        ----------
        id : str
            The ID of the execution to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionExecutionResponseContent
            The execution was retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.executions.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data


class AsyncExecutionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExecutionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExecutionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExecutionsClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActionExecutionResponseContent:
        """
        Retrieve information about a specific execution of a trigger. Relevant execution IDs will be included in tenant logs generated as part of that authentication flow. Executions will only be stored for 10 days after their creation.

        Parameters
        ----------
        id : str
            The ID of the execution to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionExecutionResponseContent
            The execution was retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.executions.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data
