# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.action import Action
from ..types.action_secret_request import ActionSecretRequest
from ..types.action_trigger import ActionTrigger
from ..types.action_trigger_type_enum import ActionTriggerTypeEnum
from ..types.action_version_dependency import ActionVersionDependency
from ..types.create_action_response_content import CreateActionResponseContent
from ..types.deploy_action_response_content import DeployActionResponseContent
from ..types.get_action_response_content import GetActionResponseContent
from ..types.list_actions_paginated_response_content import ListActionsPaginatedResponseContent
from ..types.test_action_payload import TestActionPayload
from ..types.test_action_response_content import TestActionResponseContent
from ..types.update_action_response_content import UpdateActionResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawActionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        trigger_id: typing.Optional[ActionTriggerTypeEnum] = None,
        action_name: typing.Optional[str] = None,
        deployed: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        installed: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Action, ListActionsPaginatedResponseContent]:
        """
        Retrieve all actions.

        Parameters
        ----------
        trigger_id : typing.Optional[ActionTriggerTypeEnum]
            An actions extensibility point.

        action_name : typing.Optional[str]
            The name of the action to retrieve.

        deployed : typing.Optional[bool]
            Optional filter to only retrieve actions that are deployed.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned by the server in single response. 20 by default

        installed : typing.Optional[bool]
            Optional. When true, return only installed actions. When false, return only custom actions. Returns all actions by default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Action, ListActionsPaginatedResponseContent]
            The actions were retrieved.
        """
        page = page if page is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "actions/actions",
            method="GET",
            params={
                "triggerId": trigger_id,
                "actionName": action_name,
                "deployed": deployed,
                "page": page,
                "per_page": per_page,
                "installed": installed,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListActionsPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListActionsPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.actions
                _has_next = True
                _get_next = lambda: self.list(
                    trigger_id=trigger_id,
                    action_name=action_name,
                    deployed=deployed,
                    page=page + len(_items or []),
                    per_page=per_page,
                    installed=installed,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str = "my-action",
        supported_triggers: typing.Sequence[ActionTrigger],
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        deploy: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateActionResponseContent]:
        """
        Create an action. Once an action is created, it must be deployed, and then bound to a trigger before it will be executed as part of a flow.

        Parameters
        ----------
        name : str
            The name of an action.

        supported_triggers : typing.Sequence[ActionTrigger]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        deploy : typing.Optional[bool]
            True if the action should be deployed after creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateActionResponseContent]
            Action successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "actions/actions",
            method="POST",
            json={
                "name": name,
                "supported_triggers": convert_and_respect_annotation_metadata(
                    object_=supported_triggers, annotation=typing.Sequence[ActionTrigger], direction="write"
                ),
                "code": code,
                "dependencies": convert_and_respect_annotation_metadata(
                    object_=dependencies, annotation=typing.Sequence[ActionVersionDependency], direction="write"
                ),
                "runtime": runtime,
                "secrets": convert_and_respect_annotation_metadata(
                    object_=secrets, annotation=typing.Sequence[ActionSecretRequest], direction="write"
                ),
                "deploy": deploy,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateActionResponseContent,
                    parse_obj_as(
                        type_=CreateActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetActionResponseContent]:
        """
        Retrieve an action by its ID.

        Parameters
        ----------
        id : str
            The ID of the action to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetActionResponseContent]
            The action was retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetActionResponseContent,
                    parse_obj_as(
                        type_=GetActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, id: str, *, force: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Deletes an action and all of its associated versions. An action must be unbound from all triggers before it can be deleted.

        Parameters
        ----------
        id : str
            The ID of the action to delete.

        force : typing.Optional[bool]
            Force action deletion detaching bindings

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="DELETE",
            params={
                "force": force,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-action",
        supported_triggers: typing.Optional[typing.Sequence[ActionTrigger]] = OMIT,
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateActionResponseContent]:
        """
        Update an existing action. If this action is currently bound to a trigger, updating it will <strong>not</strong> affect any user flows until the action is deployed.

        Parameters
        ----------
        id : str
            The id of the action to update.

        name : typing.Optional[str]
            The name of an action.

        supported_triggers : typing.Optional[typing.Sequence[ActionTrigger]]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateActionResponseContent]
            Action successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "supported_triggers": convert_and_respect_annotation_metadata(
                    object_=supported_triggers, annotation=typing.Sequence[ActionTrigger], direction="write"
                ),
                "code": code,
                "dependencies": convert_and_respect_annotation_metadata(
                    object_=dependencies, annotation=typing.Sequence[ActionVersionDependency], direction="write"
                ),
                "runtime": runtime,
                "secrets": convert_and_respect_annotation_metadata(
                    object_=secrets, annotation=typing.Sequence[ActionSecretRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateActionResponseContent,
                    parse_obj_as(
                        type_=UpdateActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def deploy(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeployActionResponseContent]:
        """
        Deploy an action. Deploying an action will create a new immutable version of the action. If the action is currently bound to a trigger, then the system will begin executing the newly deployed version of the action immediately. Otherwise, the action will only be executed as a part of a flow once it is bound to that flow.

        Parameters
        ----------
        id : str
            The ID of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeployActionResponseContent]
            Request to create action version was accepted.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}/deploy",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeployActionResponseContent,
                    parse_obj_as(
                        type_=DeployActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def test(
        self, id: str, *, payload: TestActionPayload, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[TestActionResponseContent]:
        """
        Test an action. After updating an action, it can be tested prior to being deployed to ensure it behaves as expected.

        Parameters
        ----------
        id : str
            The id of the action to test.

        payload : TestActionPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TestActionResponseContent]
            Test action version successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}/test",
            method="POST",
            json={
                "payload": payload,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TestActionResponseContent,
                    parse_obj_as(
                        type_=TestActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawActionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        trigger_id: typing.Optional[ActionTriggerTypeEnum] = None,
        action_name: typing.Optional[str] = None,
        deployed: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        installed: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Action, ListActionsPaginatedResponseContent]:
        """
        Retrieve all actions.

        Parameters
        ----------
        trigger_id : typing.Optional[ActionTriggerTypeEnum]
            An actions extensibility point.

        action_name : typing.Optional[str]
            The name of the action to retrieve.

        deployed : typing.Optional[bool]
            Optional filter to only retrieve actions that are deployed.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned by the server in single response. 20 by default

        installed : typing.Optional[bool]
            Optional. When true, return only installed actions. When false, return only custom actions. Returns all actions by default.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Action, ListActionsPaginatedResponseContent]
            The actions were retrieved.
        """
        page = page if page is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "actions/actions",
            method="GET",
            params={
                "triggerId": trigger_id,
                "actionName": action_name,
                "deployed": deployed,
                "page": page,
                "per_page": per_page,
                "installed": installed,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListActionsPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListActionsPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.actions
                _has_next = True

                async def _get_next():
                    return await self.list(
                        trigger_id=trigger_id,
                        action_name=action_name,
                        deployed=deployed,
                        page=page + len(_items or []),
                        per_page=per_page,
                        installed=installed,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str = "my-action",
        supported_triggers: typing.Sequence[ActionTrigger],
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        deploy: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateActionResponseContent]:
        """
        Create an action. Once an action is created, it must be deployed, and then bound to a trigger before it will be executed as part of a flow.

        Parameters
        ----------
        name : str
            The name of an action.

        supported_triggers : typing.Sequence[ActionTrigger]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        deploy : typing.Optional[bool]
            True if the action should be deployed after creation.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateActionResponseContent]
            Action successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "actions/actions",
            method="POST",
            json={
                "name": name,
                "supported_triggers": convert_and_respect_annotation_metadata(
                    object_=supported_triggers, annotation=typing.Sequence[ActionTrigger], direction="write"
                ),
                "code": code,
                "dependencies": convert_and_respect_annotation_metadata(
                    object_=dependencies, annotation=typing.Sequence[ActionVersionDependency], direction="write"
                ),
                "runtime": runtime,
                "secrets": convert_and_respect_annotation_metadata(
                    object_=secrets, annotation=typing.Sequence[ActionSecretRequest], direction="write"
                ),
                "deploy": deploy,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateActionResponseContent,
                    parse_obj_as(
                        type_=CreateActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetActionResponseContent]:
        """
        Retrieve an action by its ID.

        Parameters
        ----------
        id : str
            The ID of the action to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetActionResponseContent]
            The action was retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetActionResponseContent,
                    parse_obj_as(
                        type_=GetActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, force: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Deletes an action and all of its associated versions. An action must be unbound from all triggers before it can be deleted.

        Parameters
        ----------
        id : str
            The ID of the action to delete.

        force : typing.Optional[bool]
            Force action deletion detaching bindings

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="DELETE",
            params={
                "force": force,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = "my-action",
        supported_triggers: typing.Optional[typing.Sequence[ActionTrigger]] = OMIT,
        code: typing.Optional[str] = "module.exports = () => {}",
        dependencies: typing.Optional[typing.Sequence[ActionVersionDependency]] = OMIT,
        runtime: typing.Optional[str] = "node22",
        secrets: typing.Optional[typing.Sequence[ActionSecretRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateActionResponseContent]:
        """
        Update an existing action. If this action is currently bound to a trigger, updating it will <strong>not</strong> affect any user flows until the action is deployed.

        Parameters
        ----------
        id : str
            The id of the action to update.

        name : typing.Optional[str]
            The name of an action.

        supported_triggers : typing.Optional[typing.Sequence[ActionTrigger]]
            The list of triggers that this action supports. At this time, an action can only target a single trigger at a time.

        code : typing.Optional[str]
            The source code of the action.

        dependencies : typing.Optional[typing.Sequence[ActionVersionDependency]]
            The list of third party npm modules, and their versions, that this action depends on.

        runtime : typing.Optional[str]
            The Node runtime. For example: `node22`, defaults to `node22`

        secrets : typing.Optional[typing.Sequence[ActionSecretRequest]]
            The list of secrets that are included in an action or a version of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateActionResponseContent]
            Action successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "supported_triggers": convert_and_respect_annotation_metadata(
                    object_=supported_triggers, annotation=typing.Sequence[ActionTrigger], direction="write"
                ),
                "code": code,
                "dependencies": convert_and_respect_annotation_metadata(
                    object_=dependencies, annotation=typing.Sequence[ActionVersionDependency], direction="write"
                ),
                "runtime": runtime,
                "secrets": convert_and_respect_annotation_metadata(
                    object_=secrets, annotation=typing.Sequence[ActionSecretRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateActionResponseContent,
                    parse_obj_as(
                        type_=UpdateActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def deploy(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeployActionResponseContent]:
        """
        Deploy an action. Deploying an action will create a new immutable version of the action. If the action is currently bound to a trigger, then the system will begin executing the newly deployed version of the action immediately. Otherwise, the action will only be executed as a part of a flow once it is bound to that flow.

        Parameters
        ----------
        id : str
            The ID of an action.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeployActionResponseContent]
            Request to create action version was accepted.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}/deploy",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeployActionResponseContent,
                    parse_obj_as(
                        type_=DeployActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def test(
        self, id: str, *, payload: TestActionPayload, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[TestActionResponseContent]:
        """
        Test an action. After updating an action, it can be tested prior to being deployed to ensure it behaves as expected.

        Parameters
        ----------
        id : str
            The id of the action to test.

        payload : TestActionPayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TestActionResponseContent]
            Test action version successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"actions/actions/{jsonable_encoder(id)}/test",
            method="POST",
            json={
                "payload": payload,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TestActionResponseContent,
                    parse_obj_as(
                        type_=TestActionResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
