# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.pagination import AsyncPager, SyncPager
from ....core.request_options import RequestOptions
from ....types.action_binding import ActionBinding
from ....types.action_binding_with_ref import ActionBindingWithRef
from ....types.action_trigger_type_enum import ActionTriggerTypeEnum
from ....types.list_action_bindings_paginated_response_content import ListActionBindingsPaginatedResponseContent
from ....types.update_action_bindings_response_content import UpdateActionBindingsResponseContent
from .raw_client import AsyncRawBindingsClient, RawBindingsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BindingsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBindingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBindingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBindingsClient
        """
        return self._raw_client

    def list(
        self,
        trigger_id: ActionTriggerTypeEnum,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ActionBinding, ListActionBindingsPaginatedResponseContent]:
        """
        Retrieve the actions that are bound to a trigger. Once an action is created and deployed, it must be attached (i.e. bound) to a trigger so that it will be executed as part of a flow. The list of actions returned reflects the order in which they will be executed during the appropriate flow.

        Parameters
        ----------
        trigger_id : ActionTriggerTypeEnum
            An actions extensibility point.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned in a single request. 20 by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ActionBinding, ListActionBindingsPaginatedResponseContent]
            The bindings were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.actions.triggers.bindings.list(
            trigger_id="triggerId",
            page=1,
            per_page=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(trigger_id, page=page, per_page=per_page, request_options=request_options)

    def update_many(
        self,
        trigger_id: ActionTriggerTypeEnum,
        *,
        bindings: typing.Optional[typing.Sequence[ActionBindingWithRef]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateActionBindingsResponseContent:
        """
        Update the actions that are bound (i.e. attached) to a trigger. Once an action is created and deployed, it must be attached (i.e. bound) to a trigger so that it will be executed as part of a flow. The order in which the actions are provided will determine the order in which they are executed.

        Parameters
        ----------
        trigger_id : ActionTriggerTypeEnum
            An actions extensibility point.

        bindings : typing.Optional[typing.Sequence[ActionBindingWithRef]]
            The actions that will be bound to this trigger. The order in which they are included will be the order in which they are executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateActionBindingsResponseContent
            The bindings were updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.triggers.bindings.update_many(
            trigger_id="triggerId",
        )
        """
        _response = self._raw_client.update_many(trigger_id, bindings=bindings, request_options=request_options)
        return _response.data


class AsyncBindingsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBindingsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBindingsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBindingsClient
        """
        return self._raw_client

    async def list(
        self,
        trigger_id: ActionTriggerTypeEnum,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ActionBinding, ListActionBindingsPaginatedResponseContent]:
        """
        Retrieve the actions that are bound to a trigger. Once an action is created and deployed, it must be attached (i.e. bound) to a trigger so that it will be executed as part of a flow. The list of actions returned reflects the order in which they will be executed during the appropriate flow.

        Parameters
        ----------
        trigger_id : ActionTriggerTypeEnum
            An actions extensibility point.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            The maximum number of results to be returned in a single request. 20 by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ActionBinding, ListActionBindingsPaginatedResponseContent]
            The bindings were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.actions.triggers.bindings.list(
                trigger_id="triggerId",
                page=1,
                per_page=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(trigger_id, page=page, per_page=per_page, request_options=request_options)

    async def update_many(
        self,
        trigger_id: ActionTriggerTypeEnum,
        *,
        bindings: typing.Optional[typing.Sequence[ActionBindingWithRef]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateActionBindingsResponseContent:
        """
        Update the actions that are bound (i.e. attached) to a trigger. Once an action is created and deployed, it must be attached (i.e. bound) to a trigger so that it will be executed as part of a flow. The order in which the actions are provided will determine the order in which they are executed.

        Parameters
        ----------
        trigger_id : ActionTriggerTypeEnum
            An actions extensibility point.

        bindings : typing.Optional[typing.Sequence[ActionBindingWithRef]]
            The actions that will be bound to this trigger. The order in which they are included will be the order in which they are executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateActionBindingsResponseContent
            The bindings were updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.triggers.bindings.update_many(
                trigger_id="triggerId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_many(trigger_id, bindings=bindings, request_options=request_options)
        return _response.data
