# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.list_action_triggers_response_content import ListActionTriggersResponseContent
from .raw_client import AsyncRawTriggersClient, RawTriggersClient

if typing.TYPE_CHECKING:
    from .bindings.client import AsyncBindingsClient, BindingsClient


class TriggersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTriggersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._bindings: typing.Optional[BindingsClient] = None

    @property
    def with_raw_response(self) -> RawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTriggersClient
        """
        return self._raw_client

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> ListActionTriggersResponseContent:
        """
        Retrieve the set of triggers currently available within actions. A trigger is an extensibility point to which actions can be bound.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListActionTriggersResponseContent
            The triggers were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.triggers.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    @property
    def bindings(self):
        if self._bindings is None:
            from .bindings.client import BindingsClient  # noqa: E402

            self._bindings = BindingsClient(client_wrapper=self._client_wrapper)
        return self._bindings


class AsyncTriggersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTriggersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._bindings: typing.Optional[AsyncBindingsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawTriggersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTriggersClient
        """
        return self._raw_client

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListActionTriggersResponseContent:
        """
        Retrieve the set of triggers currently available within actions. A trigger is an extensibility point to which actions can be bound.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListActionTriggersResponseContent
            The triggers were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.triggers.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    @property
    def bindings(self):
        if self._bindings is None:
            from .bindings.client import AsyncBindingsClient  # noqa: E402

            self._bindings = AsyncBindingsClient(client_wrapper=self._client_wrapper)
        return self._bindings
