# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.action_version import ActionVersion
from ...types.deploy_action_version_request_content import DeployActionVersionRequestContent
from ...types.deploy_action_version_response_content import DeployActionVersionResponseContent
from ...types.get_action_version_response_content import GetActionVersionResponseContent
from ...types.list_action_versions_paginated_response_content import ListActionVersionsPaginatedResponseContent
from .raw_client import AsyncRawVersionsClient, RawVersionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class VersionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawVersionsClient
        """
        return self._raw_client

    def list(
        self,
        action_id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ActionVersion, ListActionVersionsPaginatedResponseContent]:
        """
        Retrieve all of an action's versions. An action version is created whenever an action is deployed. An action version is immutable, once created.

        Parameters
        ----------
        action_id : str
            The ID of the action.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            This field specify the maximum number of results to be returned by the server. 20 by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ActionVersion, ListActionVersionsPaginatedResponseContent]
            The action versions were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.actions.versions.list(
            action_id="actionId",
            page=1,
            per_page=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(action_id, page=page, per_page=per_page, request_options=request_options)

    def get(
        self, action_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActionVersionResponseContent:
        """
        Retrieve a specific version of an action. An action version is created whenever an action is deployed. An action version is immutable, once created.

        Parameters
        ----------
        action_id : str
            The ID of the action.

        id : str
            The ID of the action version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionVersionResponseContent
            The action version was retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.versions.get(
            action_id="actionId",
            id="id",
        )
        """
        _response = self._raw_client.get(action_id, id, request_options=request_options)
        return _response.data

    def deploy(
        self,
        action_id: str,
        id: str,
        *,
        request: typing.Optional[DeployActionVersionRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployActionVersionResponseContent:
        """
        Performs the equivalent of a roll-back of an action to an earlier, specified version. Creates a new, deployed action version that is identical to the specified version. If this action is currently bound to a trigger, the system will begin executing the newly-created version immediately.

        Parameters
        ----------
        action_id : str
            The ID of an action.

        id : str
            The ID of an action version.

        request : typing.Optional[DeployActionVersionRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployActionVersionResponseContent
            Request to create action version was accepted.

        Examples
        --------
        from auth0 import Auth0, DeployActionVersionRequestBodyParams

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.actions.versions.deploy(
            action_id="actionId",
            id="id",
            request=DeployActionVersionRequestBodyParams(),
        )
        """
        _response = self._raw_client.deploy(action_id, id, request=request, request_options=request_options)
        return _response.data


class AsyncVersionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawVersionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawVersionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawVersionsClient
        """
        return self._raw_client

    async def list(
        self,
        action_id: str,
        *,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ActionVersion, ListActionVersionsPaginatedResponseContent]:
        """
        Retrieve all of an action's versions. An action version is created whenever an action is deployed. An action version is immutable, once created.

        Parameters
        ----------
        action_id : str
            The ID of the action.

        page : typing.Optional[int]
            Use this field to request a specific page of the list results.

        per_page : typing.Optional[int]
            This field specify the maximum number of results to be returned by the server. 20 by default

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ActionVersion, ListActionVersionsPaginatedResponseContent]
            The action versions were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.actions.versions.list(
                action_id="actionId",
                page=1,
                per_page=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(action_id, page=page, per_page=per_page, request_options=request_options)

    async def get(
        self, action_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetActionVersionResponseContent:
        """
        Retrieve a specific version of an action. An action version is created whenever an action is deployed. An action version is immutable, once created.

        Parameters
        ----------
        action_id : str
            The ID of the action.

        id : str
            The ID of the action version.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetActionVersionResponseContent
            The action version was retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.versions.get(
                action_id="actionId",
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(action_id, id, request_options=request_options)
        return _response.data

    async def deploy(
        self,
        action_id: str,
        id: str,
        *,
        request: typing.Optional[DeployActionVersionRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeployActionVersionResponseContent:
        """
        Performs the equivalent of a roll-back of an action to an earlier, specified version. Creates a new, deployed action version that is identical to the specified version. If this action is currently bound to a trigger, the system will begin executing the newly-created version immediately.

        Parameters
        ----------
        action_id : str
            The ID of an action.

        id : str
            The ID of an action version.

        request : typing.Optional[DeployActionVersionRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeployActionVersionResponseContent
            Request to create action version was accepted.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, DeployActionVersionRequestBodyParams

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.actions.versions.deploy(
                action_id="actionId",
                id="id",
                request=DeployActionVersionRequestBodyParams(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.deploy(action_id, id, request=request, request_options=request_options)
        return _response.data
