# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.anomaly_ip_format import AnomalyIpFormat
from .raw_client import AsyncRawBlocksClient, RawBlocksClient


class BlocksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBlocksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBlocksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBlocksClient
        """
        return self._raw_client

    def check_ip(self, id: AnomalyIpFormat, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Check if the given IP address is blocked via the <a href="https://auth0.com/docs/configure/attack-protection/suspicious-ip-throttling">Suspicious IP Throttling</a> due to multiple suspicious attempts.

        Parameters
        ----------
        id : AnomalyIpFormat
            IP address to check.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.anomaly.blocks.check_ip(
            id="id",
        )
        """
        _response = self._raw_client.check_ip(id, request_options=request_options)
        return _response.data

    def unblock_ip(self, id: AnomalyIpFormat, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove a block imposed by <a href="https://auth0.com/docs/configure/attack-protection/suspicious-ip-throttling">Suspicious IP Throttling</a> for the given IP address.

        Parameters
        ----------
        id : AnomalyIpFormat
            IP address to unblock.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.anomaly.blocks.unblock_ip(
            id="id",
        )
        """
        _response = self._raw_client.unblock_ip(id, request_options=request_options)
        return _response.data


class AsyncBlocksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBlocksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBlocksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBlocksClient
        """
        return self._raw_client

    async def check_ip(self, id: AnomalyIpFormat, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Check if the given IP address is blocked via the <a href="https://auth0.com/docs/configure/attack-protection/suspicious-ip-throttling">Suspicious IP Throttling</a> due to multiple suspicious attempts.

        Parameters
        ----------
        id : AnomalyIpFormat
            IP address to check.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.anomaly.blocks.check_ip(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.check_ip(id, request_options=request_options)
        return _response.data

    async def unblock_ip(self, id: AnomalyIpFormat, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Remove a block imposed by <a href="https://auth0.com/docs/configure/attack-protection/suspicious-ip-throttling">Suspicious IP Throttling</a> for the given IP address.

        Parameters
        ----------
        id : AnomalyIpFormat
            IP address to unblock.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.anomaly.blocks.unblock_ip(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.unblock_ip(id, request_options=request_options)
        return _response.data
