# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawAnomalyClient, RawAnomalyClient

if typing.TYPE_CHECKING:
    from .blocks.client import AsyncBlocksClient, BlocksClient


class AnomalyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAnomalyClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._blocks: typing.Optional[BlocksClient] = None

    @property
    def with_raw_response(self) -> RawAnomalyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAnomalyClient
        """
        return self._raw_client

    @property
    def blocks(self):
        if self._blocks is None:
            from .blocks.client import BlocksClient  # noqa: E402

            self._blocks = BlocksClient(client_wrapper=self._client_wrapper)
        return self._blocks


class AsyncAnomalyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAnomalyClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._blocks: typing.Optional[AsyncBlocksClient] = None

    @property
    def with_raw_response(self) -> AsyncRawAnomalyClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAnomalyClient
        """
        return self._raw_client

    @property
    def blocks(self):
        if self._blocks is None:
            from .blocks.client import AsyncBlocksClient  # noqa: E402

            self._blocks = AsyncBlocksClient(client_wrapper=self._client_wrapper)
        return self._blocks
