# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.bot_detection_allowlist import BotDetectionAllowlist
from ...types.bot_detection_challenge_policy_password_flow_enum import BotDetectionChallengePolicyPasswordFlowEnum
from ...types.bot_detection_challenge_policy_password_reset_flow_enum import (
    BotDetectionChallengePolicyPasswordResetFlowEnum,
)
from ...types.bot_detection_challenge_policy_passwordless_flow_enum import (
    BotDetectionChallengePolicyPasswordlessFlowEnum,
)
from ...types.bot_detection_level_enum import BotDetectionLevelEnum
from ...types.bot_detection_monitoring_mode_enabled import BotDetectionMonitoringModeEnabled
from ...types.get_bot_detection_settings_response_content import GetBotDetectionSettingsResponseContent
from ...types.update_bot_detection_settings_response_content import UpdateBotDetectionSettingsResponseContent
from .raw_client import AsyncRawBotDetectionClient, RawBotDetectionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BotDetectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBotDetectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBotDetectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBotDetectionClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetBotDetectionSettingsResponseContent:
        """
        Get the Bot Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBotDetectionSettingsResponseContent
            Bot detection configuration retrieved successfully.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.bot_detection.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        bot_detection_level: typing.Optional[BotDetectionLevelEnum] = OMIT,
        challenge_password_policy: typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum] = OMIT,
        challenge_passwordless_policy: typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum] = OMIT,
        challenge_password_reset_policy: typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum] = OMIT,
        allowlist: typing.Optional[BotDetectionAllowlist] = OMIT,
        monitoring_mode_enabled: typing.Optional[BotDetectionMonitoringModeEnabled] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBotDetectionSettingsResponseContent:
        """
        Update the Bot Detection configuration of your tenant.

        Parameters
        ----------
        bot_detection_level : typing.Optional[BotDetectionLevelEnum]

        challenge_password_policy : typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum]

        challenge_passwordless_policy : typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum]

        challenge_password_reset_policy : typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum]

        allowlist : typing.Optional[BotDetectionAllowlist]

        monitoring_mode_enabled : typing.Optional[BotDetectionMonitoringModeEnabled]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBotDetectionSettingsResponseContent
            Bot detection configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.bot_detection.update()
        """
        _response = self._raw_client.update(
            bot_detection_level=bot_detection_level,
            challenge_password_policy=challenge_password_policy,
            challenge_passwordless_policy=challenge_passwordless_policy,
            challenge_password_reset_policy=challenge_password_reset_policy,
            allowlist=allowlist,
            monitoring_mode_enabled=monitoring_mode_enabled,
            request_options=request_options,
        )
        return _response.data


class AsyncBotDetectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBotDetectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBotDetectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBotDetectionClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBotDetectionSettingsResponseContent:
        """
        Get the Bot Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBotDetectionSettingsResponseContent
            Bot detection configuration retrieved successfully.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.bot_detection.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        bot_detection_level: typing.Optional[BotDetectionLevelEnum] = OMIT,
        challenge_password_policy: typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum] = OMIT,
        challenge_passwordless_policy: typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum] = OMIT,
        challenge_password_reset_policy: typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum] = OMIT,
        allowlist: typing.Optional[BotDetectionAllowlist] = OMIT,
        monitoring_mode_enabled: typing.Optional[BotDetectionMonitoringModeEnabled] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBotDetectionSettingsResponseContent:
        """
        Update the Bot Detection configuration of your tenant.

        Parameters
        ----------
        bot_detection_level : typing.Optional[BotDetectionLevelEnum]

        challenge_password_policy : typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum]

        challenge_passwordless_policy : typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum]

        challenge_password_reset_policy : typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum]

        allowlist : typing.Optional[BotDetectionAllowlist]

        monitoring_mode_enabled : typing.Optional[BotDetectionMonitoringModeEnabled]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBotDetectionSettingsResponseContent
            Bot detection configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.bot_detection.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            bot_detection_level=bot_detection_level,
            challenge_password_policy=challenge_password_policy,
            challenge_passwordless_policy=challenge_passwordless_policy,
            challenge_password_reset_policy=challenge_password_reset_policy,
            allowlist=allowlist,
            monitoring_mode_enabled=monitoring_mode_enabled,
            request_options=request_options,
        )
        return _response.data
