# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.not_found_error import NotFoundError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.bot_detection_allowlist import BotDetectionAllowlist
from ...types.bot_detection_challenge_policy_password_flow_enum import BotDetectionChallengePolicyPasswordFlowEnum
from ...types.bot_detection_challenge_policy_password_reset_flow_enum import (
    BotDetectionChallengePolicyPasswordResetFlowEnum,
)
from ...types.bot_detection_challenge_policy_passwordless_flow_enum import (
    BotDetectionChallengePolicyPasswordlessFlowEnum,
)
from ...types.bot_detection_level_enum import BotDetectionLevelEnum
from ...types.bot_detection_monitoring_mode_enabled import BotDetectionMonitoringModeEnabled
from ...types.get_bot_detection_settings_response_content import GetBotDetectionSettingsResponseContent
from ...types.update_bot_detection_settings_response_content import UpdateBotDetectionSettingsResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBotDetectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetBotDetectionSettingsResponseContent]:
        """
        Get the Bot Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetBotDetectionSettingsResponseContent]
            Bot detection configuration retrieved successfully.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/bot-detection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBotDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBotDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        bot_detection_level: typing.Optional[BotDetectionLevelEnum] = OMIT,
        challenge_password_policy: typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum] = OMIT,
        challenge_passwordless_policy: typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum] = OMIT,
        challenge_password_reset_policy: typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum] = OMIT,
        allowlist: typing.Optional[BotDetectionAllowlist] = OMIT,
        monitoring_mode_enabled: typing.Optional[BotDetectionMonitoringModeEnabled] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateBotDetectionSettingsResponseContent]:
        """
        Update the Bot Detection configuration of your tenant.

        Parameters
        ----------
        bot_detection_level : typing.Optional[BotDetectionLevelEnum]

        challenge_password_policy : typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum]

        challenge_passwordless_policy : typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum]

        challenge_password_reset_policy : typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum]

        allowlist : typing.Optional[BotDetectionAllowlist]

        monitoring_mode_enabled : typing.Optional[BotDetectionMonitoringModeEnabled]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateBotDetectionSettingsResponseContent]
            Bot detection configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/bot-detection",
            method="PATCH",
            json={
                "bot_detection_level": bot_detection_level,
                "challenge_password_policy": challenge_password_policy,
                "challenge_passwordless_policy": challenge_passwordless_policy,
                "challenge_password_reset_policy": challenge_password_reset_policy,
                "allowlist": allowlist,
                "monitoring_mode_enabled": monitoring_mode_enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBotDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBotDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBotDetectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetBotDetectionSettingsResponseContent]:
        """
        Get the Bot Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetBotDetectionSettingsResponseContent]
            Bot detection configuration retrieved successfully.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/bot-detection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBotDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBotDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        bot_detection_level: typing.Optional[BotDetectionLevelEnum] = OMIT,
        challenge_password_policy: typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum] = OMIT,
        challenge_passwordless_policy: typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum] = OMIT,
        challenge_password_reset_policy: typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum] = OMIT,
        allowlist: typing.Optional[BotDetectionAllowlist] = OMIT,
        monitoring_mode_enabled: typing.Optional[BotDetectionMonitoringModeEnabled] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateBotDetectionSettingsResponseContent]:
        """
        Update the Bot Detection configuration of your tenant.

        Parameters
        ----------
        bot_detection_level : typing.Optional[BotDetectionLevelEnum]

        challenge_password_policy : typing.Optional[BotDetectionChallengePolicyPasswordFlowEnum]

        challenge_passwordless_policy : typing.Optional[BotDetectionChallengePolicyPasswordlessFlowEnum]

        challenge_password_reset_policy : typing.Optional[BotDetectionChallengePolicyPasswordResetFlowEnum]

        allowlist : typing.Optional[BotDetectionAllowlist]

        monitoring_mode_enabled : typing.Optional[BotDetectionMonitoringModeEnabled]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateBotDetectionSettingsResponseContent]
            Bot detection configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/bot-detection",
            method="PATCH",
            json={
                "bot_detection_level": bot_detection_level,
                "challenge_password_policy": challenge_password_policy,
                "challenge_passwordless_policy": challenge_passwordless_policy,
                "challenge_password_reset_policy": challenge_password_reset_policy,
                "allowlist": allowlist,
                "monitoring_mode_enabled": monitoring_mode_enabled,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBotDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBotDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
