# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.breached_password_detection_admin_notification_frequency_enum import (
    BreachedPasswordDetectionAdminNotificationFrequencyEnum,
)
from ...types.breached_password_detection_method_enum import BreachedPasswordDetectionMethodEnum
from ...types.breached_password_detection_shields_enum import BreachedPasswordDetectionShieldsEnum
from ...types.breached_password_detection_stage import BreachedPasswordDetectionStage
from ...types.get_breached_password_detection_settings_response_content import (
    GetBreachedPasswordDetectionSettingsResponseContent,
)
from ...types.update_breached_password_detection_settings_response_content import (
    UpdateBreachedPasswordDetectionSettingsResponseContent,
)
from .raw_client import AsyncRawBreachedPasswordDetectionClient, RawBreachedPasswordDetectionClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BreachedPasswordDetectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBreachedPasswordDetectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBreachedPasswordDetectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBreachedPasswordDetectionClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBreachedPasswordDetectionSettingsResponseContent:
        """
        Retrieve details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBreachedPasswordDetectionSettingsResponseContent
            Breached password detection settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.breached_password_detection.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = True,
        shields: typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]] = OMIT,
        admin_notification_frequency: typing.Optional[
            typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]
        ] = OMIT,
        method: typing.Optional[BreachedPasswordDetectionMethodEnum] = OMIT,
        stage: typing.Optional[BreachedPasswordDetectionStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBreachedPasswordDetectionSettingsResponseContent:
        """
        Update details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not breached password detection is active.

        shields : typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]]
            Action to take when a breached password is detected during a login.
                  Possible values: <code>block</code>, <code>user_notification</code>, <code>admin_notification</code>.

        admin_notification_frequency : typing.Optional[typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]]
            When "admin_notification" is enabled, determines how often email notifications are sent.
                    Possible values: <code>immediately</code>, <code>daily</code>, <code>weekly</code>, <code>monthly</code>.

        method : typing.Optional[BreachedPasswordDetectionMethodEnum]

        stage : typing.Optional[BreachedPasswordDetectionStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBreachedPasswordDetectionSettingsResponseContent
            Breached password detection settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.breached_password_detection.update()
        """
        _response = self._raw_client.update(
            enabled=enabled,
            shields=shields,
            admin_notification_frequency=admin_notification_frequency,
            method=method,
            stage=stage,
            request_options=request_options,
        )
        return _response.data


class AsyncBreachedPasswordDetectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBreachedPasswordDetectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBreachedPasswordDetectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBreachedPasswordDetectionClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBreachedPasswordDetectionSettingsResponseContent:
        """
        Retrieve details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBreachedPasswordDetectionSettingsResponseContent
            Breached password detection settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.breached_password_detection.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = True,
        shields: typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]] = OMIT,
        admin_notification_frequency: typing.Optional[
            typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]
        ] = OMIT,
        method: typing.Optional[BreachedPasswordDetectionMethodEnum] = OMIT,
        stage: typing.Optional[BreachedPasswordDetectionStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBreachedPasswordDetectionSettingsResponseContent:
        """
        Update details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not breached password detection is active.

        shields : typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]]
            Action to take when a breached password is detected during a login.
                  Possible values: <code>block</code>, <code>user_notification</code>, <code>admin_notification</code>.

        admin_notification_frequency : typing.Optional[typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]]
            When "admin_notification" is enabled, determines how often email notifications are sent.
                    Possible values: <code>immediately</code>, <code>daily</code>, <code>weekly</code>, <code>monthly</code>.

        method : typing.Optional[BreachedPasswordDetectionMethodEnum]

        stage : typing.Optional[BreachedPasswordDetectionStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBreachedPasswordDetectionSettingsResponseContent
            Breached password detection settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.breached_password_detection.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            enabled=enabled,
            shields=shields,
            admin_notification_frequency=admin_notification_frequency,
            method=method,
            stage=stage,
            request_options=request_options,
        )
        return _response.data
