# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.breached_password_detection_admin_notification_frequency_enum import (
    BreachedPasswordDetectionAdminNotificationFrequencyEnum,
)
from ...types.breached_password_detection_method_enum import BreachedPasswordDetectionMethodEnum
from ...types.breached_password_detection_shields_enum import BreachedPasswordDetectionShieldsEnum
from ...types.breached_password_detection_stage import BreachedPasswordDetectionStage
from ...types.get_breached_password_detection_settings_response_content import (
    GetBreachedPasswordDetectionSettingsResponseContent,
)
from ...types.update_breached_password_detection_settings_response_content import (
    UpdateBreachedPasswordDetectionSettingsResponseContent,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBreachedPasswordDetectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetBreachedPasswordDetectionSettingsResponseContent]:
        """
        Retrieve details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetBreachedPasswordDetectionSettingsResponseContent]
            Breached password detection settings successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/breached-password-detection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBreachedPasswordDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBreachedPasswordDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = True,
        shields: typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]] = OMIT,
        admin_notification_frequency: typing.Optional[
            typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]
        ] = OMIT,
        method: typing.Optional[BreachedPasswordDetectionMethodEnum] = OMIT,
        stage: typing.Optional[BreachedPasswordDetectionStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateBreachedPasswordDetectionSettingsResponseContent]:
        """
        Update details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not breached password detection is active.

        shields : typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]]
            Action to take when a breached password is detected during a login.
                  Possible values: <code>block</code>, <code>user_notification</code>, <code>admin_notification</code>.

        admin_notification_frequency : typing.Optional[typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]]
            When "admin_notification" is enabled, determines how often email notifications are sent.
                    Possible values: <code>immediately</code>, <code>daily</code>, <code>weekly</code>, <code>monthly</code>.

        method : typing.Optional[BreachedPasswordDetectionMethodEnum]

        stage : typing.Optional[BreachedPasswordDetectionStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateBreachedPasswordDetectionSettingsResponseContent]
            Breached password detection settings successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/breached-password-detection",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "admin_notification_frequency": admin_notification_frequency,
                "method": method,
                "stage": convert_and_respect_annotation_metadata(
                    object_=stage, annotation=BreachedPasswordDetectionStage, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBreachedPasswordDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBreachedPasswordDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBreachedPasswordDetectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetBreachedPasswordDetectionSettingsResponseContent]:
        """
        Retrieve details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetBreachedPasswordDetectionSettingsResponseContent]
            Breached password detection settings successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/breached-password-detection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBreachedPasswordDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBreachedPasswordDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = True,
        shields: typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]] = OMIT,
        admin_notification_frequency: typing.Optional[
            typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]
        ] = OMIT,
        method: typing.Optional[BreachedPasswordDetectionMethodEnum] = OMIT,
        stage: typing.Optional[BreachedPasswordDetectionStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateBreachedPasswordDetectionSettingsResponseContent]:
        """
        Update details of the Breached Password Detection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not breached password detection is active.

        shields : typing.Optional[typing.Sequence[BreachedPasswordDetectionShieldsEnum]]
            Action to take when a breached password is detected during a login.
                  Possible values: <code>block</code>, <code>user_notification</code>, <code>admin_notification</code>.

        admin_notification_frequency : typing.Optional[typing.Sequence[BreachedPasswordDetectionAdminNotificationFrequencyEnum]]
            When "admin_notification" is enabled, determines how often email notifications are sent.
                    Possible values: <code>immediately</code>, <code>daily</code>, <code>weekly</code>, <code>monthly</code>.

        method : typing.Optional[BreachedPasswordDetectionMethodEnum]

        stage : typing.Optional[BreachedPasswordDetectionStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateBreachedPasswordDetectionSettingsResponseContent]
            Breached password detection settings successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/breached-password-detection",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "admin_notification_frequency": admin_notification_frequency,
                "method": method,
                "stage": convert_and_respect_annotation_metadata(
                    object_=stage, annotation=BreachedPasswordDetectionStage, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBreachedPasswordDetectionSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBreachedPasswordDetectionSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
