# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_brute_force_settings_response_content import GetBruteForceSettingsResponseContent
from ...types.update_brute_force_settings_response_content import UpdateBruteForceSettingsResponseContent
from .raw_client import AsyncRawBruteForceProtectionClient, RawBruteForceProtectionClient
from .types.update_brute_force_settings_request_content_mode import UpdateBruteForceSettingsRequestContentMode
from .types.update_brute_force_settings_request_content_shields_item import (
    UpdateBruteForceSettingsRequestContentShieldsItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BruteForceProtectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBruteForceProtectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBruteForceProtectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBruteForceProtectionClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetBruteForceSettingsResponseContent:
        """
        Retrieve details of the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBruteForceSettingsResponseContent
            Brute force configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.brute_force_protection.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]] = OMIT,
        allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        mode: typing.Optional[UpdateBruteForceSettingsRequestContentMode] = OMIT,
        max_attempts: typing.Optional[int] = 10,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBruteForceSettingsResponseContent:
        """
        Update the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not brute force attack protections are active.

        shields : typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]]
            Action to take when a brute force protection threshold is violated.
                    Possible values: <code>block</code>, <code>user_notification</code>.

        allowlist : typing.Optional[typing.Sequence[str]]
            List of trusted IP addresses that will not have attack protection enforced against them.

        mode : typing.Optional[UpdateBruteForceSettingsRequestContentMode]
            Account Lockout: Determines whether or not IP address is used when counting failed attempts.
                      Possible values: <code>count_per_identifier_and_ip</code>, <code>count_per_identifier</code>.

        max_attempts : typing.Optional[int]
            Maximum number of unsuccessful attempts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBruteForceSettingsResponseContent
            Brute force configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.brute_force_protection.update()
        """
        _response = self._raw_client.update(
            enabled=enabled,
            shields=shields,
            allowlist=allowlist,
            mode=mode,
            max_attempts=max_attempts,
            request_options=request_options,
        )
        return _response.data


class AsyncBruteForceProtectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBruteForceProtectionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBruteForceProtectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBruteForceProtectionClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBruteForceSettingsResponseContent:
        """
        Retrieve details of the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBruteForceSettingsResponseContent
            Brute force configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.brute_force_protection.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]] = OMIT,
        allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        mode: typing.Optional[UpdateBruteForceSettingsRequestContentMode] = OMIT,
        max_attempts: typing.Optional[int] = 10,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBruteForceSettingsResponseContent:
        """
        Update the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not brute force attack protections are active.

        shields : typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]]
            Action to take when a brute force protection threshold is violated.
                    Possible values: <code>block</code>, <code>user_notification</code>.

        allowlist : typing.Optional[typing.Sequence[str]]
            List of trusted IP addresses that will not have attack protection enforced against them.

        mode : typing.Optional[UpdateBruteForceSettingsRequestContentMode]
            Account Lockout: Determines whether or not IP address is used when counting failed attempts.
                      Possible values: <code>count_per_identifier_and_ip</code>, <code>count_per_identifier</code>.

        max_attempts : typing.Optional[int]
            Maximum number of unsuccessful attempts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBruteForceSettingsResponseContent
            Brute force configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.brute_force_protection.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            enabled=enabled,
            shields=shields,
            allowlist=allowlist,
            mode=mode,
            max_attempts=max_attempts,
            request_options=request_options,
        )
        return _response.data
