# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.get_brute_force_settings_response_content import GetBruteForceSettingsResponseContent
from ...types.update_brute_force_settings_response_content import UpdateBruteForceSettingsResponseContent
from .types.update_brute_force_settings_request_content_mode import UpdateBruteForceSettingsRequestContentMode
from .types.update_brute_force_settings_request_content_shields_item import (
    UpdateBruteForceSettingsRequestContentShieldsItem,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawBruteForceProtectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetBruteForceSettingsResponseContent]:
        """
        Retrieve details of the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetBruteForceSettingsResponseContent]
            Brute force configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/brute-force-protection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBruteForceSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBruteForceSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]] = OMIT,
        allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        mode: typing.Optional[UpdateBruteForceSettingsRequestContentMode] = OMIT,
        max_attempts: typing.Optional[int] = 10,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateBruteForceSettingsResponseContent]:
        """
        Update the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not brute force attack protections are active.

        shields : typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]]
            Action to take when a brute force protection threshold is violated.
                    Possible values: <code>block</code>, <code>user_notification</code>.

        allowlist : typing.Optional[typing.Sequence[str]]
            List of trusted IP addresses that will not have attack protection enforced against them.

        mode : typing.Optional[UpdateBruteForceSettingsRequestContentMode]
            Account Lockout: Determines whether or not IP address is used when counting failed attempts.
                      Possible values: <code>count_per_identifier_and_ip</code>, <code>count_per_identifier</code>.

        max_attempts : typing.Optional[int]
            Maximum number of unsuccessful attempts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateBruteForceSettingsResponseContent]
            Brute force configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/brute-force-protection",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "allowlist": allowlist,
                "mode": mode,
                "max_attempts": max_attempts,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBruteForceSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBruteForceSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBruteForceProtectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetBruteForceSettingsResponseContent]:
        """
        Retrieve details of the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetBruteForceSettingsResponseContent]
            Brute force configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/brute-force-protection",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetBruteForceSettingsResponseContent,
                    parse_obj_as(
                        type_=GetBruteForceSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]] = OMIT,
        allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        mode: typing.Optional[UpdateBruteForceSettingsRequestContentMode] = OMIT,
        max_attempts: typing.Optional[int] = 10,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateBruteForceSettingsResponseContent]:
        """
        Update the Brute-force Protection configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not brute force attack protections are active.

        shields : typing.Optional[typing.Sequence[UpdateBruteForceSettingsRequestContentShieldsItem]]
            Action to take when a brute force protection threshold is violated.
                    Possible values: <code>block</code>, <code>user_notification</code>.

        allowlist : typing.Optional[typing.Sequence[str]]
            List of trusted IP addresses that will not have attack protection enforced against them.

        mode : typing.Optional[UpdateBruteForceSettingsRequestContentMode]
            Account Lockout: Determines whether or not IP address is used when counting failed attempts.
                      Possible values: <code>count_per_identifier_and_ip</code>, <code>count_per_identifier</code>.

        max_attempts : typing.Optional[int]
            Maximum number of unsuccessful attempts.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateBruteForceSettingsResponseContent]
            Brute force configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/brute-force-protection",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "allowlist": allowlist,
                "mode": mode,
                "max_attempts": max_attempts,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateBruteForceSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateBruteForceSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
