# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.attack_protection_captcha_auth_challenge_request import AttackProtectionCaptchaAuthChallengeRequest
from ...types.attack_protection_captcha_provider_id import AttackProtectionCaptchaProviderId
from ...types.attack_protection_captcha_simple_captcha_response_content import (
    AttackProtectionCaptchaSimpleCaptchaResponseContent,
)
from ...types.attack_protection_update_captcha_arkose import AttackProtectionUpdateCaptchaArkose
from ...types.attack_protection_update_captcha_friendly_captcha import AttackProtectionUpdateCaptchaFriendlyCaptcha
from ...types.attack_protection_update_captcha_hcaptcha import AttackProtectionUpdateCaptchaHcaptcha
from ...types.attack_protection_update_captcha_recaptcha_enterprise import (
    AttackProtectionUpdateCaptchaRecaptchaEnterprise,
)
from ...types.attack_protection_update_captcha_recaptcha_v_2 import AttackProtectionUpdateCaptchaRecaptchaV2
from ...types.get_attack_protection_captcha_response_content import GetAttackProtectionCaptchaResponseContent
from ...types.update_attack_protection_captcha_response_content import UpdateAttackProtectionCaptchaResponseContent
from .raw_client import AsyncRawCaptchaClient, RawCaptchaClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CaptchaClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCaptchaClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCaptchaClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCaptchaClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAttackProtectionCaptchaResponseContent:
        """
        Get the CAPTCHA configuration for your client.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAttackProtectionCaptchaResponseContent
            Captcha configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.captcha.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        active_provider_id: typing.Optional[AttackProtectionCaptchaProviderId] = OMIT,
        arkose: typing.Optional[AttackProtectionUpdateCaptchaArkose] = OMIT,
        auth_challenge: typing.Optional[AttackProtectionCaptchaAuthChallengeRequest] = OMIT,
        hcaptcha: typing.Optional[AttackProtectionUpdateCaptchaHcaptcha] = OMIT,
        friendly_captcha: typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha] = OMIT,
        recaptcha_enterprise: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise] = OMIT,
        recaptcha_v_2: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2] = OMIT,
        simple_captcha: typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAttackProtectionCaptchaResponseContent:
        """
        Update existing CAPTCHA configuration for your client.

        Parameters
        ----------
        active_provider_id : typing.Optional[AttackProtectionCaptchaProviderId]

        arkose : typing.Optional[AttackProtectionUpdateCaptchaArkose]

        auth_challenge : typing.Optional[AttackProtectionCaptchaAuthChallengeRequest]

        hcaptcha : typing.Optional[AttackProtectionUpdateCaptchaHcaptcha]

        friendly_captcha : typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha]

        recaptcha_enterprise : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise]

        recaptcha_v_2 : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2]

        simple_captcha : typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAttackProtectionCaptchaResponseContent
            Captcha configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.captcha.update()
        """
        _response = self._raw_client.update(
            active_provider_id=active_provider_id,
            arkose=arkose,
            auth_challenge=auth_challenge,
            hcaptcha=hcaptcha,
            friendly_captcha=friendly_captcha,
            recaptcha_enterprise=recaptcha_enterprise,
            recaptcha_v_2=recaptcha_v_2,
            simple_captcha=simple_captcha,
            request_options=request_options,
        )
        return _response.data


class AsyncCaptchaClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCaptchaClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCaptchaClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCaptchaClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetAttackProtectionCaptchaResponseContent:
        """
        Get the CAPTCHA configuration for your client.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAttackProtectionCaptchaResponseContent
            Captcha configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.captcha.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        active_provider_id: typing.Optional[AttackProtectionCaptchaProviderId] = OMIT,
        arkose: typing.Optional[AttackProtectionUpdateCaptchaArkose] = OMIT,
        auth_challenge: typing.Optional[AttackProtectionCaptchaAuthChallengeRequest] = OMIT,
        hcaptcha: typing.Optional[AttackProtectionUpdateCaptchaHcaptcha] = OMIT,
        friendly_captcha: typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha] = OMIT,
        recaptcha_enterprise: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise] = OMIT,
        recaptcha_v_2: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2] = OMIT,
        simple_captcha: typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateAttackProtectionCaptchaResponseContent:
        """
        Update existing CAPTCHA configuration for your client.

        Parameters
        ----------
        active_provider_id : typing.Optional[AttackProtectionCaptchaProviderId]

        arkose : typing.Optional[AttackProtectionUpdateCaptchaArkose]

        auth_challenge : typing.Optional[AttackProtectionCaptchaAuthChallengeRequest]

        hcaptcha : typing.Optional[AttackProtectionUpdateCaptchaHcaptcha]

        friendly_captcha : typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha]

        recaptcha_enterprise : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise]

        recaptcha_v_2 : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2]

        simple_captcha : typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateAttackProtectionCaptchaResponseContent
            Captcha configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.captcha.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            active_provider_id=active_provider_id,
            arkose=arkose,
            auth_challenge=auth_challenge,
            hcaptcha=hcaptcha,
            friendly_captcha=friendly_captcha,
            recaptcha_enterprise=recaptcha_enterprise,
            recaptcha_v_2=recaptcha_v_2,
            simple_captcha=simple_captcha,
            request_options=request_options,
        )
        return _response.data
