# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.forbidden_error import ForbiddenError
from ...errors.not_found_error import NotFoundError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.attack_protection_captcha_auth_challenge_request import AttackProtectionCaptchaAuthChallengeRequest
from ...types.attack_protection_captcha_provider_id import AttackProtectionCaptchaProviderId
from ...types.attack_protection_captcha_simple_captcha_response_content import (
    AttackProtectionCaptchaSimpleCaptchaResponseContent,
)
from ...types.attack_protection_update_captcha_arkose import AttackProtectionUpdateCaptchaArkose
from ...types.attack_protection_update_captcha_friendly_captcha import AttackProtectionUpdateCaptchaFriendlyCaptcha
from ...types.attack_protection_update_captcha_hcaptcha import AttackProtectionUpdateCaptchaHcaptcha
from ...types.attack_protection_update_captcha_recaptcha_enterprise import (
    AttackProtectionUpdateCaptchaRecaptchaEnterprise,
)
from ...types.attack_protection_update_captcha_recaptcha_v_2 import AttackProtectionUpdateCaptchaRecaptchaV2
from ...types.get_attack_protection_captcha_response_content import GetAttackProtectionCaptchaResponseContent
from ...types.update_attack_protection_captcha_response_content import UpdateAttackProtectionCaptchaResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCaptchaClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetAttackProtectionCaptchaResponseContent]:
        """
        Get the CAPTCHA configuration for your client.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetAttackProtectionCaptchaResponseContent]
            Captcha configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/captcha",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAttackProtectionCaptchaResponseContent,
                    parse_obj_as(
                        type_=GetAttackProtectionCaptchaResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        active_provider_id: typing.Optional[AttackProtectionCaptchaProviderId] = OMIT,
        arkose: typing.Optional[AttackProtectionUpdateCaptchaArkose] = OMIT,
        auth_challenge: typing.Optional[AttackProtectionCaptchaAuthChallengeRequest] = OMIT,
        hcaptcha: typing.Optional[AttackProtectionUpdateCaptchaHcaptcha] = OMIT,
        friendly_captcha: typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha] = OMIT,
        recaptcha_enterprise: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise] = OMIT,
        recaptcha_v_2: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2] = OMIT,
        simple_captcha: typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateAttackProtectionCaptchaResponseContent]:
        """
        Update existing CAPTCHA configuration for your client.

        Parameters
        ----------
        active_provider_id : typing.Optional[AttackProtectionCaptchaProviderId]

        arkose : typing.Optional[AttackProtectionUpdateCaptchaArkose]

        auth_challenge : typing.Optional[AttackProtectionCaptchaAuthChallengeRequest]

        hcaptcha : typing.Optional[AttackProtectionUpdateCaptchaHcaptcha]

        friendly_captcha : typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha]

        recaptcha_enterprise : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise]

        recaptcha_v_2 : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2]

        simple_captcha : typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateAttackProtectionCaptchaResponseContent]
            Captcha configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/captcha",
            method="PATCH",
            json={
                "active_provider_id": active_provider_id,
                "arkose": convert_and_respect_annotation_metadata(
                    object_=arkose, annotation=AttackProtectionUpdateCaptchaArkose, direction="write"
                ),
                "auth_challenge": convert_and_respect_annotation_metadata(
                    object_=auth_challenge, annotation=AttackProtectionCaptchaAuthChallengeRequest, direction="write"
                ),
                "hcaptcha": convert_and_respect_annotation_metadata(
                    object_=hcaptcha, annotation=AttackProtectionUpdateCaptchaHcaptcha, direction="write"
                ),
                "friendly_captcha": convert_and_respect_annotation_metadata(
                    object_=friendly_captcha, annotation=AttackProtectionUpdateCaptchaFriendlyCaptcha, direction="write"
                ),
                "recaptcha_enterprise": convert_and_respect_annotation_metadata(
                    object_=recaptcha_enterprise,
                    annotation=AttackProtectionUpdateCaptchaRecaptchaEnterprise,
                    direction="write",
                ),
                "recaptcha_v2": convert_and_respect_annotation_metadata(
                    object_=recaptcha_v_2, annotation=AttackProtectionUpdateCaptchaRecaptchaV2, direction="write"
                ),
                "simple_captcha": simple_captcha,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateAttackProtectionCaptchaResponseContent,
                    parse_obj_as(
                        type_=UpdateAttackProtectionCaptchaResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCaptchaClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetAttackProtectionCaptchaResponseContent]:
        """
        Get the CAPTCHA configuration for your client.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetAttackProtectionCaptchaResponseContent]
            Captcha configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/captcha",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetAttackProtectionCaptchaResponseContent,
                    parse_obj_as(
                        type_=GetAttackProtectionCaptchaResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        active_provider_id: typing.Optional[AttackProtectionCaptchaProviderId] = OMIT,
        arkose: typing.Optional[AttackProtectionUpdateCaptchaArkose] = OMIT,
        auth_challenge: typing.Optional[AttackProtectionCaptchaAuthChallengeRequest] = OMIT,
        hcaptcha: typing.Optional[AttackProtectionUpdateCaptchaHcaptcha] = OMIT,
        friendly_captcha: typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha] = OMIT,
        recaptcha_enterprise: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise] = OMIT,
        recaptcha_v_2: typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2] = OMIT,
        simple_captcha: typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateAttackProtectionCaptchaResponseContent]:
        """
        Update existing CAPTCHA configuration for your client.

        Parameters
        ----------
        active_provider_id : typing.Optional[AttackProtectionCaptchaProviderId]

        arkose : typing.Optional[AttackProtectionUpdateCaptchaArkose]

        auth_challenge : typing.Optional[AttackProtectionCaptchaAuthChallengeRequest]

        hcaptcha : typing.Optional[AttackProtectionUpdateCaptchaHcaptcha]

        friendly_captcha : typing.Optional[AttackProtectionUpdateCaptchaFriendlyCaptcha]

        recaptcha_enterprise : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaEnterprise]

        recaptcha_v_2 : typing.Optional[AttackProtectionUpdateCaptchaRecaptchaV2]

        simple_captcha : typing.Optional[AttackProtectionCaptchaSimpleCaptchaResponseContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateAttackProtectionCaptchaResponseContent]
            Captcha configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/captcha",
            method="PATCH",
            json={
                "active_provider_id": active_provider_id,
                "arkose": convert_and_respect_annotation_metadata(
                    object_=arkose, annotation=AttackProtectionUpdateCaptchaArkose, direction="write"
                ),
                "auth_challenge": convert_and_respect_annotation_metadata(
                    object_=auth_challenge, annotation=AttackProtectionCaptchaAuthChallengeRequest, direction="write"
                ),
                "hcaptcha": convert_and_respect_annotation_metadata(
                    object_=hcaptcha, annotation=AttackProtectionUpdateCaptchaHcaptcha, direction="write"
                ),
                "friendly_captcha": convert_and_respect_annotation_metadata(
                    object_=friendly_captcha, annotation=AttackProtectionUpdateCaptchaFriendlyCaptcha, direction="write"
                ),
                "recaptcha_enterprise": convert_and_respect_annotation_metadata(
                    object_=recaptcha_enterprise,
                    annotation=AttackProtectionUpdateCaptchaRecaptchaEnterprise,
                    direction="write",
                ),
                "recaptcha_v2": convert_and_respect_annotation_metadata(
                    object_=recaptcha_v_2, annotation=AttackProtectionUpdateCaptchaRecaptchaV2, direction="write"
                ),
                "simple_captcha": simple_captcha,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateAttackProtectionCaptchaResponseContent,
                    parse_obj_as(
                        type_=UpdateAttackProtectionCaptchaResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
