# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawAttackProtectionClient, RawAttackProtectionClient

if typing.TYPE_CHECKING:
    from .bot_detection.client import AsyncBotDetectionClient, BotDetectionClient
    from .breached_password_detection.client import (
        AsyncBreachedPasswordDetectionClient,
        BreachedPasswordDetectionClient,
    )
    from .brute_force_protection.client import AsyncBruteForceProtectionClient, BruteForceProtectionClient
    from .captcha.client import AsyncCaptchaClient, CaptchaClient
    from .suspicious_ip_throttling.client import AsyncSuspiciousIpThrottlingClient, SuspiciousIpThrottlingClient


class AttackProtectionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAttackProtectionClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._bot_detection: typing.Optional[BotDetectionClient] = None
        self._breached_password_detection: typing.Optional[BreachedPasswordDetectionClient] = None
        self._brute_force_protection: typing.Optional[BruteForceProtectionClient] = None
        self._captcha: typing.Optional[CaptchaClient] = None
        self._suspicious_ip_throttling: typing.Optional[SuspiciousIpThrottlingClient] = None

    @property
    def with_raw_response(self) -> RawAttackProtectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAttackProtectionClient
        """
        return self._raw_client

    @property
    def bot_detection(self):
        if self._bot_detection is None:
            from .bot_detection.client import BotDetectionClient  # noqa: E402

            self._bot_detection = BotDetectionClient(client_wrapper=self._client_wrapper)
        return self._bot_detection

    @property
    def breached_password_detection(self):
        if self._breached_password_detection is None:
            from .breached_password_detection.client import BreachedPasswordDetectionClient  # noqa: E402

            self._breached_password_detection = BreachedPasswordDetectionClient(client_wrapper=self._client_wrapper)
        return self._breached_password_detection

    @property
    def brute_force_protection(self):
        if self._brute_force_protection is None:
            from .brute_force_protection.client import BruteForceProtectionClient  # noqa: E402

            self._brute_force_protection = BruteForceProtectionClient(client_wrapper=self._client_wrapper)
        return self._brute_force_protection

    @property
    def captcha(self):
        if self._captcha is None:
            from .captcha.client import CaptchaClient  # noqa: E402

            self._captcha = CaptchaClient(client_wrapper=self._client_wrapper)
        return self._captcha

    @property
    def suspicious_ip_throttling(self):
        if self._suspicious_ip_throttling is None:
            from .suspicious_ip_throttling.client import SuspiciousIpThrottlingClient  # noqa: E402

            self._suspicious_ip_throttling = SuspiciousIpThrottlingClient(client_wrapper=self._client_wrapper)
        return self._suspicious_ip_throttling


class AsyncAttackProtectionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAttackProtectionClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._bot_detection: typing.Optional[AsyncBotDetectionClient] = None
        self._breached_password_detection: typing.Optional[AsyncBreachedPasswordDetectionClient] = None
        self._brute_force_protection: typing.Optional[AsyncBruteForceProtectionClient] = None
        self._captcha: typing.Optional[AsyncCaptchaClient] = None
        self._suspicious_ip_throttling: typing.Optional[AsyncSuspiciousIpThrottlingClient] = None

    @property
    def with_raw_response(self) -> AsyncRawAttackProtectionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAttackProtectionClient
        """
        return self._raw_client

    @property
    def bot_detection(self):
        if self._bot_detection is None:
            from .bot_detection.client import AsyncBotDetectionClient  # noqa: E402

            self._bot_detection = AsyncBotDetectionClient(client_wrapper=self._client_wrapper)
        return self._bot_detection

    @property
    def breached_password_detection(self):
        if self._breached_password_detection is None:
            from .breached_password_detection.client import AsyncBreachedPasswordDetectionClient  # noqa: E402

            self._breached_password_detection = AsyncBreachedPasswordDetectionClient(
                client_wrapper=self._client_wrapper
            )
        return self._breached_password_detection

    @property
    def brute_force_protection(self):
        if self._brute_force_protection is None:
            from .brute_force_protection.client import AsyncBruteForceProtectionClient  # noqa: E402

            self._brute_force_protection = AsyncBruteForceProtectionClient(client_wrapper=self._client_wrapper)
        return self._brute_force_protection

    @property
    def captcha(self):
        if self._captcha is None:
            from .captcha.client import AsyncCaptchaClient  # noqa: E402

            self._captcha = AsyncCaptchaClient(client_wrapper=self._client_wrapper)
        return self._captcha

    @property
    def suspicious_ip_throttling(self):
        if self._suspicious_ip_throttling is None:
            from .suspicious_ip_throttling.client import AsyncSuspiciousIpThrottlingClient  # noqa: E402

            self._suspicious_ip_throttling = AsyncSuspiciousIpThrottlingClient(client_wrapper=self._client_wrapper)
        return self._suspicious_ip_throttling
