# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_suspicious_ip_throttling_settings_response_content import (
    GetSuspiciousIpThrottlingSettingsResponseContent,
)
from ...types.suspicious_ip_throttling_allowlist import SuspiciousIpThrottlingAllowlist
from ...types.suspicious_ip_throttling_shields_enum import SuspiciousIpThrottlingShieldsEnum
from ...types.suspicious_ip_throttling_stage import SuspiciousIpThrottlingStage
from ...types.update_suspicious_ip_throttling_settings_response_content import (
    UpdateSuspiciousIpThrottlingSettingsResponseContent,
)
from .raw_client import AsyncRawSuspiciousIpThrottlingClient, RawSuspiciousIpThrottlingClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SuspiciousIpThrottlingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSuspiciousIpThrottlingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSuspiciousIpThrottlingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSuspiciousIpThrottlingClient
        """
        return self._raw_client

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSuspiciousIpThrottlingSettingsResponseContent:
        """
        Retrieve details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSuspiciousIpThrottlingSettingsResponseContent
            Suspicious IP throttling configuration successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.suspicious_ip_throttling.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]] = OMIT,
        allowlist: typing.Optional[SuspiciousIpThrottlingAllowlist] = OMIT,
        stage: typing.Optional[SuspiciousIpThrottlingStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSuspiciousIpThrottlingSettingsResponseContent:
        """
        Update the details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not suspicious IP throttling attack protections are active.

        shields : typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]]
            Action to take when a suspicious IP throttling threshold is violated.
                      Possible values: <code>block</code>, <code>admin_notification</code>.

        allowlist : typing.Optional[SuspiciousIpThrottlingAllowlist]

        stage : typing.Optional[SuspiciousIpThrottlingStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSuspiciousIpThrottlingSettingsResponseContent
            Suspicious IP throttling configuration successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.attack_protection.suspicious_ip_throttling.update()
        """
        _response = self._raw_client.update(
            enabled=enabled, shields=shields, allowlist=allowlist, stage=stage, request_options=request_options
        )
        return _response.data


class AsyncSuspiciousIpThrottlingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSuspiciousIpThrottlingClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSuspiciousIpThrottlingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSuspiciousIpThrottlingClient
        """
        return self._raw_client

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetSuspiciousIpThrottlingSettingsResponseContent:
        """
        Retrieve details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetSuspiciousIpThrottlingSettingsResponseContent
            Suspicious IP throttling configuration successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.suspicious_ip_throttling.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]] = OMIT,
        allowlist: typing.Optional[SuspiciousIpThrottlingAllowlist] = OMIT,
        stage: typing.Optional[SuspiciousIpThrottlingStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateSuspiciousIpThrottlingSettingsResponseContent:
        """
        Update the details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not suspicious IP throttling attack protections are active.

        shields : typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]]
            Action to take when a suspicious IP throttling threshold is violated.
                      Possible values: <code>block</code>, <code>admin_notification</code>.

        allowlist : typing.Optional[SuspiciousIpThrottlingAllowlist]

        stage : typing.Optional[SuspiciousIpThrottlingStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateSuspiciousIpThrottlingSettingsResponseContent
            Suspicious IP throttling configuration successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.attack_protection.suspicious_ip_throttling.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            enabled=enabled, shields=shields, allowlist=allowlist, stage=stage, request_options=request_options
        )
        return _response.data
