# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.get_suspicious_ip_throttling_settings_response_content import (
    GetSuspiciousIpThrottlingSettingsResponseContent,
)
from ...types.suspicious_ip_throttling_allowlist import SuspiciousIpThrottlingAllowlist
from ...types.suspicious_ip_throttling_shields_enum import SuspiciousIpThrottlingShieldsEnum
from ...types.suspicious_ip_throttling_stage import SuspiciousIpThrottlingStage
from ...types.update_suspicious_ip_throttling_settings_response_content import (
    UpdateSuspiciousIpThrottlingSettingsResponseContent,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSuspiciousIpThrottlingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetSuspiciousIpThrottlingSettingsResponseContent]:
        """
        Retrieve details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetSuspiciousIpThrottlingSettingsResponseContent]
            Suspicious IP throttling configuration successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/suspicious-ip-throttling",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetSuspiciousIpThrottlingSettingsResponseContent,
                    parse_obj_as(
                        type_=GetSuspiciousIpThrottlingSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]] = OMIT,
        allowlist: typing.Optional[SuspiciousIpThrottlingAllowlist] = OMIT,
        stage: typing.Optional[SuspiciousIpThrottlingStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateSuspiciousIpThrottlingSettingsResponseContent]:
        """
        Update the details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not suspicious IP throttling attack protections are active.

        shields : typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]]
            Action to take when a suspicious IP throttling threshold is violated.
                      Possible values: <code>block</code>, <code>admin_notification</code>.

        allowlist : typing.Optional[SuspiciousIpThrottlingAllowlist]

        stage : typing.Optional[SuspiciousIpThrottlingStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateSuspiciousIpThrottlingSettingsResponseContent]
            Suspicious IP throttling configuration successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            "attack-protection/suspicious-ip-throttling",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "allowlist": allowlist,
                "stage": convert_and_respect_annotation_metadata(
                    object_=stage, annotation=SuspiciousIpThrottlingStage, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateSuspiciousIpThrottlingSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateSuspiciousIpThrottlingSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSuspiciousIpThrottlingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetSuspiciousIpThrottlingSettingsResponseContent]:
        """
        Retrieve details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetSuspiciousIpThrottlingSettingsResponseContent]
            Suspicious IP throttling configuration successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/suspicious-ip-throttling",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetSuspiciousIpThrottlingSettingsResponseContent,
                    parse_obj_as(
                        type_=GetSuspiciousIpThrottlingSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        *,
        enabled: typing.Optional[bool] = OMIT,
        shields: typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]] = OMIT,
        allowlist: typing.Optional[SuspiciousIpThrottlingAllowlist] = OMIT,
        stage: typing.Optional[SuspiciousIpThrottlingStage] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateSuspiciousIpThrottlingSettingsResponseContent]:
        """
        Update the details of the Suspicious IP Throttling configuration of your tenant.

        Parameters
        ----------
        enabled : typing.Optional[bool]
            Whether or not suspicious IP throttling attack protections are active.

        shields : typing.Optional[typing.Sequence[SuspiciousIpThrottlingShieldsEnum]]
            Action to take when a suspicious IP throttling threshold is violated.
                      Possible values: <code>block</code>, <code>admin_notification</code>.

        allowlist : typing.Optional[SuspiciousIpThrottlingAllowlist]

        stage : typing.Optional[SuspiciousIpThrottlingStage]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateSuspiciousIpThrottlingSettingsResponseContent]
            Suspicious IP throttling configuration successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "attack-protection/suspicious-ip-throttling",
            method="PATCH",
            json={
                "enabled": enabled,
                "shields": shields,
                "allowlist": allowlist,
                "stage": convert_and_respect_annotation_metadata(
                    object_=stage, annotation=SuspiciousIpThrottlingStage, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateSuspiciousIpThrottlingSettingsResponseContent,
                    parse_obj_as(
                        type_=UpdateSuspiciousIpThrottlingSettingsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
