# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_branding_response_content import GetBrandingResponseContent
from ..types.update_branding_colors import UpdateBrandingColors
from ..types.update_branding_font import UpdateBrandingFont
from ..types.update_branding_response_content import UpdateBrandingResponseContent
from .raw_client import AsyncRawBrandingClient, RawBrandingClient

if typing.TYPE_CHECKING:
    from .phone.client import AsyncPhoneClient, PhoneClient
    from .templates.client import AsyncTemplatesClient, TemplatesClient
    from .themes.client import AsyncThemesClient, ThemesClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class BrandingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBrandingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._templates: typing.Optional[TemplatesClient] = None
        self._themes: typing.Optional[ThemesClient] = None
        self._phone: typing.Optional[PhoneClient] = None

    @property
    def with_raw_response(self) -> RawBrandingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBrandingClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetBrandingResponseContent:
        """
        Retrieve branding settings.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingResponseContent
            Branding settings successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def update(
        self,
        *,
        colors: typing.Optional[UpdateBrandingColors] = OMIT,
        favicon_url: typing.Optional[str] = OMIT,
        logo_url: typing.Optional[str] = OMIT,
        font: typing.Optional[UpdateBrandingFont] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingResponseContent:
        """
        Update branding settings.

        Parameters
        ----------
        colors : typing.Optional[UpdateBrandingColors]

        favicon_url : typing.Optional[str]
            URL for the favicon. Must use HTTPS.

        logo_url : typing.Optional[str]
            URL for the logo. Must use HTTPS.

        font : typing.Optional[UpdateBrandingFont]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingResponseContent
            Branding settings successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.update()
        """
        _response = self._raw_client.update(
            colors=colors, favicon_url=favicon_url, logo_url=logo_url, font=font, request_options=request_options
        )
        return _response.data

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import TemplatesClient  # noqa: E402

            self._templates = TemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates

    @property
    def themes(self):
        if self._themes is None:
            from .themes.client import ThemesClient  # noqa: E402

            self._themes = ThemesClient(client_wrapper=self._client_wrapper)
        return self._themes

    @property
    def phone(self):
        if self._phone is None:
            from .phone.client import PhoneClient  # noqa: E402

            self._phone = PhoneClient(client_wrapper=self._client_wrapper)
        return self._phone


class AsyncBrandingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBrandingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._templates: typing.Optional[AsyncTemplatesClient] = None
        self._themes: typing.Optional[AsyncThemesClient] = None
        self._phone: typing.Optional[AsyncPhoneClient] = None

    @property
    def with_raw_response(self) -> AsyncRawBrandingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBrandingClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetBrandingResponseContent:
        """
        Retrieve branding settings.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingResponseContent
            Branding settings successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.get()


        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def update(
        self,
        *,
        colors: typing.Optional[UpdateBrandingColors] = OMIT,
        favicon_url: typing.Optional[str] = OMIT,
        logo_url: typing.Optional[str] = OMIT,
        font: typing.Optional[UpdateBrandingFont] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingResponseContent:
        """
        Update branding settings.

        Parameters
        ----------
        colors : typing.Optional[UpdateBrandingColors]

        favicon_url : typing.Optional[str]
            URL for the favicon. Must use HTTPS.

        logo_url : typing.Optional[str]
            URL for the logo. Must use HTTPS.

        font : typing.Optional[UpdateBrandingFont]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingResponseContent
            Branding settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.update()


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            colors=colors, favicon_url=favicon_url, logo_url=logo_url, font=font, request_options=request_options
        )
        return _response.data

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import AsyncTemplatesClient  # noqa: E402

            self._templates = AsyncTemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates

    @property
    def themes(self):
        if self._themes is None:
            from .themes.client import AsyncThemesClient  # noqa: E402

            self._themes = AsyncThemesClient(client_wrapper=self._client_wrapper)
        return self._themes

    @property
    def phone(self):
        if self._phone is None:
            from .phone.client import AsyncPhoneClient  # noqa: E402

            self._phone = AsyncPhoneClient(client_wrapper=self._client_wrapper)
        return self._phone
