# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawPhoneClient, RawPhoneClient

if typing.TYPE_CHECKING:
    from .providers.client import AsyncProvidersClient, ProvidersClient
    from .templates.client import AsyncTemplatesClient, TemplatesClient


class PhoneClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPhoneClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._providers: typing.Optional[ProvidersClient] = None
        self._templates: typing.Optional[TemplatesClient] = None

    @property
    def with_raw_response(self) -> RawPhoneClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPhoneClient
        """
        return self._raw_client

    @property
    def providers(self):
        if self._providers is None:
            from .providers.client import ProvidersClient  # noqa: E402

            self._providers = ProvidersClient(client_wrapper=self._client_wrapper)
        return self._providers

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import TemplatesClient  # noqa: E402

            self._templates = TemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates


class AsyncPhoneClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPhoneClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._providers: typing.Optional[AsyncProvidersClient] = None
        self._templates: typing.Optional[AsyncTemplatesClient] = None

    @property
    def with_raw_response(self) -> AsyncRawPhoneClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPhoneClient
        """
        return self._raw_client

    @property
    def providers(self):
        if self._providers is None:
            from .providers.client import AsyncProvidersClient  # noqa: E402

            self._providers = AsyncProvidersClient(client_wrapper=self._client_wrapper)
        return self._providers

    @property
    def templates(self):
        if self._templates is None:
            from .templates.client import AsyncTemplatesClient  # noqa: E402

            self._templates = AsyncTemplatesClient(client_wrapper=self._client_wrapper)
        return self._templates
