# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.create_branding_phone_provider_response_content import CreateBrandingPhoneProviderResponseContent
from ....types.create_phone_provider_send_test_response_content import CreatePhoneProviderSendTestResponseContent
from ....types.get_branding_phone_provider_response_content import GetBrandingPhoneProviderResponseContent
from ....types.list_branding_phone_providers_response_content import ListBrandingPhoneProvidersResponseContent
from ....types.phone_provider_configuration import PhoneProviderConfiguration
from ....types.phone_provider_credentials import PhoneProviderCredentials
from ....types.phone_provider_delivery_method_enum import PhoneProviderDeliveryMethodEnum
from ....types.phone_provider_name_enum import PhoneProviderNameEnum
from ....types.update_branding_phone_provider_response_content import UpdateBrandingPhoneProviderResponseContent
from .raw_client import AsyncRawProvidersClient, RawProvidersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProvidersClient
        """
        return self._raw_client

    def list(
        self, *, disabled: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListBrandingPhoneProvidersResponseContent:
        """
        Retrieve a list of <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone providers</a> details set for a Tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListBrandingPhoneProvidersResponseContent
            Phone providers have been successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.list(
            disabled=True,
        )
        """
        _response = self._raw_client.list(disabled=disabled, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: PhoneProviderNameEnum,
        credentials: PhoneProviderCredentials,
        disabled: typing.Optional[bool] = OMIT,
        configuration: typing.Optional[PhoneProviderConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateBrandingPhoneProviderResponseContent:
        """
        Create a <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a>.
        The <code>credentials</code> object requires different properties depending on the phone provider (which is specified using the <code>name</code> property).

        Parameters
        ----------
        name : PhoneProviderNameEnum

        credentials : PhoneProviderCredentials

        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        configuration : typing.Optional[PhoneProviderConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateBrandingPhoneProviderResponseContent
            Phone notification provider successfully created.

        Examples
        --------
        from auth0 import Auth0, TwilioProviderCredentials

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.create(
            name="twilio",
            credentials=TwilioProviderCredentials(
                auth_token="auth_token",
            ),
        )
        """
        _response = self._raw_client.create(
            name=name,
            credentials=credentials,
            disabled=disabled,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingPhoneProviderResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a> details. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingPhoneProviderResponseContent
            Phone provider successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the configured phone provider.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[PhoneProviderNameEnum] = OMIT,
        disabled: typing.Optional[bool] = OMIT,
        credentials: typing.Optional[PhoneProviderCredentials] = OMIT,
        configuration: typing.Optional[PhoneProviderConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingPhoneProviderResponseContent:
        """
        Update a <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a>.
        The <code>credentials</code> object requires different properties depending on the phone provider (which is specified using the <code>name</code> property).

        Parameters
        ----------
        id : str

        name : typing.Optional[PhoneProviderNameEnum]

        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        credentials : typing.Optional[PhoneProviderCredentials]

        configuration : typing.Optional[PhoneProviderConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingPhoneProviderResponseContent
            Phone provider successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            disabled=disabled,
            credentials=credentials,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    def test(
        self,
        id: str,
        *,
        to: str,
        delivery_method: typing.Optional[PhoneProviderDeliveryMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneProviderSendTestResponseContent:
        """
        Parameters
        ----------
        id : str

        to : str
            The recipient phone number to receive a given notification.

        delivery_method : typing.Optional[PhoneProviderDeliveryMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneProviderSendTestResponseContent
            Phone notification sent.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.providers.test(
            id="id",
            to="to",
        )
        """
        _response = self._raw_client.test(id, to=to, delivery_method=delivery_method, request_options=request_options)
        return _response.data


class AsyncProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProvidersClient
        """
        return self._raw_client

    async def list(
        self, *, disabled: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListBrandingPhoneProvidersResponseContent:
        """
        Retrieve a list of <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone providers</a> details set for a Tenant. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListBrandingPhoneProvidersResponseContent
            Phone providers have been successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.list(
                disabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(disabled=disabled, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: PhoneProviderNameEnum,
        credentials: PhoneProviderCredentials,
        disabled: typing.Optional[bool] = OMIT,
        configuration: typing.Optional[PhoneProviderConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateBrandingPhoneProviderResponseContent:
        """
        Create a <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a>.
        The <code>credentials</code> object requires different properties depending on the phone provider (which is specified using the <code>name</code> property).

        Parameters
        ----------
        name : PhoneProviderNameEnum

        credentials : PhoneProviderCredentials

        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        configuration : typing.Optional[PhoneProviderConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateBrandingPhoneProviderResponseContent
            Phone notification provider successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, TwilioProviderCredentials

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.create(
                name="twilio",
                credentials=TwilioProviderCredentials(
                    auth_token="auth_token",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            credentials=credentials,
            disabled=disabled,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingPhoneProviderResponseContent:
        """
        Retrieve <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a> details. A list of fields to include or exclude may also be specified.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingPhoneProviderResponseContent
            Phone provider successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the configured phone provider.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[PhoneProviderNameEnum] = OMIT,
        disabled: typing.Optional[bool] = OMIT,
        credentials: typing.Optional[PhoneProviderCredentials] = OMIT,
        configuration: typing.Optional[PhoneProviderConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingPhoneProviderResponseContent:
        """
        Update a <a href="https://auth0.com/docs/customize/phone-messages/configure-phone-messaging-providers">phone provider</a>.
        The <code>credentials</code> object requires different properties depending on the phone provider (which is specified using the <code>name</code> property).

        Parameters
        ----------
        id : str

        name : typing.Optional[PhoneProviderNameEnum]

        disabled : typing.Optional[bool]
            Whether the provider is enabled (false) or disabled (true).

        credentials : typing.Optional[PhoneProviderCredentials]

        configuration : typing.Optional[PhoneProviderConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingPhoneProviderResponseContent
            Phone provider successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            disabled=disabled,
            credentials=credentials,
            configuration=configuration,
            request_options=request_options,
        )
        return _response.data

    async def test(
        self,
        id: str,
        *,
        to: str,
        delivery_method: typing.Optional[PhoneProviderDeliveryMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneProviderSendTestResponseContent:
        """
        Parameters
        ----------
        id : str

        to : str
            The recipient phone number to receive a given notification.

        delivery_method : typing.Optional[PhoneProviderDeliveryMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneProviderSendTestResponseContent
            Phone notification sent.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.providers.test(
                id="id",
                to="to",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.test(
            id, to=to, delivery_method=delivery_method, request_options=request_options
        )
        return _response.data
