# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.create_phone_template_response_content import CreatePhoneTemplateResponseContent
from ....types.create_phone_template_test_notification_response_content import (
    CreatePhoneTemplateTestNotificationResponseContent,
)
from ....types.get_phone_template_response_content import GetPhoneTemplateResponseContent
from ....types.list_phone_templates_response_content import ListPhoneTemplatesResponseContent
from ....types.partial_phone_template_content import PartialPhoneTemplateContent
from ....types.phone_provider_delivery_method_enum import PhoneProviderDeliveryMethodEnum
from ....types.phone_template_content import PhoneTemplateContent
from ....types.phone_template_notification_type_enum import PhoneTemplateNotificationTypeEnum
from ....types.reset_phone_template_request_content import ResetPhoneTemplateRequestContent
from ....types.reset_phone_template_response_content import ResetPhoneTemplateResponseContent
from ....types.update_phone_template_response_content import UpdatePhoneTemplateResponseContent
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def list(
        self, *, disabled: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListPhoneTemplatesResponseContent:
        """
        Parameters
        ----------
        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPhoneTemplatesResponseContent
            The phone notification templates were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.list(
            disabled=True,
        )
        """
        _response = self._raw_client.list(disabled=disabled, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        type: typing.Optional[PhoneTemplateNotificationTypeEnum] = OMIT,
        disabled: typing.Optional[bool] = False,
        content: typing.Optional[PhoneTemplateContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneTemplateResponseContent:
        """
        Parameters
        ----------
        type : typing.Optional[PhoneTemplateNotificationTypeEnum]

        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        content : typing.Optional[PhoneTemplateContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneTemplateResponseContent
            The phone notification template was created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.create()
        """
        _response = self._raw_client.create(
            type=type, disabled=disabled, content=content, request_options=request_options
        )
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetPhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPhoneTemplateResponseContent
            The phone notification template were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        content: typing.Optional[PartialPhoneTemplateContent] = OMIT,
        disabled: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdatePhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        content : typing.Optional[PartialPhoneTemplateContent]

        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdatePhoneTemplateResponseContent
            The phone notification template was updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.update(
            id="id",
        )
        """
        _response = self._raw_client.update(id, content=content, disabled=disabled, request_options=request_options)
        return _response.data

    def reset(
        self,
        id: str,
        *,
        request: ResetPhoneTemplateRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResetPhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        request : ResetPhoneTemplateRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResetPhoneTemplateResponseContent
            The phone notification template was reset.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.reset(
            id="id",
            request={"key": "value"},
        )
        """
        _response = self._raw_client.reset(id, request=request, request_options=request_options)
        return _response.data

    def test(
        self,
        id: str,
        *,
        to: str,
        delivery_method: typing.Optional[PhoneProviderDeliveryMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneTemplateTestNotificationResponseContent:
        """
        Parameters
        ----------
        id : str

        to : str
            Destination of the testing phone notification

        delivery_method : typing.Optional[PhoneProviderDeliveryMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneTemplateTestNotificationResponseContent
            The phone testing notification for the template was sent

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.phone.templates.test(
            id="id",
            to="to",
        )
        """
        _response = self._raw_client.test(id, to=to, delivery_method=delivery_method, request_options=request_options)
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def list(
        self, *, disabled: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListPhoneTemplatesResponseContent:
        """
        Parameters
        ----------
        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPhoneTemplatesResponseContent
            The phone notification templates were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.list(
                disabled=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(disabled=disabled, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        type: typing.Optional[PhoneTemplateNotificationTypeEnum] = OMIT,
        disabled: typing.Optional[bool] = False,
        content: typing.Optional[PhoneTemplateContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneTemplateResponseContent:
        """
        Parameters
        ----------
        type : typing.Optional[PhoneTemplateNotificationTypeEnum]

        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        content : typing.Optional[PhoneTemplateContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneTemplateResponseContent
            The phone notification template was created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.create()


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            type=type, disabled=disabled, content=content, request_options=request_options
        )
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetPhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetPhoneTemplateResponseContent
            The phone notification template were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        content: typing.Optional[PartialPhoneTemplateContent] = OMIT,
        disabled: typing.Optional[bool] = False,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdatePhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        content : typing.Optional[PartialPhoneTemplateContent]

        disabled : typing.Optional[bool]
            Whether the template is enabled (false) or disabled (true).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdatePhoneTemplateResponseContent
            The phone notification template was updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, content=content, disabled=disabled, request_options=request_options
        )
        return _response.data

    async def reset(
        self,
        id: str,
        *,
        request: ResetPhoneTemplateRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ResetPhoneTemplateResponseContent:
        """
        Parameters
        ----------
        id : str

        request : ResetPhoneTemplateRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ResetPhoneTemplateResponseContent
            The phone notification template was reset.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.reset(
                id="id",
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reset(id, request=request, request_options=request_options)
        return _response.data

    async def test(
        self,
        id: str,
        *,
        to: str,
        delivery_method: typing.Optional[PhoneProviderDeliveryMethodEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreatePhoneTemplateTestNotificationResponseContent:
        """
        Parameters
        ----------
        id : str

        to : str
            Destination of the testing phone notification

        delivery_method : typing.Optional[PhoneProviderDeliveryMethodEnum]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreatePhoneTemplateTestNotificationResponseContent
            The phone testing notification for the template was sent

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.phone.templates.test(
                id="id",
                to="to",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.test(
            id, to=to, delivery_method=delivery_method, request_options=request_options
        )
        return _response.data
