# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.get_universal_login_template_response_content import GetUniversalLoginTemplateResponseContent
from ...types.update_universal_login_template_request_content import UpdateUniversalLoginTemplateRequestContent
from .raw_client import AsyncRawTemplatesClient, RawTemplatesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTemplatesClient
        """
        return self._raw_client

    def get_universal_login(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUniversalLoginTemplateResponseContent:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUniversalLoginTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.templates.get_universal_login()
        """
        _response = self._raw_client.get_universal_login(request_options=request_options)
        return _response.data

    def update_universal_login(
        self,
        *,
        request: UpdateUniversalLoginTemplateRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update the Universal Login branding template.

        <p>When <code>content-type</code> header is set to <code>application/json</code>:</p>
        <pre>
        {
          "template": "&lt;!DOCTYPE html&gt;{% assign resolved_dir = dir | default: "auto" %}&lt;html lang="{{locale}}" dir="{{resolved_dir}}"&gt;&lt;head&gt;{%- auth0:head -%}&lt;/head&gt;&lt;body class="_widget-auto-layout"&gt;{%- auth0:widget -%}&lt;/body&gt;&lt;/html&gt;"
        }
        </pre>

        <p>
          When <code>content-type</code> header is set to <code>text/html</code>:
        </p>
        <pre>
        &lt!DOCTYPE html&gt;
        {% assign resolved_dir = dir | default: "auto" %}
        &lt;html lang="{{locale}}" dir="{{resolved_dir}}"&gt;
          &lt;head&gt;
            {%- auth0:head -%}
          &lt;/head&gt;
          &lt;body class="_widget-auto-layout"&gt;
            {%- auth0:widget -%}
          &lt;/body&gt;
        &lt;/html&gt;
        </pre>

        Parameters
        ----------
        request : UpdateUniversalLoginTemplateRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.templates.update_universal_login(
            request="string",
        )
        """
        _response = self._raw_client.update_universal_login(request=request, request_options=request_options)
        return _response.data

    def delete_universal_login(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.templates.delete_universal_login()
        """
        _response = self._raw_client.delete_universal_login(request_options=request_options)
        return _response.data


class AsyncTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTemplatesClient
        """
        return self._raw_client

    async def get_universal_login(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetUniversalLoginTemplateResponseContent:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetUniversalLoginTemplateResponseContent
            Template successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.templates.get_universal_login()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_universal_login(request_options=request_options)
        return _response.data

    async def update_universal_login(
        self,
        *,
        request: UpdateUniversalLoginTemplateRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Update the Universal Login branding template.

        <p>When <code>content-type</code> header is set to <code>application/json</code>:</p>
        <pre>
        {
          "template": "&lt;!DOCTYPE html&gt;{% assign resolved_dir = dir | default: "auto" %}&lt;html lang="{{locale}}" dir="{{resolved_dir}}"&gt;&lt;head&gt;{%- auth0:head -%}&lt;/head&gt;&lt;body class="_widget-auto-layout"&gt;{%- auth0:widget -%}&lt;/body&gt;&lt;/html&gt;"
        }
        </pre>

        <p>
          When <code>content-type</code> header is set to <code>text/html</code>:
        </p>
        <pre>
        &lt!DOCTYPE html&gt;
        {% assign resolved_dir = dir | default: "auto" %}
        &lt;html lang="{{locale}}" dir="{{resolved_dir}}"&gt;
          &lt;head&gt;
            {%- auth0:head -%}
          &lt;/head&gt;
          &lt;body class="_widget-auto-layout"&gt;
            {%- auth0:widget -%}
          &lt;/body&gt;
        &lt;/html&gt;
        </pre>

        Parameters
        ----------
        request : UpdateUniversalLoginTemplateRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.templates.update_universal_login(
                request="string",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_universal_login(request=request, request_options=request_options)
        return _response.data

    async def delete_universal_login(self, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.templates.delete_universal_login()


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_universal_login(request_options=request_options)
        return _response.data
