# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.branding_theme_borders import BrandingThemeBorders
from ...types.branding_theme_colors import BrandingThemeColors
from ...types.branding_theme_fonts import BrandingThemeFonts
from ...types.branding_theme_page_background import BrandingThemePageBackground
from ...types.branding_theme_widget import BrandingThemeWidget
from ...types.create_branding_theme_response_content import CreateBrandingThemeResponseContent
from ...types.get_branding_default_theme_response_content import GetBrandingDefaultThemeResponseContent
from ...types.get_branding_theme_response_content import GetBrandingThemeResponseContent
from ...types.update_branding_theme_response_content import UpdateBrandingThemeResponseContent
from .raw_client import AsyncRawThemesClient, RawThemesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ThemesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawThemesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawThemesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawThemesClient
        """
        return self._raw_client

    def create(
        self,
        *,
        borders: BrandingThemeBorders,
        colors: BrandingThemeColors,
        fonts: BrandingThemeFonts,
        page_background: BrandingThemePageBackground,
        widget: BrandingThemeWidget,
        display_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateBrandingThemeResponseContent:
        """
        Create branding theme.

        Parameters
        ----------
        borders : BrandingThemeBorders

        colors : BrandingThemeColors

        fonts : BrandingThemeFonts

        page_background : BrandingThemePageBackground

        widget : BrandingThemeWidget

        display_name : typing.Optional[str]
            Display Name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateBrandingThemeResponseContent
            Branding settings successfully updated.

        Examples
        --------
        from auth0 import (
            Auth0,
            BrandingThemeBorders,
            BrandingThemeColors,
            BrandingThemeFontBodyText,
            BrandingThemeFontButtonsText,
            BrandingThemeFontInputLabels,
            BrandingThemeFontLinks,
            BrandingThemeFonts,
            BrandingThemeFontSubtitle,
            BrandingThemeFontTitle,
            BrandingThemePageBackground,
            BrandingThemeWidget,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.themes.create(
            borders=BrandingThemeBorders(
                button_border_radius=1.1,
                button_border_weight=1.1,
                buttons_style="pill",
                input_border_radius=1.1,
                input_border_weight=1.1,
                inputs_style="pill",
                show_widget_shadow=True,
                widget_border_weight=1.1,
                widget_corner_radius=1.1,
            ),
            colors=BrandingThemeColors(
                body_text="body_text",
                error="error",
                header="header",
                icons="icons",
                input_background="input_background",
                input_border="input_border",
                input_filled_text="input_filled_text",
                input_labels_placeholders="input_labels_placeholders",
                links_focused_components="links_focused_components",
                primary_button="primary_button",
                primary_button_label="primary_button_label",
                secondary_button_border="secondary_button_border",
                secondary_button_label="secondary_button_label",
                success="success",
                widget_background="widget_background",
                widget_border="widget_border",
            ),
            fonts=BrandingThemeFonts(
                body_text=BrandingThemeFontBodyText(
                    bold=True,
                    size=1.1,
                ),
                buttons_text=BrandingThemeFontButtonsText(
                    bold=True,
                    size=1.1,
                ),
                font_url="font_url",
                input_labels=BrandingThemeFontInputLabels(
                    bold=True,
                    size=1.1,
                ),
                links=BrandingThemeFontLinks(
                    bold=True,
                    size=1.1,
                ),
                links_style="normal",
                reference_text_size=1.1,
                subtitle=BrandingThemeFontSubtitle(
                    bold=True,
                    size=1.1,
                ),
                title=BrandingThemeFontTitle(
                    bold=True,
                    size=1.1,
                ),
            ),
            page_background=BrandingThemePageBackground(
                background_color="background_color",
                background_image_url="background_image_url",
                page_layout="center",
            ),
            widget=BrandingThemeWidget(
                header_text_alignment="center",
                logo_height=1.1,
                logo_position="center",
                logo_url="logo_url",
                social_buttons_layout="bottom",
            ),
        )
        """
        _response = self._raw_client.create(
            borders=borders,
            colors=colors,
            fonts=fonts,
            page_background=page_background,
            widget=widget,
            display_name=display_name,
            request_options=request_options,
        )
        return _response.data

    def get_default(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingDefaultThemeResponseContent:
        """
        Retrieve default branding theme.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingDefaultThemeResponseContent
            Branding theme successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.themes.get_default()
        """
        _response = self._raw_client.get_default(request_options=request_options)
        return _response.data

    def get(
        self, theme_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingThemeResponseContent:
        """
        Retrieve branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingThemeResponseContent
            Branding theme successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.themes.get(
            theme_id="themeId",
        )
        """
        _response = self._raw_client.get(theme_id, request_options=request_options)
        return _response.data

    def delete(self, theme_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.themes.delete(
            theme_id="themeId",
        )
        """
        _response = self._raw_client.delete(theme_id, request_options=request_options)
        return _response.data

    def update(
        self,
        theme_id: str,
        *,
        borders: BrandingThemeBorders,
        colors: BrandingThemeColors,
        fonts: BrandingThemeFonts,
        page_background: BrandingThemePageBackground,
        widget: BrandingThemeWidget,
        display_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingThemeResponseContent:
        """
        Update branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        borders : BrandingThemeBorders

        colors : BrandingThemeColors

        fonts : BrandingThemeFonts

        page_background : BrandingThemePageBackground

        widget : BrandingThemeWidget

        display_name : typing.Optional[str]
            Display Name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingThemeResponseContent
            Branding settings successfully updated.

        Examples
        --------
        from auth0 import (
            Auth0,
            BrandingThemeBorders,
            BrandingThemeColors,
            BrandingThemeFontBodyText,
            BrandingThemeFontButtonsText,
            BrandingThemeFontInputLabels,
            BrandingThemeFontLinks,
            BrandingThemeFonts,
            BrandingThemeFontSubtitle,
            BrandingThemeFontTitle,
            BrandingThemePageBackground,
            BrandingThemeWidget,
        )

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.branding.themes.update(
            theme_id="themeId",
            borders=BrandingThemeBorders(
                button_border_radius=1.1,
                button_border_weight=1.1,
                buttons_style="pill",
                input_border_radius=1.1,
                input_border_weight=1.1,
                inputs_style="pill",
                show_widget_shadow=True,
                widget_border_weight=1.1,
                widget_corner_radius=1.1,
            ),
            colors=BrandingThemeColors(
                body_text="body_text",
                error="error",
                header="header",
                icons="icons",
                input_background="input_background",
                input_border="input_border",
                input_filled_text="input_filled_text",
                input_labels_placeholders="input_labels_placeholders",
                links_focused_components="links_focused_components",
                primary_button="primary_button",
                primary_button_label="primary_button_label",
                secondary_button_border="secondary_button_border",
                secondary_button_label="secondary_button_label",
                success="success",
                widget_background="widget_background",
                widget_border="widget_border",
            ),
            fonts=BrandingThemeFonts(
                body_text=BrandingThemeFontBodyText(
                    bold=True,
                    size=1.1,
                ),
                buttons_text=BrandingThemeFontButtonsText(
                    bold=True,
                    size=1.1,
                ),
                font_url="font_url",
                input_labels=BrandingThemeFontInputLabels(
                    bold=True,
                    size=1.1,
                ),
                links=BrandingThemeFontLinks(
                    bold=True,
                    size=1.1,
                ),
                links_style="normal",
                reference_text_size=1.1,
                subtitle=BrandingThemeFontSubtitle(
                    bold=True,
                    size=1.1,
                ),
                title=BrandingThemeFontTitle(
                    bold=True,
                    size=1.1,
                ),
            ),
            page_background=BrandingThemePageBackground(
                background_color="background_color",
                background_image_url="background_image_url",
                page_layout="center",
            ),
            widget=BrandingThemeWidget(
                header_text_alignment="center",
                logo_height=1.1,
                logo_position="center",
                logo_url="logo_url",
                social_buttons_layout="bottom",
            ),
        )
        """
        _response = self._raw_client.update(
            theme_id,
            borders=borders,
            colors=colors,
            fonts=fonts,
            page_background=page_background,
            widget=widget,
            display_name=display_name,
            request_options=request_options,
        )
        return _response.data


class AsyncThemesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawThemesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawThemesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawThemesClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        borders: BrandingThemeBorders,
        colors: BrandingThemeColors,
        fonts: BrandingThemeFonts,
        page_background: BrandingThemePageBackground,
        widget: BrandingThemeWidget,
        display_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateBrandingThemeResponseContent:
        """
        Create branding theme.

        Parameters
        ----------
        borders : BrandingThemeBorders

        colors : BrandingThemeColors

        fonts : BrandingThemeFonts

        page_background : BrandingThemePageBackground

        widget : BrandingThemeWidget

        display_name : typing.Optional[str]
            Display Name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateBrandingThemeResponseContent
            Branding settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            BrandingThemeBorders,
            BrandingThemeColors,
            BrandingThemeFontBodyText,
            BrandingThemeFontButtonsText,
            BrandingThemeFontInputLabels,
            BrandingThemeFontLinks,
            BrandingThemeFonts,
            BrandingThemeFontSubtitle,
            BrandingThemeFontTitle,
            BrandingThemePageBackground,
            BrandingThemeWidget,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.themes.create(
                borders=BrandingThemeBorders(
                    button_border_radius=1.1,
                    button_border_weight=1.1,
                    buttons_style="pill",
                    input_border_radius=1.1,
                    input_border_weight=1.1,
                    inputs_style="pill",
                    show_widget_shadow=True,
                    widget_border_weight=1.1,
                    widget_corner_radius=1.1,
                ),
                colors=BrandingThemeColors(
                    body_text="body_text",
                    error="error",
                    header="header",
                    icons="icons",
                    input_background="input_background",
                    input_border="input_border",
                    input_filled_text="input_filled_text",
                    input_labels_placeholders="input_labels_placeholders",
                    links_focused_components="links_focused_components",
                    primary_button="primary_button",
                    primary_button_label="primary_button_label",
                    secondary_button_border="secondary_button_border",
                    secondary_button_label="secondary_button_label",
                    success="success",
                    widget_background="widget_background",
                    widget_border="widget_border",
                ),
                fonts=BrandingThemeFonts(
                    body_text=BrandingThemeFontBodyText(
                        bold=True,
                        size=1.1,
                    ),
                    buttons_text=BrandingThemeFontButtonsText(
                        bold=True,
                        size=1.1,
                    ),
                    font_url="font_url",
                    input_labels=BrandingThemeFontInputLabels(
                        bold=True,
                        size=1.1,
                    ),
                    links=BrandingThemeFontLinks(
                        bold=True,
                        size=1.1,
                    ),
                    links_style="normal",
                    reference_text_size=1.1,
                    subtitle=BrandingThemeFontSubtitle(
                        bold=True,
                        size=1.1,
                    ),
                    title=BrandingThemeFontTitle(
                        bold=True,
                        size=1.1,
                    ),
                ),
                page_background=BrandingThemePageBackground(
                    background_color="background_color",
                    background_image_url="background_image_url",
                    page_layout="center",
                ),
                widget=BrandingThemeWidget(
                    header_text_alignment="center",
                    logo_height=1.1,
                    logo_position="center",
                    logo_url="logo_url",
                    social_buttons_layout="bottom",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            borders=borders,
            colors=colors,
            fonts=fonts,
            page_background=page_background,
            widget=widget,
            display_name=display_name,
            request_options=request_options,
        )
        return _response.data

    async def get_default(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingDefaultThemeResponseContent:
        """
        Retrieve default branding theme.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingDefaultThemeResponseContent
            Branding theme successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.themes.get_default()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_default(request_options=request_options)
        return _response.data

    async def get(
        self, theme_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetBrandingThemeResponseContent:
        """
        Retrieve branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetBrandingThemeResponseContent
            Branding theme successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.themes.get(
                theme_id="themeId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(theme_id, request_options=request_options)
        return _response.data

    async def delete(self, theme_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.themes.delete(
                theme_id="themeId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(theme_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        theme_id: str,
        *,
        borders: BrandingThemeBorders,
        colors: BrandingThemeColors,
        fonts: BrandingThemeFonts,
        page_background: BrandingThemePageBackground,
        widget: BrandingThemeWidget,
        display_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateBrandingThemeResponseContent:
        """
        Update branding theme.

        Parameters
        ----------
        theme_id : str
            The ID of the theme

        borders : BrandingThemeBorders

        colors : BrandingThemeColors

        fonts : BrandingThemeFonts

        page_background : BrandingThemePageBackground

        widget : BrandingThemeWidget

        display_name : typing.Optional[str]
            Display Name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateBrandingThemeResponseContent
            Branding settings successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import (
            AsyncAuth0,
            BrandingThemeBorders,
            BrandingThemeColors,
            BrandingThemeFontBodyText,
            BrandingThemeFontButtonsText,
            BrandingThemeFontInputLabels,
            BrandingThemeFontLinks,
            BrandingThemeFonts,
            BrandingThemeFontSubtitle,
            BrandingThemeFontTitle,
            BrandingThemePageBackground,
            BrandingThemeWidget,
        )

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.branding.themes.update(
                theme_id="themeId",
                borders=BrandingThemeBorders(
                    button_border_radius=1.1,
                    button_border_weight=1.1,
                    buttons_style="pill",
                    input_border_radius=1.1,
                    input_border_weight=1.1,
                    inputs_style="pill",
                    show_widget_shadow=True,
                    widget_border_weight=1.1,
                    widget_corner_radius=1.1,
                ),
                colors=BrandingThemeColors(
                    body_text="body_text",
                    error="error",
                    header="header",
                    icons="icons",
                    input_background="input_background",
                    input_border="input_border",
                    input_filled_text="input_filled_text",
                    input_labels_placeholders="input_labels_placeholders",
                    links_focused_components="links_focused_components",
                    primary_button="primary_button",
                    primary_button_label="primary_button_label",
                    secondary_button_border="secondary_button_border",
                    secondary_button_label="secondary_button_label",
                    success="success",
                    widget_background="widget_background",
                    widget_border="widget_border",
                ),
                fonts=BrandingThemeFonts(
                    body_text=BrandingThemeFontBodyText(
                        bold=True,
                        size=1.1,
                    ),
                    buttons_text=BrandingThemeFontButtonsText(
                        bold=True,
                        size=1.1,
                    ),
                    font_url="font_url",
                    input_labels=BrandingThemeFontInputLabels(
                        bold=True,
                        size=1.1,
                    ),
                    links=BrandingThemeFontLinks(
                        bold=True,
                        size=1.1,
                    ),
                    links_style="normal",
                    reference_text_size=1.1,
                    subtitle=BrandingThemeFontSubtitle(
                        bold=True,
                        size=1.1,
                    ),
                    title=BrandingThemeFontTitle(
                        bold=True,
                        size=1.1,
                    ),
                ),
                page_background=BrandingThemePageBackground(
                    background_color="background_color",
                    background_image_url="background_image_url",
                    page_layout="center",
                ),
                widget=BrandingThemeWidget(
                    header_text_alignment="center",
                    logo_height=1.1,
                    logo_position="center",
                    logo_url="logo_url",
                    social_buttons_layout="bottom",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            theme_id,
            borders=borders,
            colors=colors,
            fonts=fonts,
            page_background=page_background,
            widget=widget,
            display_name=display_name,
            request_options=request_options,
        )
        return _response.data
