# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import Auth0Environment

if typing.TYPE_CHECKING:
    from .actions.client import ActionsClient, AsyncActionsClient
    from .anomaly.client import AnomalyClient, AsyncAnomalyClient
    from .attack_protection.client import AsyncAttackProtectionClient, AttackProtectionClient
    from .branding.client import AsyncBrandingClient, BrandingClient
    from .client_grants.client import AsyncClientGrantsClient, ClientGrantsClient
    from .clients.client import AsyncClientsClient, ClientsClient
    from .connection_profiles.client import AsyncConnectionProfilesClient, ConnectionProfilesClient
    from .connections.client import AsyncConnectionsClient, ConnectionsClient
    from .custom_domains.client import AsyncCustomDomainsClient, CustomDomainsClient
    from .device_credentials.client import AsyncDeviceCredentialsClient, DeviceCredentialsClient
    from .email_templates.client import AsyncEmailTemplatesClient, EmailTemplatesClient
    from .emails.client import AsyncEmailsClient, EmailsClient
    from .event_streams.client import AsyncEventStreamsClient, EventStreamsClient
    from .flows.client import AsyncFlowsClient, FlowsClient
    from .forms.client import AsyncFormsClient, FormsClient
    from .guardian.client import AsyncGuardianClient, GuardianClient
    from .hooks.client import AsyncHooksClient, HooksClient
    from .jobs.client import AsyncJobsClient, JobsClient
    from .keys.client import AsyncKeysClient, KeysClient
    from .log_streams.client import AsyncLogStreamsClient, LogStreamsClient
    from .logs.client import AsyncLogsClient, LogsClient
    from .network_acls.client import AsyncNetworkAclsClient, NetworkAclsClient
    from .organizations.client import AsyncOrganizationsClient, OrganizationsClient
    from .prompts.client import AsyncPromptsClient, PromptsClient
    from .refresh_tokens.client import AsyncRefreshTokensClient, RefreshTokensClient
    from .resource_servers.client import AsyncResourceServersClient, ResourceServersClient
    from .risk_assessments.client import AsyncRiskAssessmentsClient, RiskAssessmentsClient
    from .roles.client import AsyncRolesClient, RolesClient
    from .rules.client import AsyncRulesClient, RulesClient
    from .rules_configs.client import AsyncRulesConfigsClient, RulesConfigsClient
    from .self_service_profiles.client import AsyncSelfServiceProfilesClient, SelfServiceProfilesClient
    from .sessions.client import AsyncSessionsClient, SessionsClient
    from .stats.client import AsyncStatsClient, StatsClient
    from .supplemental_signals.client import AsyncSupplementalSignalsClient, SupplementalSignalsClient
    from .tenants.client import AsyncTenantsClient, TenantsClient
    from .tickets.client import AsyncTicketsClient, TicketsClient
    from .token_exchange_profiles.client import AsyncTokenExchangeProfilesClient, TokenExchangeProfilesClient
    from .user_attribute_profiles.client import AsyncUserAttributeProfilesClient, UserAttributeProfilesClient
    from .user_blocks.client import AsyncUserBlocksClient, UserBlocksClient
    from .user_grants.client import AsyncUserGrantsClient, UserGrantsClient
    from .users.client import AsyncUsersClient, UsersClient
    from .verifiable_credentials.client import AsyncVerifiableCredentialsClient, VerifiableCredentialsClient


class Auth0:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : Auth0Environment
        The environment to use for requests from the client. from .environment import Auth0Environment



        Defaults to Auth0Environment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from auth0 import Auth0

    client = Auth0(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: Auth0Environment = Auth0Environment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._actions: typing.Optional[ActionsClient] = None
        self._branding: typing.Optional[BrandingClient] = None
        self._client_grants: typing.Optional[ClientGrantsClient] = None
        self._clients: typing.Optional[ClientsClient] = None
        self._connection_profiles: typing.Optional[ConnectionProfilesClient] = None
        self._connections: typing.Optional[ConnectionsClient] = None
        self._custom_domains: typing.Optional[CustomDomainsClient] = None
        self._device_credentials: typing.Optional[DeviceCredentialsClient] = None
        self._email_templates: typing.Optional[EmailTemplatesClient] = None
        self._event_streams: typing.Optional[EventStreamsClient] = None
        self._flows: typing.Optional[FlowsClient] = None
        self._forms: typing.Optional[FormsClient] = None
        self._user_grants: typing.Optional[UserGrantsClient] = None
        self._hooks: typing.Optional[HooksClient] = None
        self._jobs: typing.Optional[JobsClient] = None
        self._log_streams: typing.Optional[LogStreamsClient] = None
        self._logs: typing.Optional[LogsClient] = None
        self._network_acls: typing.Optional[NetworkAclsClient] = None
        self._organizations: typing.Optional[OrganizationsClient] = None
        self._prompts: typing.Optional[PromptsClient] = None
        self._refresh_tokens: typing.Optional[RefreshTokensClient] = None
        self._resource_servers: typing.Optional[ResourceServersClient] = None
        self._roles: typing.Optional[RolesClient] = None
        self._rules: typing.Optional[RulesClient] = None
        self._rules_configs: typing.Optional[RulesConfigsClient] = None
        self._self_service_profiles: typing.Optional[SelfServiceProfilesClient] = None
        self._sessions: typing.Optional[SessionsClient] = None
        self._stats: typing.Optional[StatsClient] = None
        self._supplemental_signals: typing.Optional[SupplementalSignalsClient] = None
        self._tickets: typing.Optional[TicketsClient] = None
        self._token_exchange_profiles: typing.Optional[TokenExchangeProfilesClient] = None
        self._user_attribute_profiles: typing.Optional[UserAttributeProfilesClient] = None
        self._user_blocks: typing.Optional[UserBlocksClient] = None
        self._users: typing.Optional[UsersClient] = None
        self._anomaly: typing.Optional[AnomalyClient] = None
        self._attack_protection: typing.Optional[AttackProtectionClient] = None
        self._emails: typing.Optional[EmailsClient] = None
        self._guardian: typing.Optional[GuardianClient] = None
        self._keys: typing.Optional[KeysClient] = None
        self._risk_assessments: typing.Optional[RiskAssessmentsClient] = None
        self._tenants: typing.Optional[TenantsClient] = None
        self._verifiable_credentials: typing.Optional[VerifiableCredentialsClient] = None

    @property
    def actions(self):
        if self._actions is None:
            from .actions.client import ActionsClient  # noqa: E402

            self._actions = ActionsClient(client_wrapper=self._client_wrapper)
        return self._actions

    @property
    def branding(self):
        if self._branding is None:
            from .branding.client import BrandingClient  # noqa: E402

            self._branding = BrandingClient(client_wrapper=self._client_wrapper)
        return self._branding

    @property
    def client_grants(self):
        if self._client_grants is None:
            from .client_grants.client import ClientGrantsClient  # noqa: E402

            self._client_grants = ClientGrantsClient(client_wrapper=self._client_wrapper)
        return self._client_grants

    @property
    def clients(self):
        if self._clients is None:
            from .clients.client import ClientsClient  # noqa: E402

            self._clients = ClientsClient(client_wrapper=self._client_wrapper)
        return self._clients

    @property
    def connection_profiles(self):
        if self._connection_profiles is None:
            from .connection_profiles.client import ConnectionProfilesClient  # noqa: E402

            self._connection_profiles = ConnectionProfilesClient(client_wrapper=self._client_wrapper)
        return self._connection_profiles

    @property
    def connections(self):
        if self._connections is None:
            from .connections.client import ConnectionsClient  # noqa: E402

            self._connections = ConnectionsClient(client_wrapper=self._client_wrapper)
        return self._connections

    @property
    def custom_domains(self):
        if self._custom_domains is None:
            from .custom_domains.client import CustomDomainsClient  # noqa: E402

            self._custom_domains = CustomDomainsClient(client_wrapper=self._client_wrapper)
        return self._custom_domains

    @property
    def device_credentials(self):
        if self._device_credentials is None:
            from .device_credentials.client import DeviceCredentialsClient  # noqa: E402

            self._device_credentials = DeviceCredentialsClient(client_wrapper=self._client_wrapper)
        return self._device_credentials

    @property
    def email_templates(self):
        if self._email_templates is None:
            from .email_templates.client import EmailTemplatesClient  # noqa: E402

            self._email_templates = EmailTemplatesClient(client_wrapper=self._client_wrapper)
        return self._email_templates

    @property
    def event_streams(self):
        if self._event_streams is None:
            from .event_streams.client import EventStreamsClient  # noqa: E402

            self._event_streams = EventStreamsClient(client_wrapper=self._client_wrapper)
        return self._event_streams

    @property
    def flows(self):
        if self._flows is None:
            from .flows.client import FlowsClient  # noqa: E402

            self._flows = FlowsClient(client_wrapper=self._client_wrapper)
        return self._flows

    @property
    def forms(self):
        if self._forms is None:
            from .forms.client import FormsClient  # noqa: E402

            self._forms = FormsClient(client_wrapper=self._client_wrapper)
        return self._forms

    @property
    def user_grants(self):
        if self._user_grants is None:
            from .user_grants.client import UserGrantsClient  # noqa: E402

            self._user_grants = UserGrantsClient(client_wrapper=self._client_wrapper)
        return self._user_grants

    @property
    def hooks(self):
        if self._hooks is None:
            from .hooks.client import HooksClient  # noqa: E402

            self._hooks = HooksClient(client_wrapper=self._client_wrapper)
        return self._hooks

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import JobsClient  # noqa: E402

            self._jobs = JobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def log_streams(self):
        if self._log_streams is None:
            from .log_streams.client import LogStreamsClient  # noqa: E402

            self._log_streams = LogStreamsClient(client_wrapper=self._client_wrapper)
        return self._log_streams

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import LogsClient  # noqa: E402

            self._logs = LogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def network_acls(self):
        if self._network_acls is None:
            from .network_acls.client import NetworkAclsClient  # noqa: E402

            self._network_acls = NetworkAclsClient(client_wrapper=self._client_wrapper)
        return self._network_acls

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import OrganizationsClient  # noqa: E402

            self._organizations = OrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations

    @property
    def prompts(self):
        if self._prompts is None:
            from .prompts.client import PromptsClient  # noqa: E402

            self._prompts = PromptsClient(client_wrapper=self._client_wrapper)
        return self._prompts

    @property
    def refresh_tokens(self):
        if self._refresh_tokens is None:
            from .refresh_tokens.client import RefreshTokensClient  # noqa: E402

            self._refresh_tokens = RefreshTokensClient(client_wrapper=self._client_wrapper)
        return self._refresh_tokens

    @property
    def resource_servers(self):
        if self._resource_servers is None:
            from .resource_servers.client import ResourceServersClient  # noqa: E402

            self._resource_servers = ResourceServersClient(client_wrapper=self._client_wrapper)
        return self._resource_servers

    @property
    def roles(self):
        if self._roles is None:
            from .roles.client import RolesClient  # noqa: E402

            self._roles = RolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def rules(self):
        if self._rules is None:
            from .rules.client import RulesClient  # noqa: E402

            self._rules = RulesClient(client_wrapper=self._client_wrapper)
        return self._rules

    @property
    def rules_configs(self):
        if self._rules_configs is None:
            from .rules_configs.client import RulesConfigsClient  # noqa: E402

            self._rules_configs = RulesConfigsClient(client_wrapper=self._client_wrapper)
        return self._rules_configs

    @property
    def self_service_profiles(self):
        if self._self_service_profiles is None:
            from .self_service_profiles.client import SelfServiceProfilesClient  # noqa: E402

            self._self_service_profiles = SelfServiceProfilesClient(client_wrapper=self._client_wrapper)
        return self._self_service_profiles

    @property
    def sessions(self):
        if self._sessions is None:
            from .sessions.client import SessionsClient  # noqa: E402

            self._sessions = SessionsClient(client_wrapper=self._client_wrapper)
        return self._sessions

    @property
    def stats(self):
        if self._stats is None:
            from .stats.client import StatsClient  # noqa: E402

            self._stats = StatsClient(client_wrapper=self._client_wrapper)
        return self._stats

    @property
    def supplemental_signals(self):
        if self._supplemental_signals is None:
            from .supplemental_signals.client import SupplementalSignalsClient  # noqa: E402

            self._supplemental_signals = SupplementalSignalsClient(client_wrapper=self._client_wrapper)
        return self._supplemental_signals

    @property
    def tickets(self):
        if self._tickets is None:
            from .tickets.client import TicketsClient  # noqa: E402

            self._tickets = TicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def token_exchange_profiles(self):
        if self._token_exchange_profiles is None:
            from .token_exchange_profiles.client import TokenExchangeProfilesClient  # noqa: E402

            self._token_exchange_profiles = TokenExchangeProfilesClient(client_wrapper=self._client_wrapper)
        return self._token_exchange_profiles

    @property
    def user_attribute_profiles(self):
        if self._user_attribute_profiles is None:
            from .user_attribute_profiles.client import UserAttributeProfilesClient  # noqa: E402

            self._user_attribute_profiles = UserAttributeProfilesClient(client_wrapper=self._client_wrapper)
        return self._user_attribute_profiles

    @property
    def user_blocks(self):
        if self._user_blocks is None:
            from .user_blocks.client import UserBlocksClient  # noqa: E402

            self._user_blocks = UserBlocksClient(client_wrapper=self._client_wrapper)
        return self._user_blocks

    @property
    def users(self):
        if self._users is None:
            from .users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def anomaly(self):
        if self._anomaly is None:
            from .anomaly.client import AnomalyClient  # noqa: E402

            self._anomaly = AnomalyClient(client_wrapper=self._client_wrapper)
        return self._anomaly

    @property
    def attack_protection(self):
        if self._attack_protection is None:
            from .attack_protection.client import AttackProtectionClient  # noqa: E402

            self._attack_protection = AttackProtectionClient(client_wrapper=self._client_wrapper)
        return self._attack_protection

    @property
    def emails(self):
        if self._emails is None:
            from .emails.client import EmailsClient  # noqa: E402

            self._emails = EmailsClient(client_wrapper=self._client_wrapper)
        return self._emails

    @property
    def guardian(self):
        if self._guardian is None:
            from .guardian.client import GuardianClient  # noqa: E402

            self._guardian = GuardianClient(client_wrapper=self._client_wrapper)
        return self._guardian

    @property
    def keys(self):
        if self._keys is None:
            from .keys.client import KeysClient  # noqa: E402

            self._keys = KeysClient(client_wrapper=self._client_wrapper)
        return self._keys

    @property
    def risk_assessments(self):
        if self._risk_assessments is None:
            from .risk_assessments.client import RiskAssessmentsClient  # noqa: E402

            self._risk_assessments = RiskAssessmentsClient(client_wrapper=self._client_wrapper)
        return self._risk_assessments

    @property
    def tenants(self):
        if self._tenants is None:
            from .tenants.client import TenantsClient  # noqa: E402

            self._tenants = TenantsClient(client_wrapper=self._client_wrapper)
        return self._tenants

    @property
    def verifiable_credentials(self):
        if self._verifiable_credentials is None:
            from .verifiable_credentials.client import VerifiableCredentialsClient  # noqa: E402

            self._verifiable_credentials = VerifiableCredentialsClient(client_wrapper=self._client_wrapper)
        return self._verifiable_credentials


class AsyncAuth0:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : Auth0Environment
        The environment to use for requests from the client. from .environment import Auth0Environment



        Defaults to Auth0Environment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from auth0 import AsyncAuth0

    client = AsyncAuth0(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: Auth0Environment = Auth0Environment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._actions: typing.Optional[AsyncActionsClient] = None
        self._branding: typing.Optional[AsyncBrandingClient] = None
        self._client_grants: typing.Optional[AsyncClientGrantsClient] = None
        self._clients: typing.Optional[AsyncClientsClient] = None
        self._connection_profiles: typing.Optional[AsyncConnectionProfilesClient] = None
        self._connections: typing.Optional[AsyncConnectionsClient] = None
        self._custom_domains: typing.Optional[AsyncCustomDomainsClient] = None
        self._device_credentials: typing.Optional[AsyncDeviceCredentialsClient] = None
        self._email_templates: typing.Optional[AsyncEmailTemplatesClient] = None
        self._event_streams: typing.Optional[AsyncEventStreamsClient] = None
        self._flows: typing.Optional[AsyncFlowsClient] = None
        self._forms: typing.Optional[AsyncFormsClient] = None
        self._user_grants: typing.Optional[AsyncUserGrantsClient] = None
        self._hooks: typing.Optional[AsyncHooksClient] = None
        self._jobs: typing.Optional[AsyncJobsClient] = None
        self._log_streams: typing.Optional[AsyncLogStreamsClient] = None
        self._logs: typing.Optional[AsyncLogsClient] = None
        self._network_acls: typing.Optional[AsyncNetworkAclsClient] = None
        self._organizations: typing.Optional[AsyncOrganizationsClient] = None
        self._prompts: typing.Optional[AsyncPromptsClient] = None
        self._refresh_tokens: typing.Optional[AsyncRefreshTokensClient] = None
        self._resource_servers: typing.Optional[AsyncResourceServersClient] = None
        self._roles: typing.Optional[AsyncRolesClient] = None
        self._rules: typing.Optional[AsyncRulesClient] = None
        self._rules_configs: typing.Optional[AsyncRulesConfigsClient] = None
        self._self_service_profiles: typing.Optional[AsyncSelfServiceProfilesClient] = None
        self._sessions: typing.Optional[AsyncSessionsClient] = None
        self._stats: typing.Optional[AsyncStatsClient] = None
        self._supplemental_signals: typing.Optional[AsyncSupplementalSignalsClient] = None
        self._tickets: typing.Optional[AsyncTicketsClient] = None
        self._token_exchange_profiles: typing.Optional[AsyncTokenExchangeProfilesClient] = None
        self._user_attribute_profiles: typing.Optional[AsyncUserAttributeProfilesClient] = None
        self._user_blocks: typing.Optional[AsyncUserBlocksClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None
        self._anomaly: typing.Optional[AsyncAnomalyClient] = None
        self._attack_protection: typing.Optional[AsyncAttackProtectionClient] = None
        self._emails: typing.Optional[AsyncEmailsClient] = None
        self._guardian: typing.Optional[AsyncGuardianClient] = None
        self._keys: typing.Optional[AsyncKeysClient] = None
        self._risk_assessments: typing.Optional[AsyncRiskAssessmentsClient] = None
        self._tenants: typing.Optional[AsyncTenantsClient] = None
        self._verifiable_credentials: typing.Optional[AsyncVerifiableCredentialsClient] = None

    @property
    def actions(self):
        if self._actions is None:
            from .actions.client import AsyncActionsClient  # noqa: E402

            self._actions = AsyncActionsClient(client_wrapper=self._client_wrapper)
        return self._actions

    @property
    def branding(self):
        if self._branding is None:
            from .branding.client import AsyncBrandingClient  # noqa: E402

            self._branding = AsyncBrandingClient(client_wrapper=self._client_wrapper)
        return self._branding

    @property
    def client_grants(self):
        if self._client_grants is None:
            from .client_grants.client import AsyncClientGrantsClient  # noqa: E402

            self._client_grants = AsyncClientGrantsClient(client_wrapper=self._client_wrapper)
        return self._client_grants

    @property
    def clients(self):
        if self._clients is None:
            from .clients.client import AsyncClientsClient  # noqa: E402

            self._clients = AsyncClientsClient(client_wrapper=self._client_wrapper)
        return self._clients

    @property
    def connection_profiles(self):
        if self._connection_profiles is None:
            from .connection_profiles.client import AsyncConnectionProfilesClient  # noqa: E402

            self._connection_profiles = AsyncConnectionProfilesClient(client_wrapper=self._client_wrapper)
        return self._connection_profiles

    @property
    def connections(self):
        if self._connections is None:
            from .connections.client import AsyncConnectionsClient  # noqa: E402

            self._connections = AsyncConnectionsClient(client_wrapper=self._client_wrapper)
        return self._connections

    @property
    def custom_domains(self):
        if self._custom_domains is None:
            from .custom_domains.client import AsyncCustomDomainsClient  # noqa: E402

            self._custom_domains = AsyncCustomDomainsClient(client_wrapper=self._client_wrapper)
        return self._custom_domains

    @property
    def device_credentials(self):
        if self._device_credentials is None:
            from .device_credentials.client import AsyncDeviceCredentialsClient  # noqa: E402

            self._device_credentials = AsyncDeviceCredentialsClient(client_wrapper=self._client_wrapper)
        return self._device_credentials

    @property
    def email_templates(self):
        if self._email_templates is None:
            from .email_templates.client import AsyncEmailTemplatesClient  # noqa: E402

            self._email_templates = AsyncEmailTemplatesClient(client_wrapper=self._client_wrapper)
        return self._email_templates

    @property
    def event_streams(self):
        if self._event_streams is None:
            from .event_streams.client import AsyncEventStreamsClient  # noqa: E402

            self._event_streams = AsyncEventStreamsClient(client_wrapper=self._client_wrapper)
        return self._event_streams

    @property
    def flows(self):
        if self._flows is None:
            from .flows.client import AsyncFlowsClient  # noqa: E402

            self._flows = AsyncFlowsClient(client_wrapper=self._client_wrapper)
        return self._flows

    @property
    def forms(self):
        if self._forms is None:
            from .forms.client import AsyncFormsClient  # noqa: E402

            self._forms = AsyncFormsClient(client_wrapper=self._client_wrapper)
        return self._forms

    @property
    def user_grants(self):
        if self._user_grants is None:
            from .user_grants.client import AsyncUserGrantsClient  # noqa: E402

            self._user_grants = AsyncUserGrantsClient(client_wrapper=self._client_wrapper)
        return self._user_grants

    @property
    def hooks(self):
        if self._hooks is None:
            from .hooks.client import AsyncHooksClient  # noqa: E402

            self._hooks = AsyncHooksClient(client_wrapper=self._client_wrapper)
        return self._hooks

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import AsyncJobsClient  # noqa: E402

            self._jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def log_streams(self):
        if self._log_streams is None:
            from .log_streams.client import AsyncLogStreamsClient  # noqa: E402

            self._log_streams = AsyncLogStreamsClient(client_wrapper=self._client_wrapper)
        return self._log_streams

    @property
    def logs(self):
        if self._logs is None:
            from .logs.client import AsyncLogsClient  # noqa: E402

            self._logs = AsyncLogsClient(client_wrapper=self._client_wrapper)
        return self._logs

    @property
    def network_acls(self):
        if self._network_acls is None:
            from .network_acls.client import AsyncNetworkAclsClient  # noqa: E402

            self._network_acls = AsyncNetworkAclsClient(client_wrapper=self._client_wrapper)
        return self._network_acls

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import AsyncOrganizationsClient  # noqa: E402

            self._organizations = AsyncOrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations

    @property
    def prompts(self):
        if self._prompts is None:
            from .prompts.client import AsyncPromptsClient  # noqa: E402

            self._prompts = AsyncPromptsClient(client_wrapper=self._client_wrapper)
        return self._prompts

    @property
    def refresh_tokens(self):
        if self._refresh_tokens is None:
            from .refresh_tokens.client import AsyncRefreshTokensClient  # noqa: E402

            self._refresh_tokens = AsyncRefreshTokensClient(client_wrapper=self._client_wrapper)
        return self._refresh_tokens

    @property
    def resource_servers(self):
        if self._resource_servers is None:
            from .resource_servers.client import AsyncResourceServersClient  # noqa: E402

            self._resource_servers = AsyncResourceServersClient(client_wrapper=self._client_wrapper)
        return self._resource_servers

    @property
    def roles(self):
        if self._roles is None:
            from .roles.client import AsyncRolesClient  # noqa: E402

            self._roles = AsyncRolesClient(client_wrapper=self._client_wrapper)
        return self._roles

    @property
    def rules(self):
        if self._rules is None:
            from .rules.client import AsyncRulesClient  # noqa: E402

            self._rules = AsyncRulesClient(client_wrapper=self._client_wrapper)
        return self._rules

    @property
    def rules_configs(self):
        if self._rules_configs is None:
            from .rules_configs.client import AsyncRulesConfigsClient  # noqa: E402

            self._rules_configs = AsyncRulesConfigsClient(client_wrapper=self._client_wrapper)
        return self._rules_configs

    @property
    def self_service_profiles(self):
        if self._self_service_profiles is None:
            from .self_service_profiles.client import AsyncSelfServiceProfilesClient  # noqa: E402

            self._self_service_profiles = AsyncSelfServiceProfilesClient(client_wrapper=self._client_wrapper)
        return self._self_service_profiles

    @property
    def sessions(self):
        if self._sessions is None:
            from .sessions.client import AsyncSessionsClient  # noqa: E402

            self._sessions = AsyncSessionsClient(client_wrapper=self._client_wrapper)
        return self._sessions

    @property
    def stats(self):
        if self._stats is None:
            from .stats.client import AsyncStatsClient  # noqa: E402

            self._stats = AsyncStatsClient(client_wrapper=self._client_wrapper)
        return self._stats

    @property
    def supplemental_signals(self):
        if self._supplemental_signals is None:
            from .supplemental_signals.client import AsyncSupplementalSignalsClient  # noqa: E402

            self._supplemental_signals = AsyncSupplementalSignalsClient(client_wrapper=self._client_wrapper)
        return self._supplemental_signals

    @property
    def tickets(self):
        if self._tickets is None:
            from .tickets.client import AsyncTicketsClient  # noqa: E402

            self._tickets = AsyncTicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def token_exchange_profiles(self):
        if self._token_exchange_profiles is None:
            from .token_exchange_profiles.client import AsyncTokenExchangeProfilesClient  # noqa: E402

            self._token_exchange_profiles = AsyncTokenExchangeProfilesClient(client_wrapper=self._client_wrapper)
        return self._token_exchange_profiles

    @property
    def user_attribute_profiles(self):
        if self._user_attribute_profiles is None:
            from .user_attribute_profiles.client import AsyncUserAttributeProfilesClient  # noqa: E402

            self._user_attribute_profiles = AsyncUserAttributeProfilesClient(client_wrapper=self._client_wrapper)
        return self._user_attribute_profiles

    @property
    def user_blocks(self):
        if self._user_blocks is None:
            from .user_blocks.client import AsyncUserBlocksClient  # noqa: E402

            self._user_blocks = AsyncUserBlocksClient(client_wrapper=self._client_wrapper)
        return self._user_blocks

    @property
    def users(self):
        if self._users is None:
            from .users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users

    @property
    def anomaly(self):
        if self._anomaly is None:
            from .anomaly.client import AsyncAnomalyClient  # noqa: E402

            self._anomaly = AsyncAnomalyClient(client_wrapper=self._client_wrapper)
        return self._anomaly

    @property
    def attack_protection(self):
        if self._attack_protection is None:
            from .attack_protection.client import AsyncAttackProtectionClient  # noqa: E402

            self._attack_protection = AsyncAttackProtectionClient(client_wrapper=self._client_wrapper)
        return self._attack_protection

    @property
    def emails(self):
        if self._emails is None:
            from .emails.client import AsyncEmailsClient  # noqa: E402

            self._emails = AsyncEmailsClient(client_wrapper=self._client_wrapper)
        return self._emails

    @property
    def guardian(self):
        if self._guardian is None:
            from .guardian.client import AsyncGuardianClient  # noqa: E402

            self._guardian = AsyncGuardianClient(client_wrapper=self._client_wrapper)
        return self._guardian

    @property
    def keys(self):
        if self._keys is None:
            from .keys.client import AsyncKeysClient  # noqa: E402

            self._keys = AsyncKeysClient(client_wrapper=self._client_wrapper)
        return self._keys

    @property
    def risk_assessments(self):
        if self._risk_assessments is None:
            from .risk_assessments.client import AsyncRiskAssessmentsClient  # noqa: E402

            self._risk_assessments = AsyncRiskAssessmentsClient(client_wrapper=self._client_wrapper)
        return self._risk_assessments

    @property
    def tenants(self):
        if self._tenants is None:
            from .tenants.client import AsyncTenantsClient  # noqa: E402

            self._tenants = AsyncTenantsClient(client_wrapper=self._client_wrapper)
        return self._tenants

    @property
    def verifiable_credentials(self):
        if self._verifiable_credentials is None:
            from .verifiable_credentials.client import AsyncVerifiableCredentialsClient  # noqa: E402

            self._verifiable_credentials = AsyncVerifiableCredentialsClient(client_wrapper=self._client_wrapper)
        return self._verifiable_credentials


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: Auth0Environment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
