# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.client_grant_allow_any_organization_enum import ClientGrantAllowAnyOrganizationEnum
from ..types.client_grant_organization_nullable_usage_enum import ClientGrantOrganizationNullableUsageEnum
from ..types.client_grant_organization_usage_enum import ClientGrantOrganizationUsageEnum
from ..types.client_grant_response_content import ClientGrantResponseContent
from ..types.client_grant_subject_type_enum import ClientGrantSubjectTypeEnum
from ..types.create_client_grant_response_content import CreateClientGrantResponseContent
from ..types.list_client_grant_paginated_response_content import ListClientGrantPaginatedResponseContent
from ..types.update_client_grant_response_content import UpdateClientGrantResponseContent
from .raw_client import AsyncRawClientGrantsClient, RawClientGrantsClient

if typing.TYPE_CHECKING:
    from .organizations.client import AsyncOrganizationsClient, OrganizationsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ClientGrantsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawClientGrantsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._organizations: typing.Optional[OrganizationsClient] = None

    @property
    def with_raw_response(self) -> RawClientGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawClientGrantsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        audience: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        allow_any_organization: typing.Optional[ClientGrantAllowAnyOrganizationEnum] = None,
        subject_type: typing.Optional[ClientGrantSubjectTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ClientGrantResponseContent, ListClientGrantPaginatedResponseContent]:
        """
        Retrieve a list of <a href="https://auth0.com/docs/get-started/applications/application-access-to-apis-client-grants">client grants</a>, including the scopes associated with the application/API pair.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        audience : typing.Optional[str]
            Optional filter on audience.

        client_id : typing.Optional[str]
            Optional filter on client_id.

        allow_any_organization : typing.Optional[ClientGrantAllowAnyOrganizationEnum]
            Optional filter on allow_any_organization.

        subject_type : typing.Optional[ClientGrantSubjectTypeEnum]
            The type of application access the client grant allows. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href="https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ClientGrantResponseContent, ListClientGrantPaginatedResponseContent]
            Client grants successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.client_grants.list(
            from_="from",
            take=1,
            audience="audience",
            client_id="client_id",
            allow_any_organization=True,
            subject_type="client",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            from_=from_,
            take=take,
            audience=audience,
            client_id=client_id,
            allow_any_organization=allow_any_organization,
            subject_type=subject_type,
            request_options=request_options,
        )

    def create(
        self,
        *,
        client_id: str,
        audience: str,
        organization_usage: typing.Optional[ClientGrantOrganizationUsageEnum] = OMIT,
        allow_any_organization: typing.Optional[bool] = False,
        scope: typing.Optional[typing.Sequence[str]] = OMIT,
        subject_type: typing.Optional[ClientGrantSubjectTypeEnum] = OMIT,
        authorization_details_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateClientGrantResponseContent:
        """
        Create a client grant for a machine-to-machine login flow. To learn more, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        audience : str
            The audience (API identifier) of this client grant

        organization_usage : typing.Optional[ClientGrantOrganizationUsageEnum]

        allow_any_organization : typing.Optional[bool]
            If enabled, any organization can be used with this grant. If disabled (default), the grant must be explicitly assigned to the desired organizations.

        scope : typing.Optional[typing.Sequence[str]]
            Scopes allowed for this client grant.

        subject_type : typing.Optional[ClientGrantSubjectTypeEnum]

        authorization_details_types : typing.Optional[typing.Sequence[str]]
            Types of authorization_details allowed for this client grant. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href= "https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateClientGrantResponseContent
            Client grant successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.client_grants.create(
            client_id="client_id",
            audience="audience",
        )
        """
        _response = self._raw_client.create(
            client_id=client_id,
            audience=audience,
            organization_usage=organization_usage,
            allow_any_organization=allow_any_organization,
            scope=scope,
            subject_type=subject_type,
            authorization_details_types=authorization_details_types,
            request_options=request_options,
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a> from your machine-to-machine application.

        Parameters
        ----------
        id : str
            ID of the client grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.client_grants.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        scope: typing.Optional[typing.Sequence[str]] = OMIT,
        organization_usage: typing.Optional[ClientGrantOrganizationNullableUsageEnum] = OMIT,
        allow_any_organization: typing.Optional[bool] = OMIT,
        authorization_details_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateClientGrantResponseContent:
        """
        Update a client grant.

        Parameters
        ----------
        id : str
            ID of the client grant to update.

        scope : typing.Optional[typing.Sequence[str]]
            Scopes allowed for this client grant.

        organization_usage : typing.Optional[ClientGrantOrganizationNullableUsageEnum]

        allow_any_organization : typing.Optional[bool]
            Controls allowing any organization to be used with this grant

        authorization_details_types : typing.Optional[typing.Sequence[str]]
            Types of authorization_details allowed for this client grant. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href= "https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateClientGrantResponseContent
            Client grant successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.client_grants.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            scope=scope,
            organization_usage=organization_usage,
            allow_any_organization=allow_any_organization,
            authorization_details_types=authorization_details_types,
            request_options=request_options,
        )
        return _response.data

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import OrganizationsClient  # noqa: E402

            self._organizations = OrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations


class AsyncClientGrantsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawClientGrantsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._organizations: typing.Optional[AsyncOrganizationsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawClientGrantsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawClientGrantsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        audience: typing.Optional[str] = None,
        client_id: typing.Optional[str] = None,
        allow_any_organization: typing.Optional[ClientGrantAllowAnyOrganizationEnum] = None,
        subject_type: typing.Optional[ClientGrantSubjectTypeEnum] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ClientGrantResponseContent, ListClientGrantPaginatedResponseContent]:
        """
        Retrieve a list of <a href="https://auth0.com/docs/get-started/applications/application-access-to-apis-client-grants">client grants</a>, including the scopes associated with the application/API pair.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        audience : typing.Optional[str]
            Optional filter on audience.

        client_id : typing.Optional[str]
            Optional filter on client_id.

        allow_any_organization : typing.Optional[ClientGrantAllowAnyOrganizationEnum]
            Optional filter on allow_any_organization.

        subject_type : typing.Optional[ClientGrantSubjectTypeEnum]
            The type of application access the client grant allows. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href="https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ClientGrantResponseContent, ListClientGrantPaginatedResponseContent]
            Client grants successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.client_grants.list(
                from_="from",
                take=1,
                audience="audience",
                client_id="client_id",
                allow_any_organization=True,
                subject_type="client",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            from_=from_,
            take=take,
            audience=audience,
            client_id=client_id,
            allow_any_organization=allow_any_organization,
            subject_type=subject_type,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        client_id: str,
        audience: str,
        organization_usage: typing.Optional[ClientGrantOrganizationUsageEnum] = OMIT,
        allow_any_organization: typing.Optional[bool] = False,
        scope: typing.Optional[typing.Sequence[str]] = OMIT,
        subject_type: typing.Optional[ClientGrantSubjectTypeEnum] = OMIT,
        authorization_details_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateClientGrantResponseContent:
        """
        Create a client grant for a machine-to-machine login flow. To learn more, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        audience : str
            The audience (API identifier) of this client grant

        organization_usage : typing.Optional[ClientGrantOrganizationUsageEnum]

        allow_any_organization : typing.Optional[bool]
            If enabled, any organization can be used with this grant. If disabled (default), the grant must be explicitly assigned to the desired organizations.

        scope : typing.Optional[typing.Sequence[str]]
            Scopes allowed for this client grant.

        subject_type : typing.Optional[ClientGrantSubjectTypeEnum]

        authorization_details_types : typing.Optional[typing.Sequence[str]]
            Types of authorization_details allowed for this client grant. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href= "https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateClientGrantResponseContent
            Client grant successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.client_grants.create(
                client_id="client_id",
                audience="audience",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            client_id=client_id,
            audience=audience,
            organization_usage=organization_usage,
            allow_any_organization=allow_any_organization,
            scope=scope,
            subject_type=subject_type,
            authorization_details_types=authorization_details_types,
            request_options=request_options,
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a> from your machine-to-machine application.

        Parameters
        ----------
        id : str
            ID of the client grant to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.client_grants.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        scope: typing.Optional[typing.Sequence[str]] = OMIT,
        organization_usage: typing.Optional[ClientGrantOrganizationNullableUsageEnum] = OMIT,
        allow_any_organization: typing.Optional[bool] = OMIT,
        authorization_details_types: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateClientGrantResponseContent:
        """
        Update a client grant.

        Parameters
        ----------
        id : str
            ID of the client grant to update.

        scope : typing.Optional[typing.Sequence[str]]
            Scopes allowed for this client grant.

        organization_usage : typing.Optional[ClientGrantOrganizationNullableUsageEnum]

        allow_any_organization : typing.Optional[bool]
            Controls allowing any organization to be used with this grant

        authorization_details_types : typing.Optional[typing.Sequence[str]]
            Types of authorization_details allowed for this client grant. Use of this field is subject to the applicable Free Trial terms in Okta’s <a href= "https://www.okta.com/legal/"> Master Subscription Agreement.</a>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateClientGrantResponseContent
            Client grant successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.client_grants.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            scope=scope,
            organization_usage=organization_usage,
            allow_any_organization=allow_any_organization,
            authorization_details_types=authorization_details_types,
            request_options=request_options,
        )
        return _response.data

    @property
    def organizations(self):
        if self._organizations is None:
            from .organizations.client import AsyncOrganizationsClient  # noqa: E402

            self._organizations = AsyncOrganizationsClient(client_wrapper=self._client_wrapper)
        return self._organizations
