# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.connection_for_list import ConnectionForList
from ...types.connection_strategy_enum import ConnectionStrategyEnum
from ...types.list_client_connections_response_content import ListClientConnectionsResponseContent
from .raw_client import AsyncRawConnectionsClient, RawConnectionsClient


class ConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionsClient
        """
        return self._raw_client

    def get(
        self,
        id: str,
        *,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectionForList, ListClientConnectionsResponseContent]:
        """
        Retrieve all connections that are enabled for the specified <a href="https://www.auth0.com/docs/get-started/applications"> Application</a>, using checkpoint pagination. A list of fields to include or exclude for each connection may also be specified.
        <ul>
          <li>
            This endpoint requires the <code>read:connections</code> scope and any one of <code>read:clients</code> or <code>read:client_summary</code>.
          </li>
          <li>
            <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client for which to retrieve enabled connections.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectionForList, ListClientConnectionsResponseContent]
            Success

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.clients.connections.get(
            id="id",
            from_="from",
            take=1,
            fields="fields",
            include_fields=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.get(
            id,
            strategy=strategy,
            from_=from_,
            take=take,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )


class AsyncConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionsClient
        """
        return self._raw_client

    async def get(
        self,
        id: str,
        *,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectionForList, ListClientConnectionsResponseContent]:
        """
        Retrieve all connections that are enabled for the specified <a href="https://www.auth0.com/docs/get-started/applications"> Application</a>, using checkpoint pagination. A list of fields to include or exclude for each connection may also be specified.
        <ul>
          <li>
            This endpoint requires the <code>read:connections</code> scope and any one of <code>read:clients</code> or <code>read:client_summary</code>.
          </li>
          <li>
            <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client for which to retrieve enabled connections.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectionForList, ListClientConnectionsResponseContent]
            Success

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.clients.connections.get(
                id="id",
                from_="from",
                take=1,
                fields="fields",
                include_fields=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.get(
            id,
            strategy=strategy,
            from_=from_,
            take=take,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )
