# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, SyncPager
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...errors.bad_request_error import BadRequestError
from ...errors.forbidden_error import ForbiddenError
from ...errors.not_found_error import NotFoundError
from ...errors.too_many_requests_error import TooManyRequestsError
from ...errors.unauthorized_error import UnauthorizedError
from ...types.connection_for_list import ConnectionForList
from ...types.connection_strategy_enum import ConnectionStrategyEnum
from ...types.list_client_connections_response_content import ListClientConnectionsResponseContent


class RawConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        id: str,
        *,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectionForList, ListClientConnectionsResponseContent]:
        """
        Retrieve all connections that are enabled for the specified <a href="https://www.auth0.com/docs/get-started/applications"> Application</a>, using checkpoint pagination. A list of fields to include or exclude for each connection may also be specified.
        <ul>
          <li>
            This endpoint requires the <code>read:connections</code> scope and any one of <code>read:clients</code> or <code>read:client_summary</code>.
          </li>
          <li>
            <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client for which to retrieve enabled connections.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectionForList, ListClientConnectionsResponseContent]
            Success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}/connections",
            method="GET",
            params={
                "strategy": strategy,
                "from": from_,
                "take": take,
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListClientConnectionsResponseContent,
                    parse_obj_as(
                        type_=ListClientConnectionsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.connections
                _parsed_next = _parsed_response.next
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.get(
                    id,
                    strategy=strategy,
                    from_=_parsed_next,
                    take=take,
                    fields=fields,
                    include_fields=include_fields,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        id: str,
        *,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectionForList, ListClientConnectionsResponseContent]:
        """
        Retrieve all connections that are enabled for the specified <a href="https://www.auth0.com/docs/get-started/applications"> Application</a>, using checkpoint pagination. A list of fields to include or exclude for each connection may also be specified.
        <ul>
          <li>
            This endpoint requires the <code>read:connections</code> scope and any one of <code>read:clients</code> or <code>read:client_summary</code>.
          </li>
          <li>
            <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client for which to retrieve enabled connections.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectionForList, ListClientConnectionsResponseContent]
            Success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}/connections",
            method="GET",
            params={
                "strategy": strategy,
                "from": from_,
                "take": take,
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListClientConnectionsResponseContent,
                    parse_obj_as(
                        type_=ListClientConnectionsResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.connections
                _parsed_next = _parsed_response.next
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.get(
                        id,
                        strategy=strategy,
                        from_=_parsed_next,
                        take=take,
                        fields=fields,
                        include_fields=include_fields,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
