# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.client_credential import ClientCredential
from ...types.client_credential_type_enum import ClientCredentialTypeEnum
from ...types.get_client_credential_response_content import GetClientCredentialResponseContent
from ...types.patch_client_credential_response_content import PatchClientCredentialResponseContent
from ...types.post_client_credential_response_content import PostClientCredentialResponseContent
from ...types.public_key_credential_algorithm_enum import PublicKeyCredentialAlgorithmEnum
from .raw_client import AsyncRawCredentialsClient, RawCredentialsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CredentialsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCredentialsClient
        """
        return self._raw_client

    def list(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientCredential]:
        """
        Get the details of a client credential.

        <b>Important</b>: To enable credentials to be used for a client authentication method, set the <code>client_authentication_methods</code> property on the client. To enable credentials to be used for JWT-Secured Authorization requests set the <code>signed_request_object</code> property on the client.

        Parameters
        ----------
        client_id : str
            ID of the client.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientCredential]
            Credentials successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.clients.credentials.list(
            client_id="client_id",
        )
        """
        _response = self._raw_client.list(client_id, request_options=request_options)
        return _response.data

    def create(
        self,
        client_id: str,
        *,
        credential_type: ClientCredentialTypeEnum,
        name: typing.Optional[str] = "",
        subject_dn: typing.Optional[str] = OMIT,
        pem: typing.Optional[str] = "-----BEGIN PUBLIC KEY-----\r\nMIIBIjANBg...\r\n-----END PUBLIC KEY-----\r\n",
        alg: typing.Optional[PublicKeyCredentialAlgorithmEnum] = OMIT,
        parse_expiry_from_cert: typing.Optional[bool] = False,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostClientCredentialResponseContent:
        """
        Create a client credential associated to your application. Credentials can be used to configure Private Key JWT and mTLS authentication methods, as well as for JWT-secured Authorization requests.

        <h5>Public Key</h5>Public Key credentials can be used to set up Private Key JWT client authentication and JWT-secured Authorization requests.

        Sample: <pre><code>{
          "credential_type": "public_key",
          "name": "string",
          "pem": "string",
          "alg": "RS256",
          "parse_expiry_from_cert": false,
          "expires_at": "2022-12-31T23:59:59Z"
        }</code></pre>
        <h5>Certificate (CA-signed & self-signed)</h5>Certificate credentials can be used to set up mTLS client authentication. CA-signed certificates can be configured either with a signed certificate or with just the certificate Subject DN.

        CA-signed Certificate Sample (pem): <pre><code>{
          "credential_type": "x509_cert",
          "name": "string",
          "pem": "string"
        }</code></pre>CA-signed Certificate Sample (subject_dn): <pre><code>{
          "credential_type": "cert_subject_dn",
          "name": "string",
          "subject_dn": "string"
        }</code></pre>Self-signed Certificate Sample: <pre><code>{
          "credential_type": "cert_subject_dn",
          "name": "string",
          "pem": "string"
        }</code></pre>

        The credential will be created but not yet enabled for use until you set the corresponding properties in the client:
        <ul>
          <li>To enable the credential for Private Key JWT or mTLS authentication methods, set the <code>client_authentication_methods</code> property on the client. For more information, read <a href="https://auth0.com/docs/get-started/applications/configure-private-key-jwt">Configure Private Key JWT Authentication</a> and <a href="https://auth0.com/docs/get-started/applications/configure-mtls">Configure mTLS Authentication</a></li>
          <li>To enable the credential for JWT-secured Authorization requests, set the <code>signed_request_object</code>property on the client. For more information, read <a href="https://auth0.com/docs/get-started/applications/configure-jar">Configure JWT-secured Authorization Requests (JAR)</a></li>
        </ul>

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_type : ClientCredentialTypeEnum

        name : typing.Optional[str]
            Friendly name for a credential.

        subject_dn : typing.Optional[str]
            Subject Distinguished Name. Mutually exclusive with `pem` property. Applies to `cert_subject_dn` credential type.

        pem : typing.Optional[str]
            PEM-formatted public key (SPKI and PKCS1) or X509 certificate. Must be JSON escaped.

        alg : typing.Optional[PublicKeyCredentialAlgorithmEnum]

        parse_expiry_from_cert : typing.Optional[bool]
            Parse expiry from x509 certificate. If true, attempts to parse the expiry date from the provided PEM. Applies to `public_key` credential type.

        expires_at : typing.Optional[dt.datetime]
            The ISO 8601 formatted date representing the expiration of the credential. If not specified (not recommended), the credential never expires. Applies to `public_key` credential type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostClientCredentialResponseContent
            Credential successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.clients.credentials.create(
            client_id="client_id",
            credential_type="public_key",
        )
        """
        _response = self._raw_client.create(
            client_id,
            credential_type=credential_type,
            name=name,
            subject_dn=subject_dn,
            pem=pem,
            alg=alg,
            parse_expiry_from_cert=parse_expiry_from_cert,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    def get(
        self, client_id: str, credential_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetClientCredentialResponseContent:
        """
        Get the details of a client credential.

        <b>Important</b>: To enable credentials to be used for a client authentication method, set the <code>client_authentication_methods</code> property on the client. To enable credentials to be used for JWT-Secured Authorization requests set the <code>signed_request_object</code> property on the client.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClientCredentialResponseContent
            Credential successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.clients.credentials.get(
            client_id="client_id",
            credential_id="credential_id",
        )
        """
        _response = self._raw_client.get(client_id, credential_id, request_options=request_options)
        return _response.data

    def delete(
        self, client_id: str, credential_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a client credential you previously created. May be enabled or disabled. For more information, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.clients.credentials.delete(
            client_id="client_id",
            credential_id="credential_id",
        )
        """
        _response = self._raw_client.delete(client_id, credential_id, request_options=request_options)
        return _response.data

    def update(
        self,
        client_id: str,
        credential_id: str,
        *,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatchClientCredentialResponseContent:
        """
        Change a client credential you previously created. May be enabled or disabled. For more information, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential.

        expires_at : typing.Optional[dt.datetime]
            The ISO 8601 formatted date representing the expiration of the credential.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatchClientCredentialResponseContent
            Credential successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.clients.credentials.update(
            client_id="client_id",
            credential_id="credential_id",
        )
        """
        _response = self._raw_client.update(
            client_id, credential_id, expires_at=expires_at, request_options=request_options
        )
        return _response.data


class AsyncCredentialsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCredentialsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCredentialsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCredentialsClient
        """
        return self._raw_client

    async def list(
        self, client_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientCredential]:
        """
        Get the details of a client credential.

        <b>Important</b>: To enable credentials to be used for a client authentication method, set the <code>client_authentication_methods</code> property on the client. To enable credentials to be used for JWT-Secured Authorization requests set the <code>signed_request_object</code> property on the client.

        Parameters
        ----------
        client_id : str
            ID of the client.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientCredential]
            Credentials successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.clients.credentials.list(
                client_id="client_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(client_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        client_id: str,
        *,
        credential_type: ClientCredentialTypeEnum,
        name: typing.Optional[str] = "",
        subject_dn: typing.Optional[str] = OMIT,
        pem: typing.Optional[str] = "-----BEGIN PUBLIC KEY-----\r\nMIIBIjANBg...\r\n-----END PUBLIC KEY-----\r\n",
        alg: typing.Optional[PublicKeyCredentialAlgorithmEnum] = OMIT,
        parse_expiry_from_cert: typing.Optional[bool] = False,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostClientCredentialResponseContent:
        """
        Create a client credential associated to your application. Credentials can be used to configure Private Key JWT and mTLS authentication methods, as well as for JWT-secured Authorization requests.

        <h5>Public Key</h5>Public Key credentials can be used to set up Private Key JWT client authentication and JWT-secured Authorization requests.

        Sample: <pre><code>{
          "credential_type": "public_key",
          "name": "string",
          "pem": "string",
          "alg": "RS256",
          "parse_expiry_from_cert": false,
          "expires_at": "2022-12-31T23:59:59Z"
        }</code></pre>
        <h5>Certificate (CA-signed & self-signed)</h5>Certificate credentials can be used to set up mTLS client authentication. CA-signed certificates can be configured either with a signed certificate or with just the certificate Subject DN.

        CA-signed Certificate Sample (pem): <pre><code>{
          "credential_type": "x509_cert",
          "name": "string",
          "pem": "string"
        }</code></pre>CA-signed Certificate Sample (subject_dn): <pre><code>{
          "credential_type": "cert_subject_dn",
          "name": "string",
          "subject_dn": "string"
        }</code></pre>Self-signed Certificate Sample: <pre><code>{
          "credential_type": "cert_subject_dn",
          "name": "string",
          "pem": "string"
        }</code></pre>

        The credential will be created but not yet enabled for use until you set the corresponding properties in the client:
        <ul>
          <li>To enable the credential for Private Key JWT or mTLS authentication methods, set the <code>client_authentication_methods</code> property on the client. For more information, read <a href="https://auth0.com/docs/get-started/applications/configure-private-key-jwt">Configure Private Key JWT Authentication</a> and <a href="https://auth0.com/docs/get-started/applications/configure-mtls">Configure mTLS Authentication</a></li>
          <li>To enable the credential for JWT-secured Authorization requests, set the <code>signed_request_object</code>property on the client. For more information, read <a href="https://auth0.com/docs/get-started/applications/configure-jar">Configure JWT-secured Authorization Requests (JAR)</a></li>
        </ul>

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_type : ClientCredentialTypeEnum

        name : typing.Optional[str]
            Friendly name for a credential.

        subject_dn : typing.Optional[str]
            Subject Distinguished Name. Mutually exclusive with `pem` property. Applies to `cert_subject_dn` credential type.

        pem : typing.Optional[str]
            PEM-formatted public key (SPKI and PKCS1) or X509 certificate. Must be JSON escaped.

        alg : typing.Optional[PublicKeyCredentialAlgorithmEnum]

        parse_expiry_from_cert : typing.Optional[bool]
            Parse expiry from x509 certificate. If true, attempts to parse the expiry date from the provided PEM. Applies to `public_key` credential type.

        expires_at : typing.Optional[dt.datetime]
            The ISO 8601 formatted date representing the expiration of the credential. If not specified (not recommended), the credential never expires. Applies to `public_key` credential type.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostClientCredentialResponseContent
            Credential successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.clients.credentials.create(
                client_id="client_id",
                credential_type="public_key",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            client_id,
            credential_type=credential_type,
            name=name,
            subject_dn=subject_dn,
            pem=pem,
            alg=alg,
            parse_expiry_from_cert=parse_expiry_from_cert,
            expires_at=expires_at,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self, client_id: str, credential_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetClientCredentialResponseContent:
        """
        Get the details of a client credential.

        <b>Important</b>: To enable credentials to be used for a client authentication method, set the <code>client_authentication_methods</code> property on the client. To enable credentials to be used for JWT-Secured Authorization requests set the <code>signed_request_object</code> property on the client.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetClientCredentialResponseContent
            Credential successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.clients.credentials.get(
                client_id="client_id",
                credential_id="credential_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(client_id, credential_id, request_options=request_options)
        return _response.data

    async def delete(
        self, client_id: str, credential_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete a client credential you previously created. May be enabled or disabled. For more information, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.clients.credentials.delete(
                client_id="client_id",
                credential_id="credential_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(client_id, credential_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        client_id: str,
        credential_id: str,
        *,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PatchClientCredentialResponseContent:
        """
        Change a client credential you previously created. May be enabled or disabled. For more information, read <a href="https://www.auth0.com/docs/get-started/authentication-and-authorization-flow/client-credentials-flow">Client Credential Flow</a>.

        Parameters
        ----------
        client_id : str
            ID of the client.

        credential_id : str
            ID of the credential.

        expires_at : typing.Optional[dt.datetime]
            The ISO 8601 formatted date representing the expiration of the credential.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PatchClientCredentialResponseContent
            Credential successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.clients.credentials.update(
                client_id="client_id",
                credential_id="credential_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            client_id, credential_id, expires_at=expires_at, request_options=request_options
        )
        return _response.data
