# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, SyncPager
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.conflict_error import ConflictError
from ..errors.forbidden_error import ForbiddenError
from ..errors.not_found_error import NotFoundError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.client import Client
from ..types.client_addons import ClientAddons
from ..types.client_app_type_enum import ClientAppTypeEnum
from ..types.client_async_approval_notifications_channels_api_patch_configuration import (
    ClientAsyncApprovalNotificationsChannelsApiPatchConfiguration,
)
from ..types.client_async_approval_notifications_channels_api_post_configuration import (
    ClientAsyncApprovalNotificationsChannelsApiPostConfiguration,
)
from ..types.client_authentication_method import ClientAuthenticationMethod
from ..types.client_compliance_level_enum import ClientComplianceLevelEnum
from ..types.client_create_authentication_method import ClientCreateAuthenticationMethod
from ..types.client_default_organization import ClientDefaultOrganization
from ..types.client_encryption_key import ClientEncryptionKey
from ..types.client_jwt_configuration import ClientJwtConfiguration
from ..types.client_metadata import ClientMetadata
from ..types.client_mobile import ClientMobile
from ..types.client_oidc_backchannel_logout_settings import ClientOidcBackchannelLogoutSettings
from ..types.client_organization_discovery_enum import ClientOrganizationDiscoveryEnum
from ..types.client_organization_require_behavior_enum import ClientOrganizationRequireBehaviorEnum
from ..types.client_organization_require_behavior_patch_enum import ClientOrganizationRequireBehaviorPatchEnum
from ..types.client_organization_usage_enum import ClientOrganizationUsageEnum
from ..types.client_organization_usage_patch_enum import ClientOrganizationUsagePatchEnum
from ..types.client_refresh_token_configuration import ClientRefreshTokenConfiguration
from ..types.client_session_transfer_configuration import ClientSessionTransferConfiguration
from ..types.client_signed_request_object_with_credential_id import ClientSignedRequestObjectWithCredentialId
from ..types.client_signed_request_object_with_public_key import ClientSignedRequestObjectWithPublicKey
from ..types.client_token_endpoint_auth_method_enum import ClientTokenEndpointAuthMethodEnum
from ..types.client_token_endpoint_auth_method_or_null_enum import ClientTokenEndpointAuthMethodOrNullEnum
from ..types.client_token_exchange_configuration import ClientTokenExchangeConfiguration
from ..types.client_token_exchange_configuration_or_null import ClientTokenExchangeConfigurationOrNull
from ..types.create_client_response_content import CreateClientResponseContent
from ..types.create_token_quota import CreateTokenQuota
from ..types.express_configuration import ExpressConfiguration
from ..types.express_configuration_or_null import ExpressConfigurationOrNull
from ..types.get_client_response_content import GetClientResponseContent
from ..types.list_clients_offset_paginated_response_content import ListClientsOffsetPaginatedResponseContent
from ..types.native_social_login import NativeSocialLogin
from ..types.rotate_client_secret_response_content import RotateClientSecretResponseContent
from ..types.update_client_response_content import UpdateClientResponseContent
from ..types.update_token_quota import UpdateTokenQuota

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawClientsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        is_global: typing.Optional[bool] = None,
        is_first_party: typing.Optional[bool] = None,
        app_type: typing.Optional[str] = None,
        q: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Client, ListClientsOffsetPaginatedResponseContent]:
        """
        Retrieve clients (applications and SSO integrations) matching provided filters. A list of fields to include or exclude may also be specified.
        For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.

        <ul>
          <li>
            The following can be retrieved with any scope:
            <code>client_id</code>, <code>app_type</code>, <code>name</code>, and <code>description</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:clients</code> or
            <code>read:client_keys</code> scope:
            <code>callbacks</code>, <code>oidc_logout</code>, <code>allowed_origins</code>,
            <code>web_origins</code>, <code>tenant</code>, <code>global</code>, <code>config_route</code>,
            <code>callback_url_template</code>, <code>jwt_configuration</code>,
            <code>jwt_configuration.lifetime_in_seconds</code>, <code>jwt_configuration.secret_encoded</code>,
            <code>jwt_configuration.scopes</code>, <code>jwt_configuration.alg</code>, <code>api_type</code>,
            <code>logo_uri</code>, <code>allowed_clients</code>, <code>owners</code>, <code>custom_login_page</code>,
            <code>custom_login_page_off</code>, <code>sso</code>, <code>addons</code>, <code>form_template</code>,
            <code>custom_login_page_codeview</code>, <code>resource_servers</code>, <code>client_metadata</code>,
            <code>mobile</code>, <code>mobile.android</code>, <code>mobile.ios</code>, <code>allowed_logout_urls</code>,
            <code>token_endpoint_auth_method</code>, <code>is_first_party</code>, <code>oidc_conformant</code>,
            <code>is_token_endpoint_ip_header_trusted</code>, <code>initiate_login_uri</code>, <code>grant_types</code>,
            <code>refresh_token</code>, <code>refresh_token.rotation_type</code>, <code>refresh_token.expiration_type</code>,
            <code>refresh_token.leeway</code>, <code>refresh_token.token_lifetime</code>, <code>refresh_token.policies</code>, <code>organization_usage</code>,
            <code>organization_require_behavior</code>.
          </li>
          <li>
            The following properties can only be retrieved with the
            <code>read:client_keys</code> or <code>read:client_credentials</code> scope:
            <code>encryption_key</code>, <code>encryption_key.pub</code>, <code>encryption_key.cert</code>,
            <code>client_secret</code>, <code>client_authentication_methods</code> and <code>signing_key</code>.
          </li>
        </ul>

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default value is 50, maximum value is 100

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        is_global : typing.Optional[bool]
            Optional filter on the global client parameter.

        is_first_party : typing.Optional[bool]
            Optional filter on whether or not a client is a first-party client.

        app_type : typing.Optional[str]
            Optional filter by a comma-separated list of application types.

        q : typing.Optional[str]
            Advanced Query in <a href="http://www.lucenetutorial.com/lucene-query-syntax.html">Lucene</a> syntax.<br /><b>Permitted Queries</b>:<br /><ul><li><i>client_grant.organization_id:{organization_id}</i></li><li><i>client_grant.allow_any_organization:true</i></li></ul><b>Additional Restrictions</b>:<br /><ul><li>Cannot be used in combination with other filters</li><li>Requires use of the <i>from</i> and <i>take</i> paging parameters (checkpoint paginatinon)</li><li>Reduced rate limits apply. See <a href="https://auth0.com/docs/troubleshoot/customer-support/operational-policies/rate-limit-policy/rate-limit-configurations/enterprise-public">Rate Limit Configurations</a></li></ul><i><b>Note</b>: Recent updates may not be immediately reflected in query results</i>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Client, ListClientsOffsetPaginatedResponseContent]
            Clients successfully retrieved.
        """
        page = page if page is not None else 0

        _response = self._client_wrapper.httpx_client.request(
            "clients",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "is_global": is_global,
                "is_first_party": is_first_party,
                "app_type": app_type,
                "q": q,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListClientsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListClientsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.clients
                _has_next = True
                _get_next = lambda: self.list(
                    fields=fields,
                    include_fields=include_fields,
                    page=page + len(_items or []),
                    per_page=per_page,
                    include_totals=include_totals,
                    is_global=is_global,
                    is_first_party=is_first_party,
                    app_type=app_type,
                    q=q,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        logo_uri: typing.Optional[str] = OMIT,
        callbacks: typing.Optional[typing.Sequence[str]] = OMIT,
        oidc_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        oidc_backchannel_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        session_transfer: typing.Optional[ClientSessionTransferConfiguration] = OMIT,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        web_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        client_aliases: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        grant_types: typing.Optional[typing.Sequence[str]] = OMIT,
        token_endpoint_auth_method: typing.Optional[ClientTokenEndpointAuthMethodEnum] = OMIT,
        is_token_endpoint_ip_header_trusted: typing.Optional[bool] = False,
        app_type: typing.Optional[ClientAppTypeEnum] = OMIT,
        is_first_party: typing.Optional[bool] = True,
        oidc_conformant: typing.Optional[bool] = False,
        jwt_configuration: typing.Optional[ClientJwtConfiguration] = OMIT,
        encryption_key: typing.Optional[ClientEncryptionKey] = OMIT,
        sso: typing.Optional[bool] = OMIT,
        cross_origin_authentication: typing.Optional[bool] = False,
        cross_origin_loc: typing.Optional[str] = OMIT,
        sso_disabled: typing.Optional[bool] = OMIT,
        custom_login_page_on: typing.Optional[bool] = OMIT,
        custom_login_page: typing.Optional[str] = OMIT,
        custom_login_page_preview: typing.Optional[str] = OMIT,
        form_template: typing.Optional[str] = OMIT,
        addons: typing.Optional[ClientAddons] = OMIT,
        client_metadata: typing.Optional[ClientMetadata] = OMIT,
        mobile: typing.Optional[ClientMobile] = OMIT,
        initiate_login_uri: typing.Optional[str] = OMIT,
        native_social_login: typing.Optional[NativeSocialLogin] = OMIT,
        refresh_token: typing.Optional[ClientRefreshTokenConfiguration] = OMIT,
        default_organization: typing.Optional[ClientDefaultOrganization] = OMIT,
        organization_usage: typing.Optional[ClientOrganizationUsageEnum] = OMIT,
        organization_require_behavior: typing.Optional[ClientOrganizationRequireBehaviorEnum] = OMIT,
        organization_discovery_methods: typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]] = OMIT,
        client_authentication_methods: typing.Optional[ClientCreateAuthenticationMethod] = OMIT,
        require_pushed_authorization_requests: typing.Optional[bool] = False,
        require_proof_of_possession: typing.Optional[bool] = False,
        signed_request_object: typing.Optional[ClientSignedRequestObjectWithPublicKey] = OMIT,
        compliance_level: typing.Optional[ClientComplianceLevelEnum] = OMIT,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        token_exchange: typing.Optional[ClientTokenExchangeConfiguration] = OMIT,
        par_request_expiry: typing.Optional[int] = OMIT,
        token_quota: typing.Optional[CreateTokenQuota] = OMIT,
        resource_server_identifier: typing.Optional[str] = OMIT,
        express_configuration: typing.Optional[ExpressConfiguration] = OMIT,
        async_approval_notification_channels: typing.Optional[
            ClientAsyncApprovalNotificationsChannelsApiPostConfiguration
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateClientResponseContent]:
        """
        Create a new client (application or SSO integration). For more information, read <a href="https://www.auth0.com/docs/get-started/auth0-overview/create-applications">Create Applications</a>
        <a href="https://www.auth0.com/docs/authenticate/single-sign-on/api-endpoints-for-single-sign-on>">API Endpoints for Single Sign-On</a>.

        Notes:
        - We recommend leaving the `client_secret` parameter unspecified to allow the generation of a safe secret.
        - The <code>client_authentication_methods</code> and <code>token_endpoint_auth_method</code> properties are mutually exclusive. Use
        <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method. Otherwise, use <code>token_endpoint_auth_method</code>
        to configure the client with client secret (basic or post) or with no authentication method (none).
        - When using <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method, specify fully defined credentials.
        These credentials will be automatically enabled for Private Key JWT authentication on the client.
        - To configure <code>client_authentication_methods</code>, the <code>create:client_credentials</code> scope is required.
        - To configure <code>client_authentication_methods</code>, the property <code>jwt_configuration.alg</code> must be set to RS256.

        <div class="alert alert-warning">SSO Integrations created via this endpoint will accept login requests and share user profile information.</div>

        Parameters
        ----------
        name : str
            Name of this client (min length: 1 character, does not allow `<` or `>`).

        description : typing.Optional[str]
            Free text description of this client (max length: 140 characters).

        logo_uri : typing.Optional[str]
            URL of the logo to display for this client. Recommended size is 150x150 pixels.

        callbacks : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs whitelisted for Auth0 to use as a callback to the client after authentication.

        oidc_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        oidc_backchannel_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        session_transfer : typing.Optional[ClientSessionTransferConfiguration]

        allowed_origins : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs allowed to make requests from JavaScript to Auth0 API (typically used with CORS). By default, all your callback URLs will be allowed. This field allows you to enter other origins if necessary. You can also use wildcards at the subdomain level (e.g., https://*.contoso.com). Query strings and hash information are not taken into account when validating these URLs.

        web_origins : typing.Optional[typing.Sequence[str]]
            Comma-separated list of allowed origins for use with <a href='https://auth0.com/docs/cross-origin-authentication'>Cross-Origin Authentication</a>, <a href='https://auth0.com/docs/flows/concepts/device-auth'>Device Flow</a>, and <a href='https://auth0.com/docs/protocols/oauth2#how-response-mode-works'>web message response mode</a>.

        client_aliases : typing.Optional[typing.Sequence[str]]
            List of audiences/realms for SAML protocol. Used by the wsfed addon.

        allowed_clients : typing.Optional[typing.Sequence[str]]
            List of allow clients and API ids that are allowed to make delegation requests. Empty means all all your clients are allowed.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs that are valid to redirect to after logout from Auth0. Wildcards are allowed for subdomains.

        grant_types : typing.Optional[typing.Sequence[str]]
            List of grant types supported for this application. Can include `authorization_code`, `implicit`, `refresh_token`, `client_credentials`, `password`, `http://auth0.com/oauth/grant-type/password-realm`, `http://auth0.com/oauth/grant-type/mfa-oob`, `http://auth0.com/oauth/grant-type/mfa-otp`, `http://auth0.com/oauth/grant-type/mfa-recovery-code`, `urn:openid:params:grant-type:ciba`, `urn:ietf:params:oauth:grant-type:device_code`, and `urn:auth0:params:oauth:grant-type:token-exchange:federated-connection-access-token`.

        token_endpoint_auth_method : typing.Optional[ClientTokenEndpointAuthMethodEnum]

        is_token_endpoint_ip_header_trusted : typing.Optional[bool]
            If true, trust that the IP specified in the `auth0-forwarded-for` header is the end-user's IP for brute-force-protection on token endpoint.

        app_type : typing.Optional[ClientAppTypeEnum]

        is_first_party : typing.Optional[bool]
            Whether this client a first party client or not

        oidc_conformant : typing.Optional[bool]
            Whether this client conforms to <a href='https://auth0.com/docs/api-auth/tutorials/adoption'>strict OIDC specifications</a> (true) or uses legacy features (false).

        jwt_configuration : typing.Optional[ClientJwtConfiguration]

        encryption_key : typing.Optional[ClientEncryptionKey]

        sso : typing.Optional[bool]
            Applies only to SSO clients and determines whether Auth0 will handle Single Sign On (true) or whether the Identity Provider will (false).

        cross_origin_authentication : typing.Optional[bool]
            Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).

        cross_origin_loc : typing.Optional[str]
            URL of the location in your site where the cross origin verification takes place for the cross-origin auth flow when performing Auth in your own domain instead of Auth0 hosted login page.

        sso_disabled : typing.Optional[bool]
            <code>true</code> to disable Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        custom_login_page_on : typing.Optional[bool]
            <code>true</code> if the custom login page is to be used, <code>false</code> otherwise. Defaults to <code>true</code>

        custom_login_page : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page.

        custom_login_page_preview : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page. (Used on Previews)

        form_template : typing.Optional[str]
            HTML form template to be used for WS-Federation.

        addons : typing.Optional[ClientAddons]

        client_metadata : typing.Optional[ClientMetadata]

        mobile : typing.Optional[ClientMobile]

        initiate_login_uri : typing.Optional[str]
            Initiate login uri, must be https

        native_social_login : typing.Optional[NativeSocialLogin]

        refresh_token : typing.Optional[ClientRefreshTokenConfiguration]

        default_organization : typing.Optional[ClientDefaultOrganization]

        organization_usage : typing.Optional[ClientOrganizationUsageEnum]

        organization_require_behavior : typing.Optional[ClientOrganizationRequireBehaviorEnum]

        organization_discovery_methods : typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]]
            Defines the available methods for organization discovery during the `pre_login_prompt`. Users can discover their organization either by `email`, `organization_name` or both.

        client_authentication_methods : typing.Optional[ClientCreateAuthenticationMethod]

        require_pushed_authorization_requests : typing.Optional[bool]
            Makes the use of Pushed Authorization Requests mandatory for this client

        require_proof_of_possession : typing.Optional[bool]
            Makes the use of Proof-of-Possession mandatory for this client

        signed_request_object : typing.Optional[ClientSignedRequestObjectWithPublicKey]

        compliance_level : typing.Optional[ClientComplianceLevelEnum]

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        token_exchange : typing.Optional[ClientTokenExchangeConfiguration]

        par_request_expiry : typing.Optional[int]
            Specifies how long, in seconds, a Pushed Authorization Request URI remains valid

        token_quota : typing.Optional[CreateTokenQuota]

        resource_server_identifier : typing.Optional[str]
            The identifier of the resource server that this client is linked to.

        express_configuration : typing.Optional[ExpressConfiguration]

        async_approval_notification_channels : typing.Optional[ClientAsyncApprovalNotificationsChannelsApiPostConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateClientResponseContent]
            Client successfully created.
        """
        _response = self._client_wrapper.httpx_client.request(
            "clients",
            method="POST",
            json={
                "name": name,
                "description": description,
                "logo_uri": logo_uri,
                "callbacks": callbacks,
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "oidc_backchannel_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_backchannel_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "session_transfer": convert_and_respect_annotation_metadata(
                    object_=session_transfer,
                    annotation=typing.Optional[ClientSessionTransferConfiguration],
                    direction="write",
                ),
                "allowed_origins": allowed_origins,
                "web_origins": web_origins,
                "client_aliases": client_aliases,
                "allowed_clients": allowed_clients,
                "allowed_logout_urls": allowed_logout_urls,
                "grant_types": grant_types,
                "token_endpoint_auth_method": token_endpoint_auth_method,
                "is_token_endpoint_ip_header_trusted": is_token_endpoint_ip_header_trusted,
                "app_type": app_type,
                "is_first_party": is_first_party,
                "oidc_conformant": oidc_conformant,
                "jwt_configuration": convert_and_respect_annotation_metadata(
                    object_=jwt_configuration, annotation=ClientJwtConfiguration, direction="write"
                ),
                "encryption_key": convert_and_respect_annotation_metadata(
                    object_=encryption_key, annotation=typing.Optional[ClientEncryptionKey], direction="write"
                ),
                "sso": sso,
                "cross_origin_authentication": cross_origin_authentication,
                "cross_origin_loc": cross_origin_loc,
                "sso_disabled": sso_disabled,
                "custom_login_page_on": custom_login_page_on,
                "custom_login_page": custom_login_page,
                "custom_login_page_preview": custom_login_page_preview,
                "form_template": form_template,
                "addons": convert_and_respect_annotation_metadata(
                    object_=addons, annotation=ClientAddons, direction="write"
                ),
                "client_metadata": client_metadata,
                "mobile": convert_and_respect_annotation_metadata(
                    object_=mobile, annotation=ClientMobile, direction="write"
                ),
                "initiate_login_uri": initiate_login_uri,
                "native_social_login": convert_and_respect_annotation_metadata(
                    object_=native_social_login, annotation=NativeSocialLogin, direction="write"
                ),
                "refresh_token": convert_and_respect_annotation_metadata(
                    object_=refresh_token,
                    annotation=typing.Optional[ClientRefreshTokenConfiguration],
                    direction="write",
                ),
                "default_organization": convert_and_respect_annotation_metadata(
                    object_=default_organization,
                    annotation=typing.Optional[ClientDefaultOrganization],
                    direction="write",
                ),
                "organization_usage": organization_usage,
                "organization_require_behavior": organization_require_behavior,
                "organization_discovery_methods": organization_discovery_methods,
                "client_authentication_methods": convert_and_respect_annotation_metadata(
                    object_=client_authentication_methods,
                    annotation=ClientCreateAuthenticationMethod,
                    direction="write",
                ),
                "require_pushed_authorization_requests": require_pushed_authorization_requests,
                "require_proof_of_possession": require_proof_of_possession,
                "signed_request_object": convert_and_respect_annotation_metadata(
                    object_=signed_request_object, annotation=ClientSignedRequestObjectWithPublicKey, direction="write"
                ),
                "compliance_level": compliance_level,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "token_exchange": convert_and_respect_annotation_metadata(
                    object_=token_exchange, annotation=ClientTokenExchangeConfiguration, direction="write"
                ),
                "par_request_expiry": par_request_expiry,
                "token_quota": convert_and_respect_annotation_metadata(
                    object_=token_quota, annotation=CreateTokenQuota, direction="write"
                ),
                "resource_server_identifier": resource_server_identifier,
                "express_configuration": convert_and_respect_annotation_metadata(
                    object_=express_configuration, annotation=ExpressConfiguration, direction="write"
                ),
                "async_approval_notification_channels": async_approval_notification_channels,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateClientResponseContent,
                    parse_obj_as(
                        type_=CreateClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetClientResponseContent]:
        """
        Retrieve client details by ID. Clients are SSO connections or Applications linked with your Auth0 tenant. A list of fields to include or exclude may also be specified.
        For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.
        <ul>
          <li>
            The following properties can be retrieved with any of the scopes:
            <code>client_id</code>, <code>app_type</code>, <code>name</code>, and <code>description</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:clients</code> or
            <code>read:client_keys</code> scopes:
            <code>callbacks</code>, <code>oidc_logout</code>, <code>allowed_origins</code>,
            <code>web_origins</code>, <code>tenant</code>, <code>global</code>, <code>config_route</code>,
            <code>callback_url_template</code>, <code>jwt_configuration</code>,
            <code>jwt_configuration.lifetime_in_seconds</code>, <code>jwt_configuration.secret_encoded</code>,
            <code>jwt_configuration.scopes</code>, <code>jwt_configuration.alg</code>, <code>api_type</code>,
            <code>logo_uri</code>, <code>allowed_clients</code>, <code>owners</code>, <code>custom_login_page</code>,
            <code>custom_login_page_off</code>, <code>sso</code>, <code>addons</code>, <code>form_template</code>,
            <code>custom_login_page_codeview</code>, <code>resource_servers</code>, <code>client_metadata</code>,
            <code>mobile</code>, <code>mobile.android</code>, <code>mobile.ios</code>, <code>allowed_logout_urls</code>,
            <code>token_endpoint_auth_method</code>, <code>is_first_party</code>, <code>oidc_conformant</code>,
            <code>is_token_endpoint_ip_header_trusted</code>, <code>initiate_login_uri</code>, <code>grant_types</code>,
            <code>refresh_token</code>, <code>refresh_token.rotation_type</code>, <code>refresh_token.expiration_type</code>,
            <code>refresh_token.leeway</code>, <code>refresh_token.token_lifetime</code>, <code>refresh_token.policies</code>, <code>organization_usage</code>,
            <code>organization_require_behavior</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:client_keys</code> or <code>read:client_credentials</code> scopes:
            <code>encryption_key</code>, <code>encryption_key.pub</code>, <code>encryption_key.cert</code>,
            <code>client_secret</code>, <code>client_authentication_methods</code> and <code>signing_key</code>.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetClientResponseContent]
            Client successfully retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetClientResponseContent,
                    parse_obj_as(
                        type_=GetClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Delete a client and related configuration (rules, connections, etc).

        Parameters
        ----------
        id : str
            ID of the client to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        logo_uri: typing.Optional[str] = OMIT,
        callbacks: typing.Optional[typing.Sequence[str]] = OMIT,
        oidc_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        oidc_backchannel_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        session_transfer: typing.Optional[ClientSessionTransferConfiguration] = OMIT,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        web_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        grant_types: typing.Optional[typing.Sequence[str]] = OMIT,
        client_aliases: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        jwt_configuration: typing.Optional[ClientJwtConfiguration] = OMIT,
        encryption_key: typing.Optional[ClientEncryptionKey] = OMIT,
        sso: typing.Optional[bool] = OMIT,
        cross_origin_authentication: typing.Optional[bool] = OMIT,
        cross_origin_loc: typing.Optional[str] = OMIT,
        sso_disabled: typing.Optional[bool] = OMIT,
        custom_login_page_on: typing.Optional[bool] = OMIT,
        token_endpoint_auth_method: typing.Optional[ClientTokenEndpointAuthMethodOrNullEnum] = OMIT,
        is_token_endpoint_ip_header_trusted: typing.Optional[bool] = False,
        app_type: typing.Optional[ClientAppTypeEnum] = OMIT,
        is_first_party: typing.Optional[bool] = True,
        oidc_conformant: typing.Optional[bool] = False,
        custom_login_page: typing.Optional[str] = OMIT,
        custom_login_page_preview: typing.Optional[str] = OMIT,
        token_quota: typing.Optional[UpdateTokenQuota] = OMIT,
        form_template: typing.Optional[str] = OMIT,
        addons: typing.Optional[ClientAddons] = OMIT,
        client_metadata: typing.Optional[ClientMetadata] = OMIT,
        mobile: typing.Optional[ClientMobile] = OMIT,
        initiate_login_uri: typing.Optional[str] = OMIT,
        native_social_login: typing.Optional[NativeSocialLogin] = OMIT,
        refresh_token: typing.Optional[ClientRefreshTokenConfiguration] = OMIT,
        default_organization: typing.Optional[ClientDefaultOrganization] = OMIT,
        organization_usage: typing.Optional[ClientOrganizationUsagePatchEnum] = OMIT,
        organization_require_behavior: typing.Optional[ClientOrganizationRequireBehaviorPatchEnum] = OMIT,
        organization_discovery_methods: typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]] = OMIT,
        client_authentication_methods: typing.Optional[ClientAuthenticationMethod] = OMIT,
        require_pushed_authorization_requests: typing.Optional[bool] = False,
        require_proof_of_possession: typing.Optional[bool] = False,
        signed_request_object: typing.Optional[ClientSignedRequestObjectWithCredentialId] = OMIT,
        compliance_level: typing.Optional[ClientComplianceLevelEnum] = OMIT,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        token_exchange: typing.Optional[ClientTokenExchangeConfigurationOrNull] = OMIT,
        par_request_expiry: typing.Optional[int] = OMIT,
        express_configuration: typing.Optional[ExpressConfigurationOrNull] = OMIT,
        async_approval_notification_channels: typing.Optional[
            ClientAsyncApprovalNotificationsChannelsApiPatchConfiguration
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateClientResponseContent]:
        """
        Updates a client's settings. For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.

        Notes:
        - The `client_secret` and `signing_key` attributes can only be updated with the `update:client_keys` scope.
        - The <code>client_authentication_methods</code> and <code>token_endpoint_auth_method</code> properties are mutually exclusive. Use <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method. Otherwise, use <code>token_endpoint_auth_method</code> to configure the client with client secret (basic or post) or with no authentication method (none).
        - When using <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method, only specify the credential IDs that were generated when creating the credentials on the client.
        - To configure <code>client_authentication_methods</code>, the <code>update:client_credentials</code> scope is required.
        - To configure <code>client_authentication_methods</code>, the property <code>jwt_configuration.alg</code> must be set to RS256.
        - To change a client's <code>is_first_party</code> property to <code>false</code>, the <code>organization_usage</code> and <code>organization_require_behavior</code> properties must be unset.

        Parameters
        ----------
        id : str
            ID of the client to update.

        name : typing.Optional[str]
            The name of the client. Must contain at least one character. Does not allow '<' or '>'.

        description : typing.Optional[str]
            Free text description of the purpose of the Client. (Max character length: <code>140</code>)

        client_secret : typing.Optional[str]
            The secret used to sign tokens for the client

        logo_uri : typing.Optional[str]
            The URL of the client logo (recommended size: 150x150)

        callbacks : typing.Optional[typing.Sequence[str]]
            A set of URLs that are valid to call back from Auth0 when authenticating users

        oidc_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        oidc_backchannel_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        session_transfer : typing.Optional[ClientSessionTransferConfiguration]

        allowed_origins : typing.Optional[typing.Sequence[str]]
            A set of URLs that represents valid origins for CORS

        web_origins : typing.Optional[typing.Sequence[str]]
            A set of URLs that represents valid web origins for use with web message response mode

        grant_types : typing.Optional[typing.Sequence[str]]
            A set of grant types that the client is authorized to use. Can include `authorization_code`, `implicit`, `refresh_token`, `client_credentials`, `password`, `http://auth0.com/oauth/grant-type/password-realm`, `http://auth0.com/oauth/grant-type/mfa-oob`, `http://auth0.com/oauth/grant-type/mfa-otp`, `http://auth0.com/oauth/grant-type/mfa-recovery-code`, `urn:openid:params:grant-type:ciba`, `urn:ietf:params:oauth:grant-type:device_code`, and `urn:auth0:params:oauth:grant-type:token-exchange:federated-connection-access-token`.

        client_aliases : typing.Optional[typing.Sequence[str]]
            List of audiences for SAML protocol

        allowed_clients : typing.Optional[typing.Sequence[str]]
            Ids of clients that will be allowed to perform delegation requests. Clients that will be allowed to make delegation request. By default, all your clients will be allowed. This field allows you to specify specific clients

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        jwt_configuration : typing.Optional[ClientJwtConfiguration]

        encryption_key : typing.Optional[ClientEncryptionKey]

        sso : typing.Optional[bool]
            <code>true</code> to use Auth0 instead of the IdP to do Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        cross_origin_authentication : typing.Optional[bool]
            <code>true</code> if this client can be used to make cross-origin authentication requests, <code>false</code> otherwise if cross origin is disabled

        cross_origin_loc : typing.Optional[str]
            URL for the location in your site where the cross origin verification takes place for the cross-origin auth flow when performing Auth in your own domain instead of Auth0 hosted login page.

        sso_disabled : typing.Optional[bool]
            <code>true</code> to disable Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        custom_login_page_on : typing.Optional[bool]
            <code>true</code> if the custom login page is to be used, <code>false</code> otherwise.

        token_endpoint_auth_method : typing.Optional[ClientTokenEndpointAuthMethodOrNullEnum]

        is_token_endpoint_ip_header_trusted : typing.Optional[bool]
            If true, trust that the IP specified in the `auth0-forwarded-for` header is the end-user's IP for brute-force-protection on token endpoint.

        app_type : typing.Optional[ClientAppTypeEnum]

        is_first_party : typing.Optional[bool]
            Whether this client a first party client or not

        oidc_conformant : typing.Optional[bool]
            Whether this client will conform to strict OIDC specifications

        custom_login_page : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page

        custom_login_page_preview : typing.Optional[str]

        token_quota : typing.Optional[UpdateTokenQuota]

        form_template : typing.Optional[str]
            Form template for WS-Federation protocol

        addons : typing.Optional[ClientAddons]

        client_metadata : typing.Optional[ClientMetadata]

        mobile : typing.Optional[ClientMobile]

        initiate_login_uri : typing.Optional[str]
            Initiate login uri, must be https

        native_social_login : typing.Optional[NativeSocialLogin]

        refresh_token : typing.Optional[ClientRefreshTokenConfiguration]

        default_organization : typing.Optional[ClientDefaultOrganization]

        organization_usage : typing.Optional[ClientOrganizationUsagePatchEnum]

        organization_require_behavior : typing.Optional[ClientOrganizationRequireBehaviorPatchEnum]

        organization_discovery_methods : typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]]
            Defines the available methods for organization discovery during the `pre_login_prompt`. Users can discover their organization either by `email`, `organization_name` or both.

        client_authentication_methods : typing.Optional[ClientAuthenticationMethod]

        require_pushed_authorization_requests : typing.Optional[bool]
            Makes the use of Pushed Authorization Requests mandatory for this client

        require_proof_of_possession : typing.Optional[bool]
            Makes the use of Proof-of-Possession mandatory for this client

        signed_request_object : typing.Optional[ClientSignedRequestObjectWithCredentialId]

        compliance_level : typing.Optional[ClientComplianceLevelEnum]

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        token_exchange : typing.Optional[ClientTokenExchangeConfigurationOrNull]

        par_request_expiry : typing.Optional[int]
            Specifies how long, in seconds, a Pushed Authorization Request URI remains valid

        express_configuration : typing.Optional[ExpressConfigurationOrNull]

        async_approval_notification_channels : typing.Optional[ClientAsyncApprovalNotificationsChannelsApiPatchConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateClientResponseContent]
            Client successfully updated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "description": description,
                "client_secret": client_secret,
                "logo_uri": logo_uri,
                "callbacks": callbacks,
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "oidc_backchannel_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_backchannel_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "session_transfer": convert_and_respect_annotation_metadata(
                    object_=session_transfer,
                    annotation=typing.Optional[ClientSessionTransferConfiguration],
                    direction="write",
                ),
                "allowed_origins": allowed_origins,
                "web_origins": web_origins,
                "grant_types": grant_types,
                "client_aliases": client_aliases,
                "allowed_clients": allowed_clients,
                "allowed_logout_urls": allowed_logout_urls,
                "jwt_configuration": convert_and_respect_annotation_metadata(
                    object_=jwt_configuration, annotation=ClientJwtConfiguration, direction="write"
                ),
                "encryption_key": convert_and_respect_annotation_metadata(
                    object_=encryption_key, annotation=typing.Optional[ClientEncryptionKey], direction="write"
                ),
                "sso": sso,
                "cross_origin_authentication": cross_origin_authentication,
                "cross_origin_loc": cross_origin_loc,
                "sso_disabled": sso_disabled,
                "custom_login_page_on": custom_login_page_on,
                "token_endpoint_auth_method": token_endpoint_auth_method,
                "is_token_endpoint_ip_header_trusted": is_token_endpoint_ip_header_trusted,
                "app_type": app_type,
                "is_first_party": is_first_party,
                "oidc_conformant": oidc_conformant,
                "custom_login_page": custom_login_page,
                "custom_login_page_preview": custom_login_page_preview,
                "token_quota": convert_and_respect_annotation_metadata(
                    object_=token_quota, annotation=typing.Optional[UpdateTokenQuota], direction="write"
                ),
                "form_template": form_template,
                "addons": convert_and_respect_annotation_metadata(
                    object_=addons, annotation=ClientAddons, direction="write"
                ),
                "client_metadata": client_metadata,
                "mobile": convert_and_respect_annotation_metadata(
                    object_=mobile, annotation=ClientMobile, direction="write"
                ),
                "initiate_login_uri": initiate_login_uri,
                "native_social_login": convert_and_respect_annotation_metadata(
                    object_=native_social_login, annotation=NativeSocialLogin, direction="write"
                ),
                "refresh_token": convert_and_respect_annotation_metadata(
                    object_=refresh_token,
                    annotation=typing.Optional[ClientRefreshTokenConfiguration],
                    direction="write",
                ),
                "default_organization": convert_and_respect_annotation_metadata(
                    object_=default_organization,
                    annotation=typing.Optional[ClientDefaultOrganization],
                    direction="write",
                ),
                "organization_usage": organization_usage,
                "organization_require_behavior": organization_require_behavior,
                "organization_discovery_methods": organization_discovery_methods,
                "client_authentication_methods": convert_and_respect_annotation_metadata(
                    object_=client_authentication_methods,
                    annotation=typing.Optional[ClientAuthenticationMethod],
                    direction="write",
                ),
                "require_pushed_authorization_requests": require_pushed_authorization_requests,
                "require_proof_of_possession": require_proof_of_possession,
                "signed_request_object": convert_and_respect_annotation_metadata(
                    object_=signed_request_object,
                    annotation=ClientSignedRequestObjectWithCredentialId,
                    direction="write",
                ),
                "compliance_level": compliance_level,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "token_exchange": convert_and_respect_annotation_metadata(
                    object_=token_exchange,
                    annotation=typing.Optional[ClientTokenExchangeConfigurationOrNull],
                    direction="write",
                ),
                "par_request_expiry": par_request_expiry,
                "express_configuration": convert_and_respect_annotation_metadata(
                    object_=express_configuration,
                    annotation=typing.Optional[ExpressConfigurationOrNull],
                    direction="write",
                ),
                "async_approval_notification_channels": async_approval_notification_channels,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateClientResponseContent,
                    parse_obj_as(
                        type_=UpdateClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def rotate_secret(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[RotateClientSecretResponseContent]:
        """
        Rotate a client secret.

        This endpoint cannot be used with clients configured with Private Key JWT authentication method (client_authentication_methods configured with private_key_jwt). The generated secret is NOT base64 encoded.

        For more information, read <a href="https://www.auth0.com/docs/get-started/applications/rotate-client-secret">Rotate Client Secrets</a>.

        Parameters
        ----------
        id : str
            ID of the client that will rotate secrets.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RotateClientSecretResponseContent]
            Secret successfully rotated.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}/rotate-secret",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RotateClientSecretResponseContent,
                    parse_obj_as(
                        type_=RotateClientSecretResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawClientsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        page: typing.Optional[int] = 0,
        per_page: typing.Optional[int] = 50,
        include_totals: typing.Optional[bool] = True,
        is_global: typing.Optional[bool] = None,
        is_first_party: typing.Optional[bool] = None,
        app_type: typing.Optional[str] = None,
        q: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Client, ListClientsOffsetPaginatedResponseContent]:
        """
        Retrieve clients (applications and SSO integrations) matching provided filters. A list of fields to include or exclude may also be specified.
        For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.

        <ul>
          <li>
            The following can be retrieved with any scope:
            <code>client_id</code>, <code>app_type</code>, <code>name</code>, and <code>description</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:clients</code> or
            <code>read:client_keys</code> scope:
            <code>callbacks</code>, <code>oidc_logout</code>, <code>allowed_origins</code>,
            <code>web_origins</code>, <code>tenant</code>, <code>global</code>, <code>config_route</code>,
            <code>callback_url_template</code>, <code>jwt_configuration</code>,
            <code>jwt_configuration.lifetime_in_seconds</code>, <code>jwt_configuration.secret_encoded</code>,
            <code>jwt_configuration.scopes</code>, <code>jwt_configuration.alg</code>, <code>api_type</code>,
            <code>logo_uri</code>, <code>allowed_clients</code>, <code>owners</code>, <code>custom_login_page</code>,
            <code>custom_login_page_off</code>, <code>sso</code>, <code>addons</code>, <code>form_template</code>,
            <code>custom_login_page_codeview</code>, <code>resource_servers</code>, <code>client_metadata</code>,
            <code>mobile</code>, <code>mobile.android</code>, <code>mobile.ios</code>, <code>allowed_logout_urls</code>,
            <code>token_endpoint_auth_method</code>, <code>is_first_party</code>, <code>oidc_conformant</code>,
            <code>is_token_endpoint_ip_header_trusted</code>, <code>initiate_login_uri</code>, <code>grant_types</code>,
            <code>refresh_token</code>, <code>refresh_token.rotation_type</code>, <code>refresh_token.expiration_type</code>,
            <code>refresh_token.leeway</code>, <code>refresh_token.token_lifetime</code>, <code>refresh_token.policies</code>, <code>organization_usage</code>,
            <code>organization_require_behavior</code>.
          </li>
          <li>
            The following properties can only be retrieved with the
            <code>read:client_keys</code> or <code>read:client_credentials</code> scope:
            <code>encryption_key</code>, <code>encryption_key.pub</code>, <code>encryption_key.cert</code>,
            <code>client_secret</code>, <code>client_authentication_methods</code> and <code>signing_key</code>.
          </li>
        </ul>

        Parameters
        ----------
        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        page : typing.Optional[int]
            Page index of the results to return. First page is 0.

        per_page : typing.Optional[int]
            Number of results per page. Default value is 50, maximum value is 100

        include_totals : typing.Optional[bool]
            Return results inside an object that contains the total result count (true) or as a direct array of results (false, default).

        is_global : typing.Optional[bool]
            Optional filter on the global client parameter.

        is_first_party : typing.Optional[bool]
            Optional filter on whether or not a client is a first-party client.

        app_type : typing.Optional[str]
            Optional filter by a comma-separated list of application types.

        q : typing.Optional[str]
            Advanced Query in <a href="http://www.lucenetutorial.com/lucene-query-syntax.html">Lucene</a> syntax.<br /><b>Permitted Queries</b>:<br /><ul><li><i>client_grant.organization_id:{organization_id}</i></li><li><i>client_grant.allow_any_organization:true</i></li></ul><b>Additional Restrictions</b>:<br /><ul><li>Cannot be used in combination with other filters</li><li>Requires use of the <i>from</i> and <i>take</i> paging parameters (checkpoint paginatinon)</li><li>Reduced rate limits apply. See <a href="https://auth0.com/docs/troubleshoot/customer-support/operational-policies/rate-limit-policy/rate-limit-configurations/enterprise-public">Rate Limit Configurations</a></li></ul><i><b>Note</b>: Recent updates may not be immediately reflected in query results</i>

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Client, ListClientsOffsetPaginatedResponseContent]
            Clients successfully retrieved.
        """
        page = page if page is not None else 0

        _response = await self._client_wrapper.httpx_client.request(
            "clients",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
                "page": page,
                "per_page": per_page,
                "include_totals": include_totals,
                "is_global": is_global,
                "is_first_party": is_first_party,
                "app_type": app_type,
                "q": q,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListClientsOffsetPaginatedResponseContent,
                    parse_obj_as(
                        type_=ListClientsOffsetPaginatedResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.clients
                _has_next = True

                async def _get_next():
                    return await self.list(
                        fields=fields,
                        include_fields=include_fields,
                        page=page + len(_items or []),
                        per_page=per_page,
                        include_totals=include_totals,
                        is_global=is_global,
                        is_first_party=is_first_party,
                        app_type=app_type,
                        q=q,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        logo_uri: typing.Optional[str] = OMIT,
        callbacks: typing.Optional[typing.Sequence[str]] = OMIT,
        oidc_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        oidc_backchannel_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        session_transfer: typing.Optional[ClientSessionTransferConfiguration] = OMIT,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        web_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        client_aliases: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        grant_types: typing.Optional[typing.Sequence[str]] = OMIT,
        token_endpoint_auth_method: typing.Optional[ClientTokenEndpointAuthMethodEnum] = OMIT,
        is_token_endpoint_ip_header_trusted: typing.Optional[bool] = False,
        app_type: typing.Optional[ClientAppTypeEnum] = OMIT,
        is_first_party: typing.Optional[bool] = True,
        oidc_conformant: typing.Optional[bool] = False,
        jwt_configuration: typing.Optional[ClientJwtConfiguration] = OMIT,
        encryption_key: typing.Optional[ClientEncryptionKey] = OMIT,
        sso: typing.Optional[bool] = OMIT,
        cross_origin_authentication: typing.Optional[bool] = False,
        cross_origin_loc: typing.Optional[str] = OMIT,
        sso_disabled: typing.Optional[bool] = OMIT,
        custom_login_page_on: typing.Optional[bool] = OMIT,
        custom_login_page: typing.Optional[str] = OMIT,
        custom_login_page_preview: typing.Optional[str] = OMIT,
        form_template: typing.Optional[str] = OMIT,
        addons: typing.Optional[ClientAddons] = OMIT,
        client_metadata: typing.Optional[ClientMetadata] = OMIT,
        mobile: typing.Optional[ClientMobile] = OMIT,
        initiate_login_uri: typing.Optional[str] = OMIT,
        native_social_login: typing.Optional[NativeSocialLogin] = OMIT,
        refresh_token: typing.Optional[ClientRefreshTokenConfiguration] = OMIT,
        default_organization: typing.Optional[ClientDefaultOrganization] = OMIT,
        organization_usage: typing.Optional[ClientOrganizationUsageEnum] = OMIT,
        organization_require_behavior: typing.Optional[ClientOrganizationRequireBehaviorEnum] = OMIT,
        organization_discovery_methods: typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]] = OMIT,
        client_authentication_methods: typing.Optional[ClientCreateAuthenticationMethod] = OMIT,
        require_pushed_authorization_requests: typing.Optional[bool] = False,
        require_proof_of_possession: typing.Optional[bool] = False,
        signed_request_object: typing.Optional[ClientSignedRequestObjectWithPublicKey] = OMIT,
        compliance_level: typing.Optional[ClientComplianceLevelEnum] = OMIT,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        token_exchange: typing.Optional[ClientTokenExchangeConfiguration] = OMIT,
        par_request_expiry: typing.Optional[int] = OMIT,
        token_quota: typing.Optional[CreateTokenQuota] = OMIT,
        resource_server_identifier: typing.Optional[str] = OMIT,
        express_configuration: typing.Optional[ExpressConfiguration] = OMIT,
        async_approval_notification_channels: typing.Optional[
            ClientAsyncApprovalNotificationsChannelsApiPostConfiguration
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateClientResponseContent]:
        """
        Create a new client (application or SSO integration). For more information, read <a href="https://www.auth0.com/docs/get-started/auth0-overview/create-applications">Create Applications</a>
        <a href="https://www.auth0.com/docs/authenticate/single-sign-on/api-endpoints-for-single-sign-on>">API Endpoints for Single Sign-On</a>.

        Notes:
        - We recommend leaving the `client_secret` parameter unspecified to allow the generation of a safe secret.
        - The <code>client_authentication_methods</code> and <code>token_endpoint_auth_method</code> properties are mutually exclusive. Use
        <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method. Otherwise, use <code>token_endpoint_auth_method</code>
        to configure the client with client secret (basic or post) or with no authentication method (none).
        - When using <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method, specify fully defined credentials.
        These credentials will be automatically enabled for Private Key JWT authentication on the client.
        - To configure <code>client_authentication_methods</code>, the <code>create:client_credentials</code> scope is required.
        - To configure <code>client_authentication_methods</code>, the property <code>jwt_configuration.alg</code> must be set to RS256.

        <div class="alert alert-warning">SSO Integrations created via this endpoint will accept login requests and share user profile information.</div>

        Parameters
        ----------
        name : str
            Name of this client (min length: 1 character, does not allow `<` or `>`).

        description : typing.Optional[str]
            Free text description of this client (max length: 140 characters).

        logo_uri : typing.Optional[str]
            URL of the logo to display for this client. Recommended size is 150x150 pixels.

        callbacks : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs whitelisted for Auth0 to use as a callback to the client after authentication.

        oidc_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        oidc_backchannel_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        session_transfer : typing.Optional[ClientSessionTransferConfiguration]

        allowed_origins : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs allowed to make requests from JavaScript to Auth0 API (typically used with CORS). By default, all your callback URLs will be allowed. This field allows you to enter other origins if necessary. You can also use wildcards at the subdomain level (e.g., https://*.contoso.com). Query strings and hash information are not taken into account when validating these URLs.

        web_origins : typing.Optional[typing.Sequence[str]]
            Comma-separated list of allowed origins for use with <a href='https://auth0.com/docs/cross-origin-authentication'>Cross-Origin Authentication</a>, <a href='https://auth0.com/docs/flows/concepts/device-auth'>Device Flow</a>, and <a href='https://auth0.com/docs/protocols/oauth2#how-response-mode-works'>web message response mode</a>.

        client_aliases : typing.Optional[typing.Sequence[str]]
            List of audiences/realms for SAML protocol. Used by the wsfed addon.

        allowed_clients : typing.Optional[typing.Sequence[str]]
            List of allow clients and API ids that are allowed to make delegation requests. Empty means all all your clients are allowed.

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            Comma-separated list of URLs that are valid to redirect to after logout from Auth0. Wildcards are allowed for subdomains.

        grant_types : typing.Optional[typing.Sequence[str]]
            List of grant types supported for this application. Can include `authorization_code`, `implicit`, `refresh_token`, `client_credentials`, `password`, `http://auth0.com/oauth/grant-type/password-realm`, `http://auth0.com/oauth/grant-type/mfa-oob`, `http://auth0.com/oauth/grant-type/mfa-otp`, `http://auth0.com/oauth/grant-type/mfa-recovery-code`, `urn:openid:params:grant-type:ciba`, `urn:ietf:params:oauth:grant-type:device_code`, and `urn:auth0:params:oauth:grant-type:token-exchange:federated-connection-access-token`.

        token_endpoint_auth_method : typing.Optional[ClientTokenEndpointAuthMethodEnum]

        is_token_endpoint_ip_header_trusted : typing.Optional[bool]
            If true, trust that the IP specified in the `auth0-forwarded-for` header is the end-user's IP for brute-force-protection on token endpoint.

        app_type : typing.Optional[ClientAppTypeEnum]

        is_first_party : typing.Optional[bool]
            Whether this client a first party client or not

        oidc_conformant : typing.Optional[bool]
            Whether this client conforms to <a href='https://auth0.com/docs/api-auth/tutorials/adoption'>strict OIDC specifications</a> (true) or uses legacy features (false).

        jwt_configuration : typing.Optional[ClientJwtConfiguration]

        encryption_key : typing.Optional[ClientEncryptionKey]

        sso : typing.Optional[bool]
            Applies only to SSO clients and determines whether Auth0 will handle Single Sign On (true) or whether the Identity Provider will (false).

        cross_origin_authentication : typing.Optional[bool]
            Whether this client can be used to make cross-origin authentication requests (true) or it is not allowed to make such requests (false).

        cross_origin_loc : typing.Optional[str]
            URL of the location in your site where the cross origin verification takes place for the cross-origin auth flow when performing Auth in your own domain instead of Auth0 hosted login page.

        sso_disabled : typing.Optional[bool]
            <code>true</code> to disable Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        custom_login_page_on : typing.Optional[bool]
            <code>true</code> if the custom login page is to be used, <code>false</code> otherwise. Defaults to <code>true</code>

        custom_login_page : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page.

        custom_login_page_preview : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page. (Used on Previews)

        form_template : typing.Optional[str]
            HTML form template to be used for WS-Federation.

        addons : typing.Optional[ClientAddons]

        client_metadata : typing.Optional[ClientMetadata]

        mobile : typing.Optional[ClientMobile]

        initiate_login_uri : typing.Optional[str]
            Initiate login uri, must be https

        native_social_login : typing.Optional[NativeSocialLogin]

        refresh_token : typing.Optional[ClientRefreshTokenConfiguration]

        default_organization : typing.Optional[ClientDefaultOrganization]

        organization_usage : typing.Optional[ClientOrganizationUsageEnum]

        organization_require_behavior : typing.Optional[ClientOrganizationRequireBehaviorEnum]

        organization_discovery_methods : typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]]
            Defines the available methods for organization discovery during the `pre_login_prompt`. Users can discover their organization either by `email`, `organization_name` or both.

        client_authentication_methods : typing.Optional[ClientCreateAuthenticationMethod]

        require_pushed_authorization_requests : typing.Optional[bool]
            Makes the use of Pushed Authorization Requests mandatory for this client

        require_proof_of_possession : typing.Optional[bool]
            Makes the use of Proof-of-Possession mandatory for this client

        signed_request_object : typing.Optional[ClientSignedRequestObjectWithPublicKey]

        compliance_level : typing.Optional[ClientComplianceLevelEnum]

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        token_exchange : typing.Optional[ClientTokenExchangeConfiguration]

        par_request_expiry : typing.Optional[int]
            Specifies how long, in seconds, a Pushed Authorization Request URI remains valid

        token_quota : typing.Optional[CreateTokenQuota]

        resource_server_identifier : typing.Optional[str]
            The identifier of the resource server that this client is linked to.

        express_configuration : typing.Optional[ExpressConfiguration]

        async_approval_notification_channels : typing.Optional[ClientAsyncApprovalNotificationsChannelsApiPostConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateClientResponseContent]
            Client successfully created.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "clients",
            method="POST",
            json={
                "name": name,
                "description": description,
                "logo_uri": logo_uri,
                "callbacks": callbacks,
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "oidc_backchannel_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_backchannel_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "session_transfer": convert_and_respect_annotation_metadata(
                    object_=session_transfer,
                    annotation=typing.Optional[ClientSessionTransferConfiguration],
                    direction="write",
                ),
                "allowed_origins": allowed_origins,
                "web_origins": web_origins,
                "client_aliases": client_aliases,
                "allowed_clients": allowed_clients,
                "allowed_logout_urls": allowed_logout_urls,
                "grant_types": grant_types,
                "token_endpoint_auth_method": token_endpoint_auth_method,
                "is_token_endpoint_ip_header_trusted": is_token_endpoint_ip_header_trusted,
                "app_type": app_type,
                "is_first_party": is_first_party,
                "oidc_conformant": oidc_conformant,
                "jwt_configuration": convert_and_respect_annotation_metadata(
                    object_=jwt_configuration, annotation=ClientJwtConfiguration, direction="write"
                ),
                "encryption_key": convert_and_respect_annotation_metadata(
                    object_=encryption_key, annotation=typing.Optional[ClientEncryptionKey], direction="write"
                ),
                "sso": sso,
                "cross_origin_authentication": cross_origin_authentication,
                "cross_origin_loc": cross_origin_loc,
                "sso_disabled": sso_disabled,
                "custom_login_page_on": custom_login_page_on,
                "custom_login_page": custom_login_page,
                "custom_login_page_preview": custom_login_page_preview,
                "form_template": form_template,
                "addons": convert_and_respect_annotation_metadata(
                    object_=addons, annotation=ClientAddons, direction="write"
                ),
                "client_metadata": client_metadata,
                "mobile": convert_and_respect_annotation_metadata(
                    object_=mobile, annotation=ClientMobile, direction="write"
                ),
                "initiate_login_uri": initiate_login_uri,
                "native_social_login": convert_and_respect_annotation_metadata(
                    object_=native_social_login, annotation=NativeSocialLogin, direction="write"
                ),
                "refresh_token": convert_and_respect_annotation_metadata(
                    object_=refresh_token,
                    annotation=typing.Optional[ClientRefreshTokenConfiguration],
                    direction="write",
                ),
                "default_organization": convert_and_respect_annotation_metadata(
                    object_=default_organization,
                    annotation=typing.Optional[ClientDefaultOrganization],
                    direction="write",
                ),
                "organization_usage": organization_usage,
                "organization_require_behavior": organization_require_behavior,
                "organization_discovery_methods": organization_discovery_methods,
                "client_authentication_methods": convert_and_respect_annotation_metadata(
                    object_=client_authentication_methods,
                    annotation=ClientCreateAuthenticationMethod,
                    direction="write",
                ),
                "require_pushed_authorization_requests": require_pushed_authorization_requests,
                "require_proof_of_possession": require_proof_of_possession,
                "signed_request_object": convert_and_respect_annotation_metadata(
                    object_=signed_request_object, annotation=ClientSignedRequestObjectWithPublicKey, direction="write"
                ),
                "compliance_level": compliance_level,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "token_exchange": convert_and_respect_annotation_metadata(
                    object_=token_exchange, annotation=ClientTokenExchangeConfiguration, direction="write"
                ),
                "par_request_expiry": par_request_expiry,
                "token_quota": convert_and_respect_annotation_metadata(
                    object_=token_quota, annotation=CreateTokenQuota, direction="write"
                ),
                "resource_server_identifier": resource_server_identifier,
                "express_configuration": convert_and_respect_annotation_metadata(
                    object_=express_configuration, annotation=ExpressConfiguration, direction="write"
                ),
                "async_approval_notification_channels": async_approval_notification_channels,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateClientResponseContent,
                    parse_obj_as(
                        type_=CreateClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 409:
                raise ConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetClientResponseContent]:
        """
        Retrieve client details by ID. Clients are SSO connections or Applications linked with your Auth0 tenant. A list of fields to include or exclude may also be specified.
        For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.
        <ul>
          <li>
            The following properties can be retrieved with any of the scopes:
            <code>client_id</code>, <code>app_type</code>, <code>name</code>, and <code>description</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:clients</code> or
            <code>read:client_keys</code> scopes:
            <code>callbacks</code>, <code>oidc_logout</code>, <code>allowed_origins</code>,
            <code>web_origins</code>, <code>tenant</code>, <code>global</code>, <code>config_route</code>,
            <code>callback_url_template</code>, <code>jwt_configuration</code>,
            <code>jwt_configuration.lifetime_in_seconds</code>, <code>jwt_configuration.secret_encoded</code>,
            <code>jwt_configuration.scopes</code>, <code>jwt_configuration.alg</code>, <code>api_type</code>,
            <code>logo_uri</code>, <code>allowed_clients</code>, <code>owners</code>, <code>custom_login_page</code>,
            <code>custom_login_page_off</code>, <code>sso</code>, <code>addons</code>, <code>form_template</code>,
            <code>custom_login_page_codeview</code>, <code>resource_servers</code>, <code>client_metadata</code>,
            <code>mobile</code>, <code>mobile.android</code>, <code>mobile.ios</code>, <code>allowed_logout_urls</code>,
            <code>token_endpoint_auth_method</code>, <code>is_first_party</code>, <code>oidc_conformant</code>,
            <code>is_token_endpoint_ip_header_trusted</code>, <code>initiate_login_uri</code>, <code>grant_types</code>,
            <code>refresh_token</code>, <code>refresh_token.rotation_type</code>, <code>refresh_token.expiration_type</code>,
            <code>refresh_token.leeway</code>, <code>refresh_token.token_lifetime</code>, <code>refresh_token.policies</code>, <code>organization_usage</code>,
            <code>organization_require_behavior</code>.
          </li>
          <li>
            The following properties can only be retrieved with the <code>read:client_keys</code> or <code>read:client_credentials</code> scopes:
            <code>encryption_key</code>, <code>encryption_key.pub</code>, <code>encryption_key.cert</code>,
            <code>client_secret</code>, <code>client_authentication_methods</code> and <code>signing_key</code>.
          </li>
        </ul>

        Parameters
        ----------
        id : str
            ID of the client to retrieve.

        fields : typing.Optional[str]
            Comma-separated list of fields to include or exclude (based on value provided for include_fields) in the result. Leave empty to retrieve all fields.

        include_fields : typing.Optional[bool]
            Whether specified fields are to be included (true) or excluded (false).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetClientResponseContent]
            Client successfully retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="GET",
            params={
                "fields": fields,
                "include_fields": include_fields,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetClientResponseContent,
                    parse_obj_as(
                        type_=GetClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Delete a client and related configuration (rules, connections, etc).

        Parameters
        ----------
        id : str
            ID of the client to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        logo_uri: typing.Optional[str] = OMIT,
        callbacks: typing.Optional[typing.Sequence[str]] = OMIT,
        oidc_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        oidc_backchannel_logout: typing.Optional[ClientOidcBackchannelLogoutSettings] = OMIT,
        session_transfer: typing.Optional[ClientSessionTransferConfiguration] = OMIT,
        allowed_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        web_origins: typing.Optional[typing.Sequence[str]] = OMIT,
        grant_types: typing.Optional[typing.Sequence[str]] = OMIT,
        client_aliases: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        allowed_logout_urls: typing.Optional[typing.Sequence[str]] = OMIT,
        jwt_configuration: typing.Optional[ClientJwtConfiguration] = OMIT,
        encryption_key: typing.Optional[ClientEncryptionKey] = OMIT,
        sso: typing.Optional[bool] = OMIT,
        cross_origin_authentication: typing.Optional[bool] = OMIT,
        cross_origin_loc: typing.Optional[str] = OMIT,
        sso_disabled: typing.Optional[bool] = OMIT,
        custom_login_page_on: typing.Optional[bool] = OMIT,
        token_endpoint_auth_method: typing.Optional[ClientTokenEndpointAuthMethodOrNullEnum] = OMIT,
        is_token_endpoint_ip_header_trusted: typing.Optional[bool] = False,
        app_type: typing.Optional[ClientAppTypeEnum] = OMIT,
        is_first_party: typing.Optional[bool] = True,
        oidc_conformant: typing.Optional[bool] = False,
        custom_login_page: typing.Optional[str] = OMIT,
        custom_login_page_preview: typing.Optional[str] = OMIT,
        token_quota: typing.Optional[UpdateTokenQuota] = OMIT,
        form_template: typing.Optional[str] = OMIT,
        addons: typing.Optional[ClientAddons] = OMIT,
        client_metadata: typing.Optional[ClientMetadata] = OMIT,
        mobile: typing.Optional[ClientMobile] = OMIT,
        initiate_login_uri: typing.Optional[str] = OMIT,
        native_social_login: typing.Optional[NativeSocialLogin] = OMIT,
        refresh_token: typing.Optional[ClientRefreshTokenConfiguration] = OMIT,
        default_organization: typing.Optional[ClientDefaultOrganization] = OMIT,
        organization_usage: typing.Optional[ClientOrganizationUsagePatchEnum] = OMIT,
        organization_require_behavior: typing.Optional[ClientOrganizationRequireBehaviorPatchEnum] = OMIT,
        organization_discovery_methods: typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]] = OMIT,
        client_authentication_methods: typing.Optional[ClientAuthenticationMethod] = OMIT,
        require_pushed_authorization_requests: typing.Optional[bool] = False,
        require_proof_of_possession: typing.Optional[bool] = False,
        signed_request_object: typing.Optional[ClientSignedRequestObjectWithCredentialId] = OMIT,
        compliance_level: typing.Optional[ClientComplianceLevelEnum] = OMIT,
        skip_non_verifiable_callback_uri_confirmation_prompt: typing.Optional[bool] = OMIT,
        token_exchange: typing.Optional[ClientTokenExchangeConfigurationOrNull] = OMIT,
        par_request_expiry: typing.Optional[int] = OMIT,
        express_configuration: typing.Optional[ExpressConfigurationOrNull] = OMIT,
        async_approval_notification_channels: typing.Optional[
            ClientAsyncApprovalNotificationsChannelsApiPatchConfiguration
        ] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateClientResponseContent]:
        """
        Updates a client's settings. For more information, read <a href="https://www.auth0.com/docs/get-started/applications"> Applications in Auth0</a> and <a href="https://www.auth0.com/docs/authenticate/single-sign-on"> Single Sign-On</a>.

        Notes:
        - The `client_secret` and `signing_key` attributes can only be updated with the `update:client_keys` scope.
        - The <code>client_authentication_methods</code> and <code>token_endpoint_auth_method</code> properties are mutually exclusive. Use <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method. Otherwise, use <code>token_endpoint_auth_method</code> to configure the client with client secret (basic or post) or with no authentication method (none).
        - When using <code>client_authentication_methods</code> to configure the client with Private Key JWT authentication method, only specify the credential IDs that were generated when creating the credentials on the client.
        - To configure <code>client_authentication_methods</code>, the <code>update:client_credentials</code> scope is required.
        - To configure <code>client_authentication_methods</code>, the property <code>jwt_configuration.alg</code> must be set to RS256.
        - To change a client's <code>is_first_party</code> property to <code>false</code>, the <code>organization_usage</code> and <code>organization_require_behavior</code> properties must be unset.

        Parameters
        ----------
        id : str
            ID of the client to update.

        name : typing.Optional[str]
            The name of the client. Must contain at least one character. Does not allow '<' or '>'.

        description : typing.Optional[str]
            Free text description of the purpose of the Client. (Max character length: <code>140</code>)

        client_secret : typing.Optional[str]
            The secret used to sign tokens for the client

        logo_uri : typing.Optional[str]
            The URL of the client logo (recommended size: 150x150)

        callbacks : typing.Optional[typing.Sequence[str]]
            A set of URLs that are valid to call back from Auth0 when authenticating users

        oidc_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        oidc_backchannel_logout : typing.Optional[ClientOidcBackchannelLogoutSettings]

        session_transfer : typing.Optional[ClientSessionTransferConfiguration]

        allowed_origins : typing.Optional[typing.Sequence[str]]
            A set of URLs that represents valid origins for CORS

        web_origins : typing.Optional[typing.Sequence[str]]
            A set of URLs that represents valid web origins for use with web message response mode

        grant_types : typing.Optional[typing.Sequence[str]]
            A set of grant types that the client is authorized to use. Can include `authorization_code`, `implicit`, `refresh_token`, `client_credentials`, `password`, `http://auth0.com/oauth/grant-type/password-realm`, `http://auth0.com/oauth/grant-type/mfa-oob`, `http://auth0.com/oauth/grant-type/mfa-otp`, `http://auth0.com/oauth/grant-type/mfa-recovery-code`, `urn:openid:params:grant-type:ciba`, `urn:ietf:params:oauth:grant-type:device_code`, and `urn:auth0:params:oauth:grant-type:token-exchange:federated-connection-access-token`.

        client_aliases : typing.Optional[typing.Sequence[str]]
            List of audiences for SAML protocol

        allowed_clients : typing.Optional[typing.Sequence[str]]
            Ids of clients that will be allowed to perform delegation requests. Clients that will be allowed to make delegation request. By default, all your clients will be allowed. This field allows you to specify specific clients

        allowed_logout_urls : typing.Optional[typing.Sequence[str]]
            URLs that are valid to redirect to after logout from Auth0.

        jwt_configuration : typing.Optional[ClientJwtConfiguration]

        encryption_key : typing.Optional[ClientEncryptionKey]

        sso : typing.Optional[bool]
            <code>true</code> to use Auth0 instead of the IdP to do Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        cross_origin_authentication : typing.Optional[bool]
            <code>true</code> if this client can be used to make cross-origin authentication requests, <code>false</code> otherwise if cross origin is disabled

        cross_origin_loc : typing.Optional[str]
            URL for the location in your site where the cross origin verification takes place for the cross-origin auth flow when performing Auth in your own domain instead of Auth0 hosted login page.

        sso_disabled : typing.Optional[bool]
            <code>true</code> to disable Single Sign On, <code>false</code> otherwise (default: <code>false</code>)

        custom_login_page_on : typing.Optional[bool]
            <code>true</code> if the custom login page is to be used, <code>false</code> otherwise.

        token_endpoint_auth_method : typing.Optional[ClientTokenEndpointAuthMethodOrNullEnum]

        is_token_endpoint_ip_header_trusted : typing.Optional[bool]
            If true, trust that the IP specified in the `auth0-forwarded-for` header is the end-user's IP for brute-force-protection on token endpoint.

        app_type : typing.Optional[ClientAppTypeEnum]

        is_first_party : typing.Optional[bool]
            Whether this client a first party client or not

        oidc_conformant : typing.Optional[bool]
            Whether this client will conform to strict OIDC specifications

        custom_login_page : typing.Optional[str]
            The content (HTML, CSS, JS) of the custom login page

        custom_login_page_preview : typing.Optional[str]

        token_quota : typing.Optional[UpdateTokenQuota]

        form_template : typing.Optional[str]
            Form template for WS-Federation protocol

        addons : typing.Optional[ClientAddons]

        client_metadata : typing.Optional[ClientMetadata]

        mobile : typing.Optional[ClientMobile]

        initiate_login_uri : typing.Optional[str]
            Initiate login uri, must be https

        native_social_login : typing.Optional[NativeSocialLogin]

        refresh_token : typing.Optional[ClientRefreshTokenConfiguration]

        default_organization : typing.Optional[ClientDefaultOrganization]

        organization_usage : typing.Optional[ClientOrganizationUsagePatchEnum]

        organization_require_behavior : typing.Optional[ClientOrganizationRequireBehaviorPatchEnum]

        organization_discovery_methods : typing.Optional[typing.Sequence[ClientOrganizationDiscoveryEnum]]
            Defines the available methods for organization discovery during the `pre_login_prompt`. Users can discover their organization either by `email`, `organization_name` or both.

        client_authentication_methods : typing.Optional[ClientAuthenticationMethod]

        require_pushed_authorization_requests : typing.Optional[bool]
            Makes the use of Pushed Authorization Requests mandatory for this client

        require_proof_of_possession : typing.Optional[bool]
            Makes the use of Proof-of-Possession mandatory for this client

        signed_request_object : typing.Optional[ClientSignedRequestObjectWithCredentialId]

        compliance_level : typing.Optional[ClientComplianceLevelEnum]

        skip_non_verifiable_callback_uri_confirmation_prompt : typing.Optional[bool]
            Controls whether a confirmation prompt is shown during login flows when the redirect URI uses non-verifiable callback URIs (for example, a custom URI schema such as `myapp://`, or `localhost`).
            If set to true, a confirmation prompt will not be shown. We recommend that this is set to false for improved protection from malicious apps.
            See https://auth0.com/docs/secure/security-guidance/measures-against-app-impersonation for more information.

        token_exchange : typing.Optional[ClientTokenExchangeConfigurationOrNull]

        par_request_expiry : typing.Optional[int]
            Specifies how long, in seconds, a Pushed Authorization Request URI remains valid

        express_configuration : typing.Optional[ExpressConfigurationOrNull]

        async_approval_notification_channels : typing.Optional[ClientAsyncApprovalNotificationsChannelsApiPatchConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateClientResponseContent]
            Client successfully updated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "name": name,
                "description": description,
                "client_secret": client_secret,
                "logo_uri": logo_uri,
                "callbacks": callbacks,
                "oidc_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "oidc_backchannel_logout": convert_and_respect_annotation_metadata(
                    object_=oidc_backchannel_logout, annotation=ClientOidcBackchannelLogoutSettings, direction="write"
                ),
                "session_transfer": convert_and_respect_annotation_metadata(
                    object_=session_transfer,
                    annotation=typing.Optional[ClientSessionTransferConfiguration],
                    direction="write",
                ),
                "allowed_origins": allowed_origins,
                "web_origins": web_origins,
                "grant_types": grant_types,
                "client_aliases": client_aliases,
                "allowed_clients": allowed_clients,
                "allowed_logout_urls": allowed_logout_urls,
                "jwt_configuration": convert_and_respect_annotation_metadata(
                    object_=jwt_configuration, annotation=ClientJwtConfiguration, direction="write"
                ),
                "encryption_key": convert_and_respect_annotation_metadata(
                    object_=encryption_key, annotation=typing.Optional[ClientEncryptionKey], direction="write"
                ),
                "sso": sso,
                "cross_origin_authentication": cross_origin_authentication,
                "cross_origin_loc": cross_origin_loc,
                "sso_disabled": sso_disabled,
                "custom_login_page_on": custom_login_page_on,
                "token_endpoint_auth_method": token_endpoint_auth_method,
                "is_token_endpoint_ip_header_trusted": is_token_endpoint_ip_header_trusted,
                "app_type": app_type,
                "is_first_party": is_first_party,
                "oidc_conformant": oidc_conformant,
                "custom_login_page": custom_login_page,
                "custom_login_page_preview": custom_login_page_preview,
                "token_quota": convert_and_respect_annotation_metadata(
                    object_=token_quota, annotation=typing.Optional[UpdateTokenQuota], direction="write"
                ),
                "form_template": form_template,
                "addons": convert_and_respect_annotation_metadata(
                    object_=addons, annotation=ClientAddons, direction="write"
                ),
                "client_metadata": client_metadata,
                "mobile": convert_and_respect_annotation_metadata(
                    object_=mobile, annotation=ClientMobile, direction="write"
                ),
                "initiate_login_uri": initiate_login_uri,
                "native_social_login": convert_and_respect_annotation_metadata(
                    object_=native_social_login, annotation=NativeSocialLogin, direction="write"
                ),
                "refresh_token": convert_and_respect_annotation_metadata(
                    object_=refresh_token,
                    annotation=typing.Optional[ClientRefreshTokenConfiguration],
                    direction="write",
                ),
                "default_organization": convert_and_respect_annotation_metadata(
                    object_=default_organization,
                    annotation=typing.Optional[ClientDefaultOrganization],
                    direction="write",
                ),
                "organization_usage": organization_usage,
                "organization_require_behavior": organization_require_behavior,
                "organization_discovery_methods": organization_discovery_methods,
                "client_authentication_methods": convert_and_respect_annotation_metadata(
                    object_=client_authentication_methods,
                    annotation=typing.Optional[ClientAuthenticationMethod],
                    direction="write",
                ),
                "require_pushed_authorization_requests": require_pushed_authorization_requests,
                "require_proof_of_possession": require_proof_of_possession,
                "signed_request_object": convert_and_respect_annotation_metadata(
                    object_=signed_request_object,
                    annotation=ClientSignedRequestObjectWithCredentialId,
                    direction="write",
                ),
                "compliance_level": compliance_level,
                "skip_non_verifiable_callback_uri_confirmation_prompt": skip_non_verifiable_callback_uri_confirmation_prompt,
                "token_exchange": convert_and_respect_annotation_metadata(
                    object_=token_exchange,
                    annotation=typing.Optional[ClientTokenExchangeConfigurationOrNull],
                    direction="write",
                ),
                "par_request_expiry": par_request_expiry,
                "express_configuration": convert_and_respect_annotation_metadata(
                    object_=express_configuration,
                    annotation=typing.Optional[ExpressConfigurationOrNull],
                    direction="write",
                ),
                "async_approval_notification_channels": async_approval_notification_channels,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateClientResponseContent,
                    parse_obj_as(
                        type_=UpdateClientResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def rotate_secret(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[RotateClientSecretResponseContent]:
        """
        Rotate a client secret.

        This endpoint cannot be used with clients configured with Private Key JWT authentication method (client_authentication_methods configured with private_key_jwt). The generated secret is NOT base64 encoded.

        For more information, read <a href="https://www.auth0.com/docs/get-started/applications/rotate-client-secret">Rotate Client Secrets</a>.

        Parameters
        ----------
        id : str
            ID of the client that will rotate secrets.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RotateClientSecretResponseContent]
            Secret successfully rotated.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"clients/{jsonable_encoder(id)}/rotate-secret",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RotateClientSecretResponseContent,
                    parse_obj_as(
                        type_=RotateClientSecretResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
