# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.connection_name_prefix_template import ConnectionNamePrefixTemplate
from ..types.connection_profile import ConnectionProfile
from ..types.connection_profile_config import ConnectionProfileConfig
from ..types.connection_profile_enabled_features import ConnectionProfileEnabledFeatures
from ..types.connection_profile_name import ConnectionProfileName
from ..types.connection_profile_organization import ConnectionProfileOrganization
from ..types.connection_profile_strategy_overrides import ConnectionProfileStrategyOverrides
from ..types.create_connection_profile_response_content import CreateConnectionProfileResponseContent
from ..types.get_connection_profile_response_content import GetConnectionProfileResponseContent
from ..types.get_connection_profile_template_response_content import GetConnectionProfileTemplateResponseContent
from ..types.list_connection_profile_template_response_content import ListConnectionProfileTemplateResponseContent
from ..types.list_connection_profiles_paginated_response_content import ListConnectionProfilesPaginatedResponseContent
from ..types.update_connection_profile_response_content import UpdateConnectionProfileResponseContent
from .raw_client import AsyncRawConnectionProfilesClient, RawConnectionProfilesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConnectionProfilesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConnectionProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionProfilesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectionProfile, ListConnectionProfilesPaginatedResponseContent]:
        """
        Retrieve a list of Connection Profiles. This endpoint supports Checkpoint pagination.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 5.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectionProfile, ListConnectionProfilesPaginatedResponseContent]
            Connection Profiles successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.connection_profiles.list(
            from_="from",
            take=1,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(from_=from_, take=take, request_options=request_options)

    def create(
        self,
        *,
        name: ConnectionProfileName,
        organization: typing.Optional[ConnectionProfileOrganization] = OMIT,
        connection_name_prefix_template: typing.Optional[ConnectionNamePrefixTemplate] = OMIT,
        enabled_features: typing.Optional[ConnectionProfileEnabledFeatures] = OMIT,
        connection_config: typing.Optional[ConnectionProfileConfig] = OMIT,
        strategy_overrides: typing.Optional[ConnectionProfileStrategyOverrides] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectionProfileResponseContent:
        """
        Create a Connection Profile.

        Parameters
        ----------
        name : ConnectionProfileName

        organization : typing.Optional[ConnectionProfileOrganization]

        connection_name_prefix_template : typing.Optional[ConnectionNamePrefixTemplate]

        enabled_features : typing.Optional[ConnectionProfileEnabledFeatures]

        connection_config : typing.Optional[ConnectionProfileConfig]

        strategy_overrides : typing.Optional[ConnectionProfileStrategyOverrides]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectionProfileResponseContent
            Connection profile successfully created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.create(
            name="name",
        )
        """
        _response = self._raw_client.create(
            name=name,
            organization=organization,
            connection_name_prefix_template=connection_name_prefix_template,
            enabled_features=enabled_features,
            connection_config=connection_config,
            strategy_overrides=strategy_overrides,
            request_options=request_options,
        )
        return _response.data

    def list_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListConnectionProfileTemplateResponseContent:
        """
        Retrieve a list of Connection Profile Templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectionProfileTemplateResponseContent
            Connection Profile Templates successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.list_templates()
        """
        _response = self._raw_client.list_templates(request_options=request_options)
        return _response.data

    def get_template(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConnectionProfileTemplateResponseContent:
        """
        Retrieve a Connection Profile Template.

        Parameters
        ----------
        id : str
            ID of the connection-profile-template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionProfileTemplateResponseContent
            Connection Profile Template successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.get_template(
            id="id",
        )
        """
        _response = self._raw_client.get_template(id, request_options=request_options)
        return _response.data

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConnectionProfileResponseContent:
        """
        Retrieve details about a single Connection Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the connection-profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionProfileResponseContent
            Record for existing connection profile.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a single Connection Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the connection-profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[ConnectionProfileName] = OMIT,
        organization: typing.Optional[ConnectionProfileOrganization] = OMIT,
        connection_name_prefix_template: typing.Optional[ConnectionNamePrefixTemplate] = OMIT,
        enabled_features: typing.Optional[ConnectionProfileEnabledFeatures] = OMIT,
        connection_config: typing.Optional[ConnectionProfileConfig] = OMIT,
        strategy_overrides: typing.Optional[ConnectionProfileStrategyOverrides] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectionProfileResponseContent:
        """
        Update the details of a specific Connection Profile.

        Parameters
        ----------
        id : str
            ID of the connection profile to update.

        name : typing.Optional[ConnectionProfileName]

        organization : typing.Optional[ConnectionProfileOrganization]

        connection_name_prefix_template : typing.Optional[ConnectionNamePrefixTemplate]

        enabled_features : typing.Optional[ConnectionProfileEnabledFeatures]

        connection_config : typing.Optional[ConnectionProfileConfig]

        strategy_overrides : typing.Optional[ConnectionProfileStrategyOverrides]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectionProfileResponseContent
            Connection profile successfully updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connection_profiles.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            organization=organization,
            connection_name_prefix_template=connection_name_prefix_template,
            enabled_features=enabled_features,
            connection_config=connection_config,
            strategy_overrides=strategy_overrides,
            request_options=request_options,
        )
        return _response.data


class AsyncConnectionProfilesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionProfilesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConnectionProfilesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionProfilesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectionProfile, ListConnectionProfilesPaginatedResponseContent]:
        """
        Retrieve a list of Connection Profiles. This endpoint supports Checkpoint pagination.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 5.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectionProfile, ListConnectionProfilesPaginatedResponseContent]
            Connection Profiles successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.connection_profiles.list(
                from_="from",
                take=1,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(from_=from_, take=take, request_options=request_options)

    async def create(
        self,
        *,
        name: ConnectionProfileName,
        organization: typing.Optional[ConnectionProfileOrganization] = OMIT,
        connection_name_prefix_template: typing.Optional[ConnectionNamePrefixTemplate] = OMIT,
        enabled_features: typing.Optional[ConnectionProfileEnabledFeatures] = OMIT,
        connection_config: typing.Optional[ConnectionProfileConfig] = OMIT,
        strategy_overrides: typing.Optional[ConnectionProfileStrategyOverrides] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectionProfileResponseContent:
        """
        Create a Connection Profile.

        Parameters
        ----------
        name : ConnectionProfileName

        organization : typing.Optional[ConnectionProfileOrganization]

        connection_name_prefix_template : typing.Optional[ConnectionNamePrefixTemplate]

        enabled_features : typing.Optional[ConnectionProfileEnabledFeatures]

        connection_config : typing.Optional[ConnectionProfileConfig]

        strategy_overrides : typing.Optional[ConnectionProfileStrategyOverrides]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectionProfileResponseContent
            Connection profile successfully created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.create(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            organization=organization,
            connection_name_prefix_template=connection_name_prefix_template,
            enabled_features=enabled_features,
            connection_config=connection_config,
            strategy_overrides=strategy_overrides,
            request_options=request_options,
        )
        return _response.data

    async def list_templates(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ListConnectionProfileTemplateResponseContent:
        """
        Retrieve a list of Connection Profile Templates.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListConnectionProfileTemplateResponseContent
            Connection Profile Templates successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.list_templates()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_templates(request_options=request_options)
        return _response.data

    async def get_template(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConnectionProfileTemplateResponseContent:
        """
        Retrieve a Connection Profile Template.

        Parameters
        ----------
        id : str
            ID of the connection-profile-template to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionProfileTemplateResponseContent
            Connection Profile Template successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.get_template(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_template(id, request_options=request_options)
        return _response.data

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetConnectionProfileResponseContent:
        """
        Retrieve details about a single Connection Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the connection-profile to retrieve.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionProfileResponseContent
            Record for existing connection profile.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a single Connection Profile specified by ID.

        Parameters
        ----------
        id : str
            ID of the connection-profile to delete.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[ConnectionProfileName] = OMIT,
        organization: typing.Optional[ConnectionProfileOrganization] = OMIT,
        connection_name_prefix_template: typing.Optional[ConnectionNamePrefixTemplate] = OMIT,
        enabled_features: typing.Optional[ConnectionProfileEnabledFeatures] = OMIT,
        connection_config: typing.Optional[ConnectionProfileConfig] = OMIT,
        strategy_overrides: typing.Optional[ConnectionProfileStrategyOverrides] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectionProfileResponseContent:
        """
        Update the details of a specific Connection Profile.

        Parameters
        ----------
        id : str
            ID of the connection profile to update.

        name : typing.Optional[ConnectionProfileName]

        organization : typing.Optional[ConnectionProfileOrganization]

        connection_name_prefix_template : typing.Optional[ConnectionNamePrefixTemplate]

        enabled_features : typing.Optional[ConnectionProfileEnabledFeatures]

        connection_config : typing.Optional[ConnectionProfileConfig]

        strategy_overrides : typing.Optional[ConnectionProfileStrategyOverrides]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectionProfileResponseContent
            Connection profile successfully updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connection_profiles.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            organization=organization,
            connection_name_prefix_template=connection_name_prefix_template,
            enabled_features=enabled_features,
            connection_config=connection_config,
            strategy_overrides=strategy_overrides,
            request_options=request_options,
        )
        return _response.data
