# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.connection_authentication_purpose import ConnectionAuthenticationPurpose
from ..types.connection_connected_accounts_purpose import ConnectionConnectedAccountsPurpose
from ..types.connection_for_list import ConnectionForList
from ..types.connection_identity_provider_enum import ConnectionIdentityProviderEnum
from ..types.connection_properties_options import ConnectionPropertiesOptions
from ..types.connection_strategy_enum import ConnectionStrategyEnum
from ..types.connections_metadata import ConnectionsMetadata
from ..types.create_connection_response_content import CreateConnectionResponseContent
from ..types.get_connection_response_content import GetConnectionResponseContent
from ..types.list_connections_checkpoint_paginated_response_content import (
    ListConnectionsCheckpointPaginatedResponseContent,
)
from ..types.update_connection_options import UpdateConnectionOptions
from ..types.update_connection_response_content import UpdateConnectionResponseContent
from .raw_client import AsyncRawConnectionsClient, RawConnectionsClient

if typing.TYPE_CHECKING:
    from .clients.client import AsyncClientsClient, ClientsClient
    from .directory_provisioning.client import AsyncDirectoryProvisioningClient, DirectoryProvisioningClient
    from .keys.client import AsyncKeysClient, KeysClient
    from .scim_configuration.client import AsyncScimConfigurationClient, ScimConfigurationClient
    from .users.client import AsyncUsersClient, UsersClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConnectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConnectionsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._clients: typing.Optional[ClientsClient] = None
        self._directory_provisioning: typing.Optional[DirectoryProvisioningClient] = None
        self._keys: typing.Optional[KeysClient] = None
        self._scim_configuration: typing.Optional[ScimConfigurationClient] = None
        self._users: typing.Optional[UsersClient] = None

    @property
    def with_raw_response(self) -> RawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConnectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        name: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectionForList, ListConnectionsCheckpointPaginatedResponseContent]:
        """
        Retrieves detailed list of all <a href="https://auth0.com/docs/authenticate/identity-providers">connections</a> that match the specified strategy. If no strategy is provided, all connections within your tenant are retrieved. This action can accept a list of fields to include or exclude from the resulting list of connections.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 connections.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        name : typing.Optional[str]
            Provide the name of the connection to retrieve

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectionForList, ListConnectionsCheckpointPaginatedResponseContent]
            The connections were retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.connections.list(
            from_="from",
            take=1,
            name="name",
            fields="fields",
            include_fields=True,
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            from_=from_,
            take=take,
            strategy=strategy,
            name=name,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )

    def create(
        self,
        *,
        name: str,
        strategy: ConnectionIdentityProviderEnum,
        display_name: typing.Optional[str] = OMIT,
        options: typing.Optional[ConnectionPropertiesOptions] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        is_domain_connection: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        realms: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[ConnectionsMetadata] = OMIT,
        authentication: typing.Optional[ConnectionAuthenticationPurpose] = OMIT,
        connected_accounts: typing.Optional[ConnectionConnectedAccountsPurpose] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectionResponseContent:
        """
        Creates a new connection according to the JSON object received in <code>body</code>.<br/>

        Parameters
        ----------
        name : str
            The name of the connection. Must start and end with an alphanumeric character and can only contain alphanumeric characters and '-'. Max length 128

        strategy : ConnectionIdentityProviderEnum

        display_name : typing.Optional[str]
            Connection name used in the new universal login experience

        options : typing.Optional[ConnectionPropertiesOptions]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            DEPRECATED property. Use the PATCH /v2/connections/{id}/clients endpoint to enable the connection for a set of clients.

        is_domain_connection : typing.Optional[bool]
            <code>true</code> promotes to a domain-level connection so that third-party applications can use it. <code>false</code> does not promote the connection, so only first-party applications with the connection enabled can use it. (Defaults to <code>false</code>.)

        show_as_button : typing.Optional[bool]
            Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD. (Defaults to <code>false</code>.)

        realms : typing.Optional[typing.Sequence[str]]
            Defines the realms for which the connection will be used (ie: email domains). If the array is empty or the property is not specified, the connection name will be added as realm.

        metadata : typing.Optional[ConnectionsMetadata]

        authentication : typing.Optional[ConnectionAuthenticationPurpose]

        connected_accounts : typing.Optional[ConnectionConnectedAccountsPurpose]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectionResponseContent
            The connection was created.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.create(
            name="name",
            strategy="ad",
        )
        """
        _response = self._raw_client.create(
            name=name,
            strategy=strategy,
            display_name=display_name,
            options=options,
            enabled_clients=enabled_clients,
            is_domain_connection=is_domain_connection,
            show_as_button=show_as_button,
            realms=realms,
            metadata=metadata,
            authentication=authentication,
            connected_accounts=connected_accounts,
            request_options=request_options,
        )
        return _response.data

    def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConnectionResponseContent:
        """
        Retrieve details for a specified <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> along with options that can be used for identity provider configuration.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionResponseContent
            The connection was retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.get(
            id="id",
            fields="fields",
            include_fields=True,
        )
        """
        _response = self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Removes a specific <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> from your tenant. This action cannot be undone. Once removed, users can no longer use this connection to authenticate.

        Parameters
        ----------
        id : str
            The id of the connection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        display_name: typing.Optional[str] = OMIT,
        options: typing.Optional[UpdateConnectionOptions] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        is_domain_connection: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        realms: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[ConnectionsMetadata] = OMIT,
        authentication: typing.Optional[ConnectionAuthenticationPurpose] = OMIT,
        connected_accounts: typing.Optional[ConnectionConnectedAccountsPurpose] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectionResponseContent:
        """
        Update details for a specific <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a>, including option properties for identity provider configuration.

        <b>Note</b>: If you use the <code>options</code> parameter, the entire <code>options</code> object is overriden. To avoid partial data or other issues, ensure all parameters are present when using this option.

        Parameters
        ----------
        id : str
            The id of the connection to update

        display_name : typing.Optional[str]
            The connection name used in the new universal login experience. If display_name is not included in the request, the field will be overwritten with the name value.

        options : typing.Optional[UpdateConnectionOptions]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            DEPRECATED property. Use the PATCH /v2/connections/{id}/clients endpoint to enable or disable the connection for any clients.

        is_domain_connection : typing.Optional[bool]
            <code>true</code> promotes to a domain-level connection so that third-party applications can use it. <code>false</code> does not promote the connection, so only first-party applications with the connection enabled can use it. (Defaults to <code>false</code>.)

        show_as_button : typing.Optional[bool]
            Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD. (Defaults to <code>false</code>.)

        realms : typing.Optional[typing.Sequence[str]]
            Defines the realms for which the connection will be used (ie: email domains). If the array is empty or the property is not specified, the connection name will be added as realm.

        metadata : typing.Optional[ConnectionsMetadata]

        authentication : typing.Optional[ConnectionAuthenticationPurpose]

        connected_accounts : typing.Optional[ConnectionConnectedAccountsPurpose]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectionResponseContent
            The connection was updated.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            display_name=display_name,
            options=options,
            enabled_clients=enabled_clients,
            is_domain_connection=is_domain_connection,
            show_as_button=show_as_button,
            realms=realms,
            metadata=metadata,
            authentication=authentication,
            connected_accounts=connected_accounts,
            request_options=request_options,
        )
        return _response.data

    def check_status(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Retrieves the status of an ad/ldap connection referenced by its <code>ID</code>. <code>200 OK</code> http status code response is returned  when the connection is online, otherwise a <code>404</code> status code is returned along with an error message

        Parameters
        ----------
        id : str
            ID of the connection to check

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.check_status(
            id="id",
        )
        """
        _response = self._raw_client.check_status(id, request_options=request_options)
        return _response.data

    @property
    def clients(self):
        if self._clients is None:
            from .clients.client import ClientsClient  # noqa: E402

            self._clients = ClientsClient(client_wrapper=self._client_wrapper)
        return self._clients

    @property
    def directory_provisioning(self):
        if self._directory_provisioning is None:
            from .directory_provisioning.client import DirectoryProvisioningClient  # noqa: E402

            self._directory_provisioning = DirectoryProvisioningClient(client_wrapper=self._client_wrapper)
        return self._directory_provisioning

    @property
    def keys(self):
        if self._keys is None:
            from .keys.client import KeysClient  # noqa: E402

            self._keys = KeysClient(client_wrapper=self._client_wrapper)
        return self._keys

    @property
    def scim_configuration(self):
        if self._scim_configuration is None:
            from .scim_configuration.client import ScimConfigurationClient  # noqa: E402

            self._scim_configuration = ScimConfigurationClient(client_wrapper=self._client_wrapper)
        return self._scim_configuration

    @property
    def users(self):
        if self._users is None:
            from .users.client import UsersClient  # noqa: E402

            self._users = UsersClient(client_wrapper=self._client_wrapper)
        return self._users


class AsyncConnectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConnectionsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._clients: typing.Optional[AsyncClientsClient] = None
        self._directory_provisioning: typing.Optional[AsyncDirectoryProvisioningClient] = None
        self._keys: typing.Optional[AsyncKeysClient] = None
        self._scim_configuration: typing.Optional[AsyncScimConfigurationClient] = None
        self._users: typing.Optional[AsyncUsersClient] = None

    @property
    def with_raw_response(self) -> AsyncRawConnectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConnectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        from_: typing.Optional[str] = None,
        take: typing.Optional[int] = 50,
        strategy: typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]] = None,
        name: typing.Optional[str] = None,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectionForList, ListConnectionsCheckpointPaginatedResponseContent]:
        """
        Retrieves detailed list of all <a href="https://auth0.com/docs/authenticate/identity-providers">connections</a> that match the specified strategy. If no strategy is provided, all connections within your tenant are retrieved. This action can accept a list of fields to include or exclude from the resulting list of connections.

        This endpoint supports two types of pagination:
        <ul>
        <li>Offset pagination</li>
        <li>Checkpoint pagination</li>
        </ul>

        Checkpoint pagination must be used if you need to retrieve more than 1000 connections.

        <h2>Checkpoint Pagination</h2>

        To search by checkpoint, use the following parameters:
        <ul>
        <li><code>from</code>: Optional id from which to start selection.</li>
        <li><code>take</code>: The total amount of entries to retrieve when using the from parameter. Defaults to 50.</li>
        </ul>

        <b>Note</b>: The first time you call this endpoint using checkpoint pagination, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no pages are remaining.

        Parameters
        ----------
        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        strategy : typing.Optional[typing.Union[ConnectionStrategyEnum, typing.Sequence[ConnectionStrategyEnum]]]
            Provide strategies to only retrieve connections with such strategies

        name : typing.Optional[str]
            Provide the name of the connection to retrieve

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectionForList, ListConnectionsCheckpointPaginatedResponseContent]
            The connections were retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.connections.list(
                from_="from",
                take=1,
                name="name",
                fields="fields",
                include_fields=True,
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            from_=from_,
            take=take,
            strategy=strategy,
            name=name,
            fields=fields,
            include_fields=include_fields,
            request_options=request_options,
        )

    async def create(
        self,
        *,
        name: str,
        strategy: ConnectionIdentityProviderEnum,
        display_name: typing.Optional[str] = OMIT,
        options: typing.Optional[ConnectionPropertiesOptions] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        is_domain_connection: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        realms: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[ConnectionsMetadata] = OMIT,
        authentication: typing.Optional[ConnectionAuthenticationPurpose] = OMIT,
        connected_accounts: typing.Optional[ConnectionConnectedAccountsPurpose] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateConnectionResponseContent:
        """
        Creates a new connection according to the JSON object received in <code>body</code>.<br/>

        Parameters
        ----------
        name : str
            The name of the connection. Must start and end with an alphanumeric character and can only contain alphanumeric characters and '-'. Max length 128

        strategy : ConnectionIdentityProviderEnum

        display_name : typing.Optional[str]
            Connection name used in the new universal login experience

        options : typing.Optional[ConnectionPropertiesOptions]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            DEPRECATED property. Use the PATCH /v2/connections/{id}/clients endpoint to enable the connection for a set of clients.

        is_domain_connection : typing.Optional[bool]
            <code>true</code> promotes to a domain-level connection so that third-party applications can use it. <code>false</code> does not promote the connection, so only first-party applications with the connection enabled can use it. (Defaults to <code>false</code>.)

        show_as_button : typing.Optional[bool]
            Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD. (Defaults to <code>false</code>.)

        realms : typing.Optional[typing.Sequence[str]]
            Defines the realms for which the connection will be used (ie: email domains). If the array is empty or the property is not specified, the connection name will be added as realm.

        metadata : typing.Optional[ConnectionsMetadata]

        authentication : typing.Optional[ConnectionAuthenticationPurpose]

        connected_accounts : typing.Optional[ConnectionConnectedAccountsPurpose]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateConnectionResponseContent
            The connection was created.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.create(
                name="name",
                strategy="ad",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            strategy=strategy,
            display_name=display_name,
            options=options,
            enabled_clients=enabled_clients,
            is_domain_connection=is_domain_connection,
            show_as_button=show_as_button,
            realms=realms,
            metadata=metadata,
            authentication=authentication,
            connected_accounts=connected_accounts,
            request_options=request_options,
        )
        return _response.data

    async def get(
        self,
        id: str,
        *,
        fields: typing.Optional[str] = None,
        include_fields: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GetConnectionResponseContent:
        """
        Retrieve details for a specified <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> along with options that can be used for identity provider configuration.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve

        fields : typing.Optional[str]
            A comma separated list of fields to include or exclude (depending on include_fields) from the result, empty to retrieve all fields

        include_fields : typing.Optional[bool]
            <code>true</code> if the fields specified are to be included in the result, <code>false</code> otherwise (defaults to <code>true</code>)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetConnectionResponseContent
            The connection was retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.get(
                id="id",
                fields="fields",
                include_fields=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            id, fields=fields, include_fields=include_fields, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Removes a specific <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> from your tenant. This action cannot be undone. Once removed, users can no longer use this connection to authenticate.

        Parameters
        ----------
        id : str
            The id of the connection to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        display_name: typing.Optional[str] = OMIT,
        options: typing.Optional[UpdateConnectionOptions] = OMIT,
        enabled_clients: typing.Optional[typing.Sequence[str]] = OMIT,
        is_domain_connection: typing.Optional[bool] = OMIT,
        show_as_button: typing.Optional[bool] = OMIT,
        realms: typing.Optional[typing.Sequence[str]] = OMIT,
        metadata: typing.Optional[ConnectionsMetadata] = OMIT,
        authentication: typing.Optional[ConnectionAuthenticationPurpose] = OMIT,
        connected_accounts: typing.Optional[ConnectionConnectedAccountsPurpose] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateConnectionResponseContent:
        """
        Update details for a specific <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a>, including option properties for identity provider configuration.

        <b>Note</b>: If you use the <code>options</code> parameter, the entire <code>options</code> object is overriden. To avoid partial data or other issues, ensure all parameters are present when using this option.

        Parameters
        ----------
        id : str
            The id of the connection to update

        display_name : typing.Optional[str]
            The connection name used in the new universal login experience. If display_name is not included in the request, the field will be overwritten with the name value.

        options : typing.Optional[UpdateConnectionOptions]

        enabled_clients : typing.Optional[typing.Sequence[str]]
            DEPRECATED property. Use the PATCH /v2/connections/{id}/clients endpoint to enable or disable the connection for any clients.

        is_domain_connection : typing.Optional[bool]
            <code>true</code> promotes to a domain-level connection so that third-party applications can use it. <code>false</code> does not promote the connection, so only first-party applications with the connection enabled can use it. (Defaults to <code>false</code>.)

        show_as_button : typing.Optional[bool]
            Enables showing a button for the connection in the login page (new experience only). If false, it will be usable only by HRD. (Defaults to <code>false</code>.)

        realms : typing.Optional[typing.Sequence[str]]
            Defines the realms for which the connection will be used (ie: email domains). If the array is empty or the property is not specified, the connection name will be added as realm.

        metadata : typing.Optional[ConnectionsMetadata]

        authentication : typing.Optional[ConnectionAuthenticationPurpose]

        connected_accounts : typing.Optional[ConnectionConnectedAccountsPurpose]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateConnectionResponseContent
            The connection was updated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            display_name=display_name,
            options=options,
            enabled_clients=enabled_clients,
            is_domain_connection=is_domain_connection,
            show_as_button=show_as_button,
            realms=realms,
            metadata=metadata,
            authentication=authentication,
            connected_accounts=connected_accounts,
            request_options=request_options,
        )
        return _response.data

    async def check_status(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Retrieves the status of an ad/ldap connection referenced by its <code>ID</code>. <code>200 OK</code> http status code response is returned  when the connection is online, otherwise a <code>404</code> status code is returned along with an error message

        Parameters
        ----------
        id : str
            ID of the connection to check

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.check_status(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.check_status(id, request_options=request_options)
        return _response.data

    @property
    def clients(self):
        if self._clients is None:
            from .clients.client import AsyncClientsClient  # noqa: E402

            self._clients = AsyncClientsClient(client_wrapper=self._client_wrapper)
        return self._clients

    @property
    def directory_provisioning(self):
        if self._directory_provisioning is None:
            from .directory_provisioning.client import AsyncDirectoryProvisioningClient  # noqa: E402

            self._directory_provisioning = AsyncDirectoryProvisioningClient(client_wrapper=self._client_wrapper)
        return self._directory_provisioning

    @property
    def keys(self):
        if self._keys is None:
            from .keys.client import AsyncKeysClient  # noqa: E402

            self._keys = AsyncKeysClient(client_wrapper=self._client_wrapper)
        return self._keys

    @property
    def scim_configuration(self):
        if self._scim_configuration is None:
            from .scim_configuration.client import AsyncScimConfigurationClient  # noqa: E402

            self._scim_configuration = AsyncScimConfigurationClient(client_wrapper=self._client_wrapper)
        return self._scim_configuration

    @property
    def users(self):
        if self._users is None:
            from .users.client import AsyncUsersClient  # noqa: E402

            self._users = AsyncUsersClient(client_wrapper=self._client_wrapper)
        return self._users
