# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...types.connection_enabled_client import ConnectionEnabledClient
from ...types.get_connection_enabled_clients_response_content import GetConnectionEnabledClientsResponseContent
from ...types.update_enabled_client_connections_request_content import UpdateEnabledClientConnectionsRequestContent
from .raw_client import AsyncRawClientsClient, RawClientsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ClientsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawClientsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawClientsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawClientsClient
        """
        return self._raw_client

    def get(
        self,
        id: str,
        *,
        take: typing.Optional[int] = 50,
        from_: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ConnectionEnabledClient, GetConnectionEnabledClientsResponseContent]:
        """
        Retrieve all clients that have the specified <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> enabled.

        <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.

        Parameters
        ----------
        id : str
            The id of the connection for which enabled clients are to be retrieved

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ConnectionEnabledClient, GetConnectionEnabledClientsResponseContent]
            Success

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        response = client.connections.clients.get(
            id="id",
            take=1,
            from_="from",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.get(id, take=take, from_=from_, request_options=request_options)

    def update(
        self,
        id: str,
        *,
        request: UpdateEnabledClientConnectionsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str
            The id of the connection to modify

        request : UpdateEnabledClientConnectionsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0, UpdateEnabledClientConnectionsRequestContentItem

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.clients.update(
            id="id",
            request=[
                UpdateEnabledClientConnectionsRequestContentItem(
                    client_id="client_id",
                    status=True,
                )
            ],
        )
        """
        _response = self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data


class AsyncClientsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawClientsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawClientsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawClientsClient
        """
        return self._raw_client

    async def get(
        self,
        id: str,
        *,
        take: typing.Optional[int] = 50,
        from_: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ConnectionEnabledClient, GetConnectionEnabledClientsResponseContent]:
        """
        Retrieve all clients that have the specified <a href="https://auth0.com/docs/authenticate/identity-providers">connection</a> enabled.

        <b>Note</b>: The first time you call this endpoint, omit the <code>from</code> parameter. If there are more results, a <code>next</code> value is included in the response. You can use this for subsequent API calls. When <code>next</code> is no longer included in the response, no further results are remaining.

        Parameters
        ----------
        id : str
            The id of the connection for which enabled clients are to be retrieved

        take : typing.Optional[int]
            Number of results per page. Defaults to 50.

        from_ : typing.Optional[str]
            Optional Id from which to start selection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ConnectionEnabledClient, GetConnectionEnabledClientsResponseContent]
            Success

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.connections.clients.get(
                id="id",
                take=1,
                from_="from",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.get(id, take=take, from_=from_, request_options=request_options)

    async def update(
        self,
        id: str,
        *,
        request: UpdateEnabledClientConnectionsRequestContent,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        id : str
            The id of the connection to modify

        request : UpdateEnabledClientConnectionsRequestContent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, UpdateEnabledClientConnectionsRequestContentItem

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.clients.update(
                id="id",
                request=[
                    UpdateEnabledClientConnectionsRequestContentItem(
                        client_id="client_id",
                        status=True,
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data
