# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_directory_provisioning_request_content import CreateDirectoryProvisioningRequestContent
from ...types.create_directory_provisioning_response_content import CreateDirectoryProvisioningResponseContent
from ...types.get_directory_provisioning_default_mapping_response_content import (
    GetDirectoryProvisioningDefaultMappingResponseContent,
)
from ...types.get_directory_provisioning_response_content import GetDirectoryProvisioningResponseContent
from ...types.update_directory_provisioning_request_content import UpdateDirectoryProvisioningRequestContent
from ...types.update_directory_provisioning_response_content import UpdateDirectoryProvisioningResponseContent
from .raw_client import AsyncRawDirectoryProvisioningClient, RawDirectoryProvisioningClient

if typing.TYPE_CHECKING:
    from .synchronizations.client import AsyncSynchronizationsClient, SynchronizationsClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DirectoryProvisioningClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDirectoryProvisioningClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._synchronizations: typing.Optional[SynchronizationsClient] = None

    @property
    def with_raw_response(self) -> RawDirectoryProvisioningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDirectoryProvisioningClient
        """
        return self._raw_client

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDirectoryProvisioningResponseContent:
        """
        Retrieve the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateDirectoryProvisioningRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateDirectoryProvisioningResponseContent:
        """
        Create a directory provisioning configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its directory provisioning configuration

        request : typing.Optional[CreateDirectoryProvisioningRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0, CreateDirectoryProvisioningRequestContent

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.create(
            id="id",
            request=CreateDirectoryProvisioningRequestContent(),
        )
        """
        _response = self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to delete its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        request: typing.Optional[UpdateDirectoryProvisioningRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateDirectoryProvisioningResponseContent:
        """
        Update the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its directory provisioning configuration

        request : typing.Optional[UpdateDirectoryProvisioningRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration was updated. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0, UpdateDirectoryProvisioningRequestContent

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.update(
            id="id",
            request=UpdateDirectoryProvisioningRequestContent(),
        )
        """
        _response = self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data

    def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDirectoryProvisioningDefaultMappingResponseContent:
        """
        Retrieve the directory provisioning default attribute mapping of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDirectoryProvisioningDefaultMappingResponseContent
            The connection's directory provisioning default mapping. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.get_default_mapping(
            id="id",
        )
        """
        _response = self._raw_client.get_default_mapping(id, request_options=request_options)
        return _response.data

    @property
    def synchronizations(self):
        if self._synchronizations is None:
            from .synchronizations.client import SynchronizationsClient  # noqa: E402

            self._synchronizations = SynchronizationsClient(client_wrapper=self._client_wrapper)
        return self._synchronizations


class AsyncDirectoryProvisioningClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDirectoryProvisioningClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._synchronizations: typing.Optional[AsyncSynchronizationsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawDirectoryProvisioningClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDirectoryProvisioningClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDirectoryProvisioningResponseContent:
        """
        Retrieve the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateDirectoryProvisioningRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateDirectoryProvisioningResponseContent:
        """
        Create a directory provisioning configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its directory provisioning configuration

        request : typing.Optional[CreateDirectoryProvisioningRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, CreateDirectoryProvisioningRequestContent

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.create(
                id="id",
                request=CreateDirectoryProvisioningRequestContent(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to delete its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        request: typing.Optional[UpdateDirectoryProvisioningRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateDirectoryProvisioningResponseContent:
        """
        Update the directory provisioning configuration of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its directory provisioning configuration

        request : typing.Optional[UpdateDirectoryProvisioningRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateDirectoryProvisioningResponseContent
            The connection's directory provisioning configuration was updated. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, UpdateDirectoryProvisioningRequestContent

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.update(
                id="id",
                request=UpdateDirectoryProvisioningRequestContent(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(id, request=request, request_options=request_options)
        return _response.data

    async def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetDirectoryProvisioningDefaultMappingResponseContent:
        """
        Retrieve the directory provisioning default attribute mapping of a connection.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its directory provisioning configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetDirectoryProvisioningDefaultMappingResponseContent
            The connection's directory provisioning default mapping. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.get_default_mapping(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_default_mapping(id, request_options=request_options)
        return _response.data

    @property
    def synchronizations(self):
        if self._synchronizations is None:
            from .synchronizations.client import AsyncSynchronizationsClient  # noqa: E402

            self._synchronizations = AsyncSynchronizationsClient(client_wrapper=self._client_wrapper)
        return self._synchronizations
