# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.create_directory_synchronization_response_content import CreateDirectorySynchronizationResponseContent
from .raw_client import AsyncRawSynchronizationsClient, RawSynchronizationsClient


class SynchronizationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSynchronizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSynchronizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSynchronizationsClient
        """
        return self._raw_client

    def create(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateDirectorySynchronizationResponseContent:
        """
        Request an on-demand synchronization of the directory.

        Parameters
        ----------
        id : str
            The id of the connection to trigger synchronization for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDirectorySynchronizationResponseContent
            The directory synchronization was triggered. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.directory_provisioning.synchronizations.create(
            id="id",
        )
        """
        _response = self._raw_client.create(id, request_options=request_options)
        return _response.data


class AsyncSynchronizationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSynchronizationsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSynchronizationsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSynchronizationsClient
        """
        return self._raw_client

    async def create(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateDirectorySynchronizationResponseContent:
        """
        Request an on-demand synchronization of the directory.

        Parameters
        ----------
        id : str
            The id of the connection to trigger synchronization for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateDirectorySynchronizationResponseContent
            The directory synchronization was triggered. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.directory_provisioning.synchronizations.create(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, request_options=request_options)
        return _response.data
