# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.connection_key import ConnectionKey
from ...types.rotate_connection_keys_request_content import RotateConnectionKeysRequestContent
from ...types.rotate_connections_keys_response_content import RotateConnectionsKeysResponseContent
from .raw_client import AsyncRawKeysClient, RawKeysClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class KeysClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawKeysClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> typing.List[ConnectionKey]:
        """
        Gets the connection keys for the Okta or OIDC connection strategy.

        Parameters
        ----------
        id : str
            ID of the connection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConnectionKey]
            Connection keys successfully retrieved.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.keys.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def rotate(
        self,
        id: str,
        *,
        request: typing.Optional[RotateConnectionKeysRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RotateConnectionsKeysResponseContent:
        """
        Rotates the connection keys for the Okta or OIDC connection strategies.

        Parameters
        ----------
        id : str
            ID of the connection

        request : typing.Optional[RotateConnectionKeysRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateConnectionsKeysResponseContent
            Connection keys successfully rotated.

        Examples
        --------
        from auth0 import Auth0, RotateConnectionKeysRequestContent

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.keys.rotate(
            id="id",
            request=RotateConnectionKeysRequestContent(),
        )
        """
        _response = self._raw_client.rotate(id, request=request, request_options=request_options)
        return _response.data


class AsyncKeysClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawKeysClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawKeysClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawKeysClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ConnectionKey]:
        """
        Gets the connection keys for the Okta or OIDC connection strategy.

        Parameters
        ----------
        id : str
            ID of the connection

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ConnectionKey]
            Connection keys successfully retrieved.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.keys.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def rotate(
        self,
        id: str,
        *,
        request: typing.Optional[RotateConnectionKeysRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RotateConnectionsKeysResponseContent:
        """
        Rotates the connection keys for the Okta or OIDC connection strategies.

        Parameters
        ----------
        id : str
            ID of the connection

        request : typing.Optional[RotateConnectionKeysRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateConnectionsKeysResponseContent
            Connection keys successfully rotated.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, RotateConnectionKeysRequestContent

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.keys.rotate(
                id="id",
                request=RotateConnectionKeysRequestContent(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.rotate(id, request=request, request_options=request_options)
        return _response.data
