# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_scim_configuration_request_content import CreateScimConfigurationRequestContent
from ...types.create_scim_configuration_response_content import CreateScimConfigurationResponseContent
from ...types.get_scim_configuration_default_mapping_response_content import (
    GetScimConfigurationDefaultMappingResponseContent,
)
from ...types.get_scim_configuration_response_content import GetScimConfigurationResponseContent
from ...types.scim_mapping_item import ScimMappingItem
from ...types.update_scim_configuration_response_content import UpdateScimConfigurationResponseContent
from .raw_client import AsyncRawScimConfigurationClient, RawScimConfigurationClient

if typing.TYPE_CHECKING:
    from .tokens.client import AsyncTokensClient, TokensClient
# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ScimConfigurationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawScimConfigurationClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._tokens: typing.Optional[TokensClient] = None

    @property
    def with_raw_response(self) -> RawScimConfigurationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawScimConfigurationClient
        """
        return self._raw_client

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScimConfigurationResponseContent:
        """
        Retrieves a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimConfigurationResponseContent
            The connection's SCIM configuration was retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateScimConfigurationRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateScimConfigurationResponseContent:
        """
        Create a scim configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM configuration

        request : typing.Optional[CreateScimConfigurationRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateScimConfigurationResponseContent
            The connection's SCIM configuration was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0, CreateScimConfigurationRequestContent

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.create(
            id="id",
            request=CreateScimConfigurationRequestContent(),
        )
        """
        _response = self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to delete its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        user_id_attribute: str,
        mapping: typing.Sequence[ScimMappingItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateScimConfigurationResponseContent:
        """
        Update a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to update its SCIM configuration

        user_id_attribute : str
            User ID attribute for generating unique user ids

        mapping : typing.Sequence[ScimMappingItem]
            The mapping between auth0 and SCIM

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateScimConfigurationResponseContent
            The connection's SCIM configuration was updated. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0, ScimMappingItem

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.update(
            id="id",
            user_id_attribute="user_id_attribute",
            mapping=[ScimMappingItem()],
        )
        """
        _response = self._raw_client.update(
            id, user_id_attribute=user_id_attribute, mapping=mapping, request_options=request_options
        )
        return _response.data

    def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScimConfigurationDefaultMappingResponseContent:
        """
        Retrieves a scim configuration's default mapping by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its default SCIM mapping

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimConfigurationDefaultMappingResponseContent
            The connection's default SCIM mapping was retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.get_default_mapping(
            id="id",
        )
        """
        _response = self._raw_client.get_default_mapping(id, request_options=request_options)
        return _response.data

    @property
    def tokens(self):
        if self._tokens is None:
            from .tokens.client import TokensClient  # noqa: E402

            self._tokens = TokensClient(client_wrapper=self._client_wrapper)
        return self._tokens


class AsyncScimConfigurationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawScimConfigurationClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._tokens: typing.Optional[AsyncTokensClient] = None

    @property
    def with_raw_response(self) -> AsyncRawScimConfigurationClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawScimConfigurationClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScimConfigurationResponseContent:
        """
        Retrieves a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimConfigurationResponseContent
            The connection's SCIM configuration was retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateScimConfigurationRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateScimConfigurationResponseContent:
        """
        Create a scim configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM configuration

        request : typing.Optional[CreateScimConfigurationRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateScimConfigurationResponseContent
            The connection's SCIM configuration was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, CreateScimConfigurationRequestContent

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.create(
                id="id",
                request=CreateScimConfigurationRequestContent(),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(id, request=request, request_options=request_options)
        return _response.data

    async def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to delete its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        user_id_attribute: str,
        mapping: typing.Sequence[ScimMappingItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateScimConfigurationResponseContent:
        """
        Update a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to update its SCIM configuration

        user_id_attribute : str
            User ID attribute for generating unique user ids

        mapping : typing.Sequence[ScimMappingItem]
            The mapping between auth0 and SCIM

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateScimConfigurationResponseContent
            The connection's SCIM configuration was updated. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0, ScimMappingItem

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.update(
                id="id",
                user_id_attribute="user_id_attribute",
                mapping=[ScimMappingItem()],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id, user_id_attribute=user_id_attribute, mapping=mapping, request_options=request_options
        )
        return _response.data

    async def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScimConfigurationDefaultMappingResponseContent:
        """
        Retrieves a scim configuration's default mapping by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its default SCIM mapping

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimConfigurationDefaultMappingResponseContent
            The connection's default SCIM mapping was retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.get_default_mapping(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_default_mapping(id, request_options=request_options)
        return _response.data

    @property
    def tokens(self):
        if self._tokens is None:
            from .tokens.client import AsyncTokensClient  # noqa: E402

            self._tokens = AsyncTokensClient(client_wrapper=self._client_wrapper)
        return self._tokens
