# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pydantic_utilities import parse_obj_as
from ...core.request_options import RequestOptions
from ...core.serialization import convert_and_respect_annotation_metadata
from ...errors.bad_request_error import BadRequestError
from ...errors.not_found_error import NotFoundError
from ...types.create_scim_configuration_request_content import CreateScimConfigurationRequestContent
from ...types.create_scim_configuration_response_content import CreateScimConfigurationResponseContent
from ...types.get_scim_configuration_default_mapping_response_content import (
    GetScimConfigurationDefaultMappingResponseContent,
)
from ...types.get_scim_configuration_response_content import GetScimConfigurationResponseContent
from ...types.scim_mapping_item import ScimMappingItem
from ...types.update_scim_configuration_response_content import UpdateScimConfigurationResponseContent

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawScimConfigurationClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetScimConfigurationResponseContent]:
        """
        Retrieves a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetScimConfigurationResponseContent]
            The connection's SCIM configuration was retrieved. See <strong>Response Schemas</strong> for schema.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=GetScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateScimConfigurationRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateScimConfigurationResponseContent]:
        """
        Create a scim configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM configuration

        request : typing.Optional[CreateScimConfigurationRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateScimConfigurationResponseContent]
            The connection's SCIM configuration was created. See <strong>Response Schemas</strong> for schema.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=typing.Optional[CreateScimConfigurationRequestContent], direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=CreateScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[None]:
        """
        Deletes a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to delete its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        id: str,
        *,
        user_id_attribute: str,
        mapping: typing.Sequence[ScimMappingItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[UpdateScimConfigurationResponseContent]:
        """
        Update a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to update its SCIM configuration

        user_id_attribute : str
            User ID attribute for generating unique user ids

        mapping : typing.Sequence[ScimMappingItem]
            The mapping between auth0 and SCIM

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[UpdateScimConfigurationResponseContent]
            The connection's SCIM configuration was updated. See <strong>Response Schemas</strong> for schema.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="PATCH",
            json={
                "user_id_attribute": user_id_attribute,
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Sequence[ScimMappingItem], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=UpdateScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetScimConfigurationDefaultMappingResponseContent]:
        """
        Retrieves a scim configuration's default mapping by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its default SCIM mapping

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetScimConfigurationDefaultMappingResponseContent]
            The connection's default SCIM mapping was retrieved. See <strong>Response Schemas</strong> for schema.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration/default-mapping",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetScimConfigurationDefaultMappingResponseContent,
                    parse_obj_as(
                        type_=GetScimConfigurationDefaultMappingResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawScimConfigurationClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetScimConfigurationResponseContent]:
        """
        Retrieves a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetScimConfigurationResponseContent]
            The connection's SCIM configuration was retrieved. See <strong>Response Schemas</strong> for schema.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=GetScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        id: str,
        *,
        request: typing.Optional[CreateScimConfigurationRequestContent] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateScimConfigurationResponseContent]:
        """
        Create a scim configuration for a connection.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM configuration

        request : typing.Optional[CreateScimConfigurationRequestContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateScimConfigurationResponseContent]
            The connection's SCIM configuration was created. See <strong>Response Schemas</strong> for schema.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=typing.Optional[CreateScimConfigurationRequestContent], direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=CreateScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Deletes a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to delete its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        id: str,
        *,
        user_id_attribute: str,
        mapping: typing.Sequence[ScimMappingItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[UpdateScimConfigurationResponseContent]:
        """
        Update a scim configuration by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to update its SCIM configuration

        user_id_attribute : str
            User ID attribute for generating unique user ids

        mapping : typing.Sequence[ScimMappingItem]
            The mapping between auth0 and SCIM

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[UpdateScimConfigurationResponseContent]
            The connection's SCIM configuration was updated. See <strong>Response Schemas</strong> for schema.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration",
            method="PATCH",
            json={
                "user_id_attribute": user_id_attribute,
                "mapping": convert_and_respect_annotation_metadata(
                    object_=mapping, annotation=typing.Sequence[ScimMappingItem], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    UpdateScimConfigurationResponseContent,
                    parse_obj_as(
                        type_=UpdateScimConfigurationResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_default_mapping(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetScimConfigurationDefaultMappingResponseContent]:
        """
        Retrieves a scim configuration's default mapping by its <code>connectionId</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its default SCIM mapping

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetScimConfigurationDefaultMappingResponseContent]
            The connection's default SCIM mapping was retrieved. See <strong>Response Schemas</strong> for schema.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"connections/{jsonable_encoder(id)}/scim-configuration/default-mapping",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetScimConfigurationDefaultMappingResponseContent,
                    parse_obj_as(
                        type_=GetScimConfigurationDefaultMappingResponseContent,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        parse_obj_as(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
