# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ....types.create_scim_token_response_content import CreateScimTokenResponseContent
from ....types.get_scim_tokens_response_content import GetScimTokensResponseContent
from .raw_client import AsyncRawTokensClient, RawTokensClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TokensClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTokensClient
        """
        return self._raw_client

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> GetScimTokensResponseContent:
        """
        Retrieves all scim tokens by its connection <code>id</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimTokensResponseContent
            The connection's SCIM tokens were retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.tokens.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def create(
        self,
        id: str,
        *,
        scopes: typing.Optional[typing.Sequence[str]] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateScimTokenResponseContent:
        """
        Create a scim token for a scim client.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM token

        scopes : typing.Optional[typing.Sequence[str]]
            The scopes of the scim token

        token_lifetime : typing.Optional[int]
            Lifetime of the token in seconds. Must be greater than 900

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateScimTokenResponseContent
            The connection's SCIM token was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.tokens.create(
            id="id",
        )
        """
        _response = self._raw_client.create(
            id, scopes=scopes, token_lifetime=token_lifetime, request_options=request_options
        )
        return _response.data

    def delete(self, id: str, token_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a scim token by its connection <code>id</code> and <code>tokenId</code>.

        Parameters
        ----------
        id : str
            The connection id that owns the SCIM token to delete

        token_id : str
            The id of the scim token to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.scim_configuration.tokens.delete(
            id="id",
            token_id="tokenId",
        )
        """
        _response = self._raw_client.delete(id, token_id, request_options=request_options)
        return _response.data


class AsyncTokensClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTokensClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTokensClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTokensClient
        """
        return self._raw_client

    async def get(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetScimTokensResponseContent:
        """
        Retrieves all scim tokens by its connection <code>id</code>.

        Parameters
        ----------
        id : str
            The id of the connection to retrieve its SCIM configuration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetScimTokensResponseContent
            The connection's SCIM tokens were retrieved. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.tokens.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def create(
        self,
        id: str,
        *,
        scopes: typing.Optional[typing.Sequence[str]] = OMIT,
        token_lifetime: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateScimTokenResponseContent:
        """
        Create a scim token for a scim client.

        Parameters
        ----------
        id : str
            The id of the connection to create its SCIM token

        scopes : typing.Optional[typing.Sequence[str]]
            The scopes of the scim token

        token_lifetime : typing.Optional[int]
            Lifetime of the token in seconds. Must be greater than 900

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateScimTokenResponseContent
            The connection's SCIM token was created. See <strong>Response Schemas</strong> for schema.

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.tokens.create(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            id, scopes=scopes, token_lifetime=token_lifetime, request_options=request_options
        )
        return _response.data

    async def delete(self, id: str, token_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a scim token by its connection <code>id</code> and <code>tokenId</code>.

        Parameters
        ----------
        id : str
            The connection id that owns the SCIM token to delete

        token_id : str
            The id of the scim token to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.scim_configuration.tokens.delete(
                id="id",
                token_id="tokenId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, token_id, request_options=request_options)
        return _response.data
