# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawUsersClient, RawUsersClient


class UsersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsersClient
        """
        return self._raw_client

    def delete_by_email(self, id: str, *, email: str, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Deletes a specified connection user by its email (you cannot delete all users from specific connection). Currently, only Database Connections are supported.

        Parameters
        ----------
        id : str
            The id of the connection (currently only database connections are supported)

        email : str
            The email of the user to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from auth0 import Auth0

        client = Auth0(
            token="YOUR_TOKEN",
        )
        client.connections.users.delete_by_email(
            id="id",
            email="email",
        )
        """
        _response = self._raw_client.delete_by_email(id, email=email, request_options=request_options)
        return _response.data


class AsyncUsersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsersClient
        """
        return self._raw_client

    async def delete_by_email(
        self, id: str, *, email: str, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Deletes a specified connection user by its email (you cannot delete all users from specific connection). Currently, only Database Connections are supported.

        Parameters
        ----------
        id : str
            The id of the connection (currently only database connections are supported)

        email : str
            The email of the user to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from auth0 import AsyncAuth0

        client = AsyncAuth0(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.connections.users.delete_by_email(
                id="id",
                email="email",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_email(id, email=email, request_options=request_options)
        return _response.data
